/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdgeLabel;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphIndex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusPropertyKey;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.query.AtlasJanusGraphQuery;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;

public final class GraphDbObjectFactory {
    private GraphDbObjectFactory() {
    }

    public static AtlasJanusEdge createEdge(AtlasJanusGraph graph, Edge source) {
        if (source == null) {
            return null;
        }
        return new AtlasJanusEdge(graph, source);
    }

    public static AtlasJanusGraphQuery createQuery(AtlasJanusGraph graph, boolean isChildQuery) {
        return new AtlasJanusGraphQuery(graph, isChildQuery);
    }

    public static AtlasJanusVertex createVertex(AtlasJanusGraph graph, Vertex source) {
        if (source == null) {
            return null;
        }
        return new AtlasJanusVertex(graph, source);
    }

    public static AtlasJanusPropertyKey createPropertyKey(PropertyKey propertyKey) {
        if (propertyKey == null) {
            return null;
        }
        return new AtlasJanusPropertyKey(propertyKey);
    }

    public static AtlasJanusEdgeLabel createEdgeLabel(EdgeLabel label) {
        if (label == null) {
            return null;
        }
        return new AtlasJanusEdgeLabel(label);
    }

    public static AtlasGraphIndex createGraphIndex(JanusGraphIndex index) {
        if (index == null) {
            return null;
        }
        return new AtlasJanusGraphIndex(index);
    }

    public static AtlasCardinality createCardinality(Cardinality cardinality) {
        if (cardinality == Cardinality.SINGLE) {
            return AtlasCardinality.SINGLE;
        }
        if (cardinality == Cardinality.LIST) {
            return AtlasCardinality.LIST;
        }
        return AtlasCardinality.SET;
    }
}

