/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.StringUtils;

public class RelationshipCacheGenerator {
    public static Map<String, TypeInfo> get(AtlasTypeRegistry typeRegistry) {
        HashMap<String, TypeInfo> ret = new HashMap<String, TypeInfo>();
        for (AtlasRelationshipType relType : typeRegistry.getAllRelationshipTypes()) {
            AtlasRelationshipDef relDef = relType.getRelationshipDef();
            String relTypeName = relType.getTypeName();
            RelationshipCacheGenerator.add(ret, RelationshipCacheGenerator.getKey(relDef.getEndDef1()), relTypeName, relDef.getPropagateTags());
            RelationshipCacheGenerator.add(ret, RelationshipCacheGenerator.getKey(relDef.getEndDef2()), relTypeName, RelationshipCacheGenerator.getEnd2PropagateTag(relDef.getPropagateTags()));
        }
        return ret;
    }

    private static String getKey(AtlasRelationshipEndDef endDef) {
        return RelationshipCacheGenerator.getKey(endDef.getIsLegacyAttribute(), endDef.getType(), endDef.getName());
    }

    private static String getKey(String lhs, String rhs) {
        return String.format("%s%s.%s", "__", lhs, rhs);
    }

    private static String getKey(boolean isLegacy, String entityTypeName, String relEndName) {
        if (!isLegacy) {
            return "";
        }
        return RelationshipCacheGenerator.getKey(entityTypeName, relEndName);
    }

    private static void add(Map<String, TypeInfo> map, String key, String relationTypeName, AtlasRelationshipDef.PropagateTags propagateTags) {
        if (StringUtils.isEmpty((String)key) || map.containsKey(key)) {
            return;
        }
        map.put(key, new TypeInfo(relationTypeName, propagateTags));
    }

    private static AtlasRelationshipDef.PropagateTags getEnd2PropagateTag(AtlasRelationshipDef.PropagateTags end1PropagateTags) {
        if (end1PropagateTags == AtlasRelationshipDef.PropagateTags.ONE_TO_TWO) {
            return AtlasRelationshipDef.PropagateTags.TWO_TO_ONE;
        }
        if (end1PropagateTags == AtlasRelationshipDef.PropagateTags.TWO_TO_ONE) {
            return AtlasRelationshipDef.PropagateTags.ONE_TO_TWO;
        }
        return end1PropagateTags;
    }

    public static class TypeInfo
    extends TypesUtil.Pair<String, AtlasRelationshipDef.PropagateTags> {
        public TypeInfo(String typeName, AtlasRelationshipDef.PropagateTags propagateTags) {
            super((Object)typeName, (Object)propagateTags);
        }

        public String getTypeName() {
            return (String)this.left;
        }

        public AtlasRelationshipDef.PropagateTags getPropagateTags() {
            return (AtlasRelationshipDef.PropagateTags)this.right;
        }
    }
}

