/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration.pc;

import com.google.common.base.Stopwatch;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkItemConsumer<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WorkItemConsumer.class);
    private static final int POLLING_DURATION_SECONDS = 5;
    private final BlockingQueue<T> queue;
    private boolean isDirty = false;
    private long maxCommitTimeSeconds = 0L;

    public WorkItemConsumer(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                T item = this.queue.poll(5L, TimeUnit.SECONDS);
                if (item == null) {
                    this.commitDirty();
                    return;
                }
                this.isDirty = true;
                this.processItem(item);
            }
            catch (InterruptedException e) {
                LOG.error("WorkItemConsumer: Interrupted: ", (Throwable)e);
            }
        }
    }

    public long getMaxCommitTimeSeconds() {
        return this.maxCommitTimeSeconds > 0L ? this.maxCommitTimeSeconds : 15L;
    }

    protected void commitDirty() {
        if (!this.isDirty) {
            return;
        }
        LOG.info("isDirty");
        this.commit();
    }

    protected void commit() {
        Stopwatch sw = Stopwatch.createStarted();
        this.doCommit();
        sw.stop();
        this.updateCommitTime(sw.elapsed(TimeUnit.SECONDS));
        this.isDirty = false;
    }

    protected abstract void doCommit();

    protected abstract void processItem(T var1);

    protected void updateCommitTime(long commitTime) {
        if (this.maxCommitTimeSeconds < commitTime) {
            this.maxCommitTimeSeconds = commitTime;
        }
    }
}

