/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration.postProcess;

import org.apache.atlas.repository.Constants;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessListProperty {
    private static final Logger LOG = LoggerFactory.getLogger(PostProcessListProperty.class);

    public void process(Vertex v, String typeName, String propertyName) {
        try {
            if (this.doesNotHaveProperty(v, typeName) || !this.hasProperty(v, propertyName)) {
                return;
            }
            this.removeProperty(v, propertyName);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("process: IllegalArgumentException: v[{}] error!", v.id(), (Object)ex);
        }
    }

    protected void removeProperty(Vertex v, String propertyName) {
        v.property(propertyName).remove();
    }

    protected boolean doesNotHaveProperty(Vertex v, String typeName) {
        return v.property(Constants.TYPENAME_PROPERTY_KEY).isPresent() || !this.isInstanceVertexOfType(v, typeName);
    }

    private boolean hasProperty(Vertex v, String propertyName) {
        try {
            return v.property(propertyName).isPresent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isInstanceVertexOfType(Vertex v, String typeName) {
        if (v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).isPresent()) {
            String s = (String)v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).value();
            return s.equals(typeName);
        }
        return false;
    }
}

