/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.kafka;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.kafka.AtlasKafkaConsumer;
import org.apache.atlas.notification.AbstractNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.service.Service;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class KafkaNotification
extends AbstractNotification
implements Service {
    public static final Logger LOG = LoggerFactory.getLogger(KafkaNotification.class);
    public static final String PROPERTY_PREFIX = "atlas.kafka";
    public static final String ATLAS_HOOK_TOPIC = AtlasConfiguration.NOTIFICATION_HOOK_TOPIC_NAME.getString();
    public static final String ATLAS_ENTITIES_TOPIC = AtlasConfiguration.NOTIFICATION_ENTITIES_TOPIC_NAME.getString();
    protected static final String CONSUMER_GROUP_ID_PROPERTY = "group.id";
    private static final String DEFAULT_CONSUMER_CLOSED_ERROR_MESSAGE = "This consumer has already been closed.";
    private static final Map<NotificationInterface.NotificationType, String> TOPIC_MAP = new HashMap<NotificationInterface.NotificationType, String>(){
        {
            this.put(NotificationInterface.NotificationType.HOOK, ATLAS_HOOK_TOPIC);
            this.put(NotificationInterface.NotificationType.ENTITIES, ATLAS_ENTITIES_TOPIC);
        }
    };
    private final Properties properties;
    private final Long pollTimeOutMs;
    private KafkaConsumer consumer;
    private KafkaProducer producer;
    private String consumerClosedErrorMsg;

    @Inject
    public KafkaNotification(Configuration applicationProperties) throws AtlasException {
        super(applicationProperties);
        LOG.info("==> KafkaNotification()");
        Configuration kafkaConf = ApplicationProperties.getSubsetConfiguration((Configuration)applicationProperties, (String)PROPERTY_PREFIX);
        this.properties = ConfigurationConverter.getProperties((Configuration)kafkaConf);
        this.pollTimeOutMs = kafkaConf.getLong("poll.timeout.ms", 1000L);
        this.consumerClosedErrorMsg = kafkaConf.getString("error.message.consumer_closed", DEFAULT_CONSUMER_CLOSED_ERROR_MESSAGE);
        this.properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.properties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.properties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.properties.put("auto.offset.reset", "earliest");
        boolean oldApiCommitEnableFlag = kafkaConf.getBoolean("auto.commit.enable", false);
        this.properties.put("enable.auto.commit", (Object)kafkaConf.getBoolean("enable.auto.commit", oldApiCommitEnableFlag));
        this.properties.put("session.timeout.ms", kafkaConf.getString("session.timeout.ms", "30000"));
        this.properties.put("max.poll.records", (Object)kafkaConf.getInt("max.poll.records", 1));
        LOG.info("<== KafkaNotification()");
    }

    @VisibleForTesting
    protected KafkaNotification(Properties properties) {
        LOG.info("==> KafkaNotification()");
        this.properties = properties;
        this.pollTimeOutMs = 1000L;
        LOG.info("<== KafkaNotification()");
    }

    @VisibleForTesting
    String getTopicName(NotificationInterface.NotificationType notificationType) {
        return TOPIC_MAP.get((Object)notificationType);
    }

    public void start() throws AtlasException {
        LOG.info("==> KafkaNotification.start()");
        LOG.info("<== KafkaNotification.start()");
    }

    public void stop() {
        LOG.info("==> KafkaNotification.stop()");
        LOG.info("<== KafkaNotification.stop()");
    }

    @Override
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers) {
        return this.createConsumers(notificationType, numConsumers, Boolean.valueOf(this.properties.getProperty("enable.auto.commit", this.properties.getProperty("auto.commit.enable", "false"))));
    }

    @VisibleForTesting
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers, boolean autoCommitEnabled) {
        LOG.info("==> KafkaNotification.createConsumers(notificationType={}, numConsumers={}, autoCommitEnabled={})", new Object[]{notificationType, numConsumers, autoCommitEnabled});
        Properties consumerProperties = this.getConsumerProperties(notificationType);
        AtlasKafkaConsumer kafkaConsumer = new AtlasKafkaConsumer(notificationType, this.getKafkaConsumer(consumerProperties, notificationType, autoCommitEnabled), autoCommitEnabled, (long)this.pollTimeOutMs);
        List<NotificationConsumer<T>> consumers = Collections.singletonList(kafkaConsumer);
        LOG.info("<== KafkaNotification.createConsumers(notificationType={}, numConsumers={}, autoCommitEnabled={})", new Object[]{notificationType, numConsumers, autoCommitEnabled});
        return consumers;
    }

    @Override
    public void close() {
        LOG.info("==> KafkaNotification.close()");
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        LOG.info("<== KafkaNotification.close()");
    }

    @Override
    public void sendInternal(NotificationInterface.NotificationType type, List<String> messages) throws NotificationException {
        if (this.producer == null) {
            this.createProducer();
        }
        this.sendInternalToProducer((Producer)this.producer, type, messages);
    }

    @VisibleForTesting
    void sendInternalToProducer(Producer p, NotificationInterface.NotificationType type, List<String> messages) throws NotificationException {
        String topic = TOPIC_MAP.get((Object)type);
        ArrayList<MessageContext> messageContexts = new ArrayList<MessageContext>();
        for (String message : messages) {
            ProducerRecord record = new ProducerRecord(topic, (Object)message);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message for topic {}: {}", (Object)topic, (Object)message);
            }
            Future future = p.send(record);
            messageContexts.add(new MessageContext(future, message));
        }
        ArrayList<String> failedMessages = new ArrayList<String>();
        Exception lastFailureException = null;
        for (MessageContext context : messageContexts) {
            try {
                RecordMetadata response = context.getFuture().get();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Sent message for topic - {}, partition - {}, offset - {}", new Object[]{response.topic(), response.partition(), response.offset()});
            }
            catch (Exception e) {
                lastFailureException = e;
                failedMessages.add(context.getMessage());
            }
        }
        if (lastFailureException != null) {
            throw new NotificationException(lastFailureException, failedMessages);
        }
    }

    public KafkaConsumer getKafkaConsumer(Properties consumerProperties, NotificationInterface.NotificationType type, boolean autoCommitEnabled) {
        if (this.consumer == null || !this.isKafkaConsumerOpen(this.consumer)) {
            try {
                String topic = TOPIC_MAP.get((Object)type);
                consumerProperties.put("enable.auto.commit", (Object)autoCommitEnabled);
                this.consumer = new KafkaConsumer(consumerProperties);
                this.consumer.subscribe(Arrays.asList(topic));
            }
            catch (Exception ee) {
                LOG.error("Exception in getKafkaConsumer ", (Throwable)ee);
            }
        }
        return this.consumer;
    }

    @VisibleForTesting
    public Properties getConsumerProperties(NotificationInterface.NotificationType type) {
        String groupId = this.properties.getProperty(type.toString().toLowerCase() + "." + CONSUMER_GROUP_ID_PROPERTY);
        if (StringUtils.isEmpty((String)groupId)) {
            throw new IllegalStateException("No configuration group id set for the notification type " + (Object)((Object)type));
        }
        Properties consumerProperties = new Properties();
        consumerProperties.putAll((Map<?, ?>)this.properties);
        consumerProperties.put(CONSUMER_GROUP_ID_PROPERTY, groupId);
        return consumerProperties;
    }

    private synchronized void createProducer() {
        LOG.info("==> KafkaNotification.createProducer()");
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.properties);
        }
        LOG.info("<== KafkaNotification.createProducer()");
    }

    private boolean isKafkaConsumerOpen(KafkaConsumer consumer) {
        boolean ret;
        block2: {
            ret = true;
            try {
                consumer.listTopics();
            }
            catch (IllegalStateException ex) {
                if (!ex.getMessage().equalsIgnoreCase(this.consumerClosedErrorMsg)) break block2;
                ret = false;
            }
        }
        return ret;
    }

    private class MessageContext {
        private final Future<RecordMetadata> future;
        private final String message;

        public MessageContext(Future<RecordMetadata> future, String message) {
            this.future = future;
            this.message = message;
        }

        public Future<RecordMetadata> getFuture() {
            return this.future;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

