/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import org.apache.atlas.model.notification.AtlasNotificationStringMessage;

public class SplitMessageAggregator {
    private final String msgId;
    private final AtlasNotificationStringMessage[] splitMessagesBuffer;
    private final long firstSplitTimestamp;

    public SplitMessageAggregator(AtlasNotificationStringMessage message) {
        this.msgId = message.getMsgId();
        this.splitMessagesBuffer = new AtlasNotificationStringMessage[message.getMsgSplitCount()];
        this.firstSplitTimestamp = System.currentTimeMillis();
        this.add(message);
    }

    public String getMsgId() {
        return this.msgId;
    }

    public long getTotalSplitCount() {
        return this.splitMessagesBuffer.length;
    }

    public long getReceivedSplitCount() {
        long ret = 0L;
        for (AtlasNotificationStringMessage split : this.splitMessagesBuffer) {
            if (split == null) continue;
            ++ret;
        }
        return ret;
    }

    public long getFirstSplitTimestamp() {
        return this.firstSplitTimestamp;
    }

    public boolean add(AtlasNotificationStringMessage message) {
        if (message.getMsgSplitIdx() < this.splitMessagesBuffer.length) {
            this.splitMessagesBuffer[message.getMsgSplitIdx()] = message;
        }
        return message.getMsgSplitIdx() == message.getMsgSplitCount() - 1;
    }

    public AtlasNotificationStringMessage get(int i) {
        return this.splitMessagesBuffer[i];
    }
}

