/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.compiler.idl.Token;

public class DocCommentHelper {
    private static final Pattern WS_INDENT = Pattern.compile("(?U).*\\R(?<indent>\\h*).*(?:\\R\\k<indent>.*)*");
    private static final Pattern STAR_INDENT = Pattern.compile("(?U)(?<stars>\\*{1,2}).*(?:\\R\\h*\\k<stars>.*)*");
    private static final ThreadLocal<DocComment> DOC = new ThreadLocal();
    private static final ThreadLocal<List<String>> WARNINGS = ThreadLocal.withInitial(ArrayList::new);

    static List<String> getAndClearWarnings() {
        List<String> warnings = WARNINGS.get();
        WARNINGS.remove();
        return warnings;
    }

    static void setDoc(Token token) {
        DocComment newDocComment = new DocComment(token);
        DocComment oldDocComment = DOC.get();
        if (oldDocComment != null) {
            WARNINGS.get().add(String.format("Found documentation comment at line %d, column %d. Ignoring previous one at line %d, column %d: \"%s\"\nDid you mean to use a multiline comment ( /* ... */ ) instead?", newDocComment.line, newDocComment.column, oldDocComment.line, oldDocComment.column, oldDocComment.text));
        }
        DOC.set(newDocComment);
    }

    static void clearDoc() {
        DocComment oldDocComment = DOC.get();
        if (oldDocComment != null) {
            WARNINGS.get().add(String.format("Ignoring out-of-place documentation comment at line %d, column %d: \"%s\"\nDid you mean to use a multiline comment ( /* ... */ ) instead?", oldDocComment.line, oldDocComment.column, oldDocComment.text));
        }
        DOC.remove();
    }

    static String getDoc() {
        DocComment docComment = DOC.get();
        DOC.remove();
        return docComment == null ? null : docComment.text;
    }

    static String stripIndents(String doc) {
        Matcher starMatcher = STAR_INDENT.matcher(doc);
        if (starMatcher.matches()) {
            return doc.replaceAll("(?U)(?:^|(\\R)\\h*)\\Q" + starMatcher.group("stars") + "\\E\\h?", "$1");
        }
        Matcher whitespaceMatcher = WS_INDENT.matcher(doc);
        if (whitespaceMatcher.matches()) {
            return doc.replaceAll("(?U)(\\R)" + whitespaceMatcher.group("indent"), "$1");
        }
        return doc;
    }

    private static class DocComment {
        private final String text;
        private final int line;
        private final int column;

        DocComment(Token token) {
            int tokenLength = token.image.length();
            this.text = DocCommentHelper.stripIndents(token.image.substring(0, tokenLength - 2).trim());
            this.line = token.beginLine;
            this.column = token.beginColumn - 3;
        }
    }
}

