/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.protobuf.ProtobufDatumReader;
import org.apache.avro.specific.SpecificData;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.JsonNodeFactory;

public class ProtobufData
extends GenericData {
    private static final String PROTOBUF_TYPE = "protobuf";
    private static final ProtobufData INSTANCE = new ProtobufData();
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor[]> fieldCache = new ConcurrentHashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor[]>();
    private final Map<Class, Schema> schemaCache = new ConcurrentHashMap<Class, Schema>();
    private static final ThreadLocal<Map<Descriptors.Descriptor, Schema>> SEEN = new ThreadLocal<Map<Descriptors.Descriptor, Schema>>(){

        @Override
        protected Map<Descriptors.Descriptor, Schema> initialValue() {
            return new IdentityHashMap<Descriptors.Descriptor, Schema>();
        }
    };
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final JsonNodeFactory NODES = JsonNodeFactory.instance;

    protected ProtobufData() {
    }

    public static ProtobufData get() {
        return INSTANCE;
    }

    public DatumReader createDatumReader(Schema schema) {
        return new ProtobufDatumReader(schema, schema, this);
    }

    public void setField(Object r, String n, int pos, Object o) {
        this.setField(r, n, pos, o, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    public Object getField(Object r, String name, int pos) {
        return this.getField(r, name, pos, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    protected void setField(Object r, String n, int pos, Object o, Object state) {
        Message.Builder b = (Message.Builder)r;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[pos];
        switch (f.getType()) {
            case ENUM: {
                b.setField(f, (Object)((ProtocolMessageEnum)o).getValueDescriptor());
                break;
            }
            case MESSAGE: {
                if (o == null) {
                    b.clearField(f);
                    break;
                }
            }
            default: {
                b.setField(f, o);
            }
        }
    }

    protected Object getField(Object record, String name, int pos, Object state) {
        Message m = (Message)record;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[pos];
        switch (f.getType()) {
            case ENUM: {
                Schema s = this.getSchema(f);
                try {
                    Class<?> c = Class.forName(SpecificData.getClassName((Schema)s));
                    Descriptors.EnumValueDescriptor symbol = (Descriptors.EnumValueDescriptor)m.getField(f);
                    return Enum.valueOf(c, symbol.getName());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case MESSAGE: {
                if (m.hasField(f)) break;
                return null;
            }
        }
        return m.getField(f);
    }

    protected Object getRecordState(Object r, Schema s) {
        Descriptors.Descriptor d = ((MessageOrBuilder)r).getDescriptorForType();
        Descriptors.FieldDescriptor[] fields = this.fieldCache.get(d);
        if (fields == null) {
            fields = new Descriptors.FieldDescriptor[s.getFields().size()];
            for (Schema.Field f : s.getFields()) {
                fields[f.pos()] = d.findFieldByName(f.name());
            }
            this.fieldCache.put(d, fields);
        }
        return fields;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof Message;
    }

    public Object newRecord(Object old, Schema schema) {
        try {
            Class<?> c = Class.forName(SpecificData.getClassName((Schema)schema));
            if (c == null) {
                return this.newRecord(old, schema);
            }
            if (c.isInstance(old)) {
                return old;
            }
            return c.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isArray(Object datum) {
        return datum instanceof List;
    }

    protected boolean isBytes(Object datum) {
        return datum instanceof ByteString;
    }

    protected Schema getRecordSchema(Object record) {
        return this.getSchema(((Message)record).getDescriptorForType());
    }

    public Schema getSchema(Class c) {
        Schema schema = this.schemaCache.get(c);
        if (schema == null) {
            try {
                schema = this.getSchema((Descriptors.Descriptor)c.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.schemaCache.put(c, schema);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema getSchema(Descriptors.Descriptor descriptor) {
        Map<Descriptors.Descriptor, Schema> seen = SEEN.get();
        if (seen.containsKey(descriptor)) {
            return seen.get(descriptor);
        }
        boolean first = seen.isEmpty();
        try {
            Schema result = Schema.createRecord((String)descriptor.getName(), null, (String)this.getNamespace(descriptor.getFile()), (boolean)false);
            seen.put(descriptor, result);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (Descriptors.FieldDescriptor f : descriptor.getFields()) {
                Schema s = this.getSchema(f);
                if (f.isRepeated()) {
                    s = Schema.createArray((Schema)s);
                }
                fields.add(new Schema.Field(f.getName(), s, null, this.getDefault(f)));
            }
            result.setFields(fields);
            Schema schema = result;
            return schema;
        }
        finally {
            if (first) {
                seen.clear();
            }
        }
    }

    private String getNamespace(Descriptors.FileDescriptor fd) {
        String outer;
        String p;
        DescriptorProtos.FileOptions o = fd.getOptions();
        String string = p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        if (o.hasJavaOuterClassname()) {
            outer = o.getJavaOuterClassname();
        } else {
            outer = new File(fd.getName()).getName();
            outer = outer.substring(0, outer.lastIndexOf(46));
            outer = ProtobufData.toCamelCase(outer);
        }
        return p + "." + outer + "$";
    }

    private static String toCamelCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        for (String part : parts) {
            camelCaseString = camelCaseString + ProtobufData.cap(part);
        }
        return camelCaseString;
    }

    private static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private Schema getSchema(Descriptors.FieldDescriptor f) {
        switch (f.getType()) {
            case BOOL: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                Schema s = Schema.create((Schema.Type)Schema.Type.STRING);
                GenericData.setStringType((Schema)s, (GenericData.StringType)GenericData.StringType.String);
                return s;
            }
            case BYTES: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case ENUM: {
                Descriptors.EnumDescriptor d = f.getEnumType();
                ArrayList<String> symbols = new ArrayList<String>();
                for (Descriptors.EnumValueDescriptor e : d.getValues()) {
                    symbols.add(e.getName());
                }
                return Schema.createEnum((String)d.getName(), null, (String)this.getNamespace(d.getFile()), symbols);
            }
            case MESSAGE: {
                Schema result = this.getSchema(f.getMessageType());
                if (f.isOptional()) {
                    result = Schema.createUnion(Arrays.asList(NULL, result));
                }
                return result;
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }

    private JsonNode getDefault(Descriptors.FieldDescriptor f) {
        if (f.isRequired() || f.isRepeated()) {
            return null;
        }
        if (f.hasDefaultValue()) {
            String json = this.toString(f.getDefaultValue());
            try {
                return MAPPER.readTree(FACTORY.createJsonParser(json));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        switch (f.getType()) {
            case BOOL: {
                return NODES.booleanNode(false);
            }
            case FLOAT: 
            case DOUBLE: 
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return NODES.numberNode(0);
            }
            case STRING: 
            case BYTES: {
                return NODES.textNode("");
            }
            case ENUM: {
                return NODES.textNode(((Descriptors.EnumValueDescriptor)f.getEnumType().getValues().get(0)).getName());
            }
            case MESSAGE: {
                return NODES.nullNode();
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }
}

