/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class BinaryFragmentToJsonTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() != 2) {
            err.println("Expected 2 arguments: schema binary_data_file");
            err.println("Use '-' as binary_data_file for stdin.");
            return 1;
        }
        Schema schema = new Schema.Parser().parse(args.get(0));
        BufferedInputStream input = Util.fileOrStdin(args.get(1), stdin);
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object datum = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)input, null));
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonGenerator g = new JsonFactory().createJsonGenerator((OutputStream)out, JsonEncoding.UTF8);
            g.useDefaultPrettyPrinter();
            writer.write(datum, (Encoder)EncoderFactory.get().jsonEncoder(schema, g));
            g.flush();
            out.println();
            out.flush();
        }
        finally {
            Util.close(input);
        }
        return 0;
    }

    @Override
    public String getName() {
        return "fragtojson";
    }

    @Override
    public String getShortDescription() {
        return "Renders a binary-encoded Avro datum as JSON.";
    }
}

