/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.trevni.TestUtil;

public class RandomData
implements Iterable<Object> {
    public static final String USE_DEFAULT = "use-default";
    private final Schema root;
    private final int count;

    public RandomData(Schema schema, int count) {
        this.root = schema;
        this.count = count;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int n;
            private Random random = TestUtil.createRandom();

            @Override
            public boolean hasNext() {
                return this.n < RandomData.this.count;
            }

            @Override
            public Object next() {
                ++this.n;
                return RandomData.generate(RandomData.this.root, this.random, 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Object generate(Schema schema, Random random, int d) {
        switch (schema.getType()) {
            case RECORD: {
                GenericData.Record record = new GenericData.Record(schema);
                for (Schema.Field field : schema.getFields()) {
                    Object value = field.getJsonProp(USE_DEFAULT) == null ? RandomData.generate(field.schema(), random, d + 1) : GenericData.get().getDefaultValue(field);
                    record.put(field.name(), value);
                }
                return record;
            }
            case ENUM: {
                List symbols = schema.getEnumSymbols();
                return new GenericData.EnumSymbol(schema, (String)symbols.get(random.nextInt(symbols.size())));
            }
            case ARRAY: {
                int length = random.nextInt(5) + 2 - d;
                GenericData.Array array = new GenericData.Array(length <= 0 ? 0 : length, schema);
                for (int i = 0; i < length; ++i) {
                    array.add(RandomData.generate(schema.getElementType(), random, d + 1));
                }
                return array;
            }
            case MAP: {
                int length = random.nextInt(5) + 2 - d;
                HashMap<String, Object> map = new HashMap<String, Object>(length <= 0 ? 0 : length);
                for (int i = 0; i < length; ++i) {
                    map.put(TestUtil.randomString((Random)random), RandomData.generate(schema.getValueType(), random, d + 1));
                }
                return map;
            }
            case UNION: {
                List types = schema.getTypes();
                return RandomData.generate((Schema)types.get(random.nextInt(types.size())), random, d);
            }
            case FIXED: {
                byte[] bytes = new byte[schema.getFixedSize()];
                random.nextBytes(bytes);
                return new GenericData.Fixed(schema, bytes);
            }
            case STRING: {
                return TestUtil.randomString((Random)random);
            }
            case BYTES: {
                return TestUtil.randomBytes((Random)random);
            }
            case INT: {
                return random.nextInt();
            }
            case LONG: {
                return random.nextLong();
            }
            case FLOAT: {
                return Float.valueOf(random.nextFloat());
            }
            case DOUBLE: {
                return random.nextDouble();
            }
            case BOOLEAN: {
                return random.nextBoolean();
            }
            case NULL: {
                return null;
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: RandomData <schemafile> <outputfile> <count>");
            System.exit(-1);
        }
        Schema sch = Schema.parse((File)new File(args[0]));
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).create(sch, new File(args[1]));
        try {
            for (Object datum : new RandomData(sch, Integer.parseInt(args[2]))) {
                writer.append(datum);
            }
        }
        finally {
            writer.close();
        }
    }
}

