/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.trevni.Codec;
import org.apache.trevni.MetaData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAllCodecs {
    @Parameterized.Parameter(value=0)
    public String codec;

    @Parameterized.Parameters(name="{index}: codec={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"bzip2"}, {"null"}, {"snappy"}, {"deflate"});
    }

    public static Codec getCodec(String name) {
        MetaData m = new MetaData();
        m.put((Object)"trevni.codec", (Object)name.getBytes());
        return Codec.get((MetaData)m);
    }

    @Test
    public void testCodec() throws IOException {
        ByteBuffer inputByteBuffer;
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = TestAllCodecs.getCodec(this.codec);
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer = ByteBuffer.wrap(input));
        int compressedSize = compressedBuffer.remaining();
        Assert.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        Assert.assertTrue((compressedSize < inputSize || this.codec.equals("null") ? 1 : 0) != 0);
        ByteBuffer decompressedBuffer = codecInstance.decompress(compressedBuffer);
        ((Buffer)inputByteBuffer).rewind();
        Assert.assertEquals((Object)decompressedBuffer, (Object)inputByteBuffer);
    }

    @Test
    public void testCodecSlice() throws IOException {
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = TestAllCodecs.getCodec(this.codec);
        ByteBuffer partialBuffer = ByteBuffer.wrap(input);
        ((Buffer)partialBuffer).position(17);
        ByteBuffer inputByteBuffer = partialBuffer.slice();
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer);
        int compressedSize = compressedBuffer.remaining();
        Assert.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        ByteBuffer sliceBuffer = ByteBuffer.allocate(compressedSize + 100);
        ((Buffer)sliceBuffer).position(50);
        sliceBuffer.put(compressedBuffer);
        ((Buffer)sliceBuffer).limit(compressedSize + 50);
        ((Buffer)sliceBuffer).position(50);
        ByteBuffer decompressedBuffer = codecInstance.decompress(sliceBuffer.slice());
        ((Buffer)inputByteBuffer).rewind();
        Assert.assertEquals((Object)decompressedBuffer, (Object)inputByteBuffer);
    }

    public static byte[] generateTestData(int inputSize) {
        byte[] arr = new byte[inputSize];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)(65 + i % 10);
        }
        return arr;
    }
}

