/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.TestUtil;
import org.apache.trevni.ValueType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.runners.Parameterized;

public class TestColumnFile {
    private static final File FILE = new File("target", "test.trv");
    private static final int COUNT = 65536;

    @Parameterized.Parameters
    public static Stream<Arguments> codecs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestColumnFile.createFileMeta("null", "null")}), Arguments.of((Object[])new Object[]{TestColumnFile.createFileMeta("snappy", "crc32")}), Arguments.of((Object[])new Object[]{TestColumnFile.createFileMeta("deflate", "crc32")}));
    }

    private static ColumnFileMetaData createFileMeta(String codec, String checksum) {
        return (ColumnFileMetaData)((ColumnFileMetaData)new ColumnFileMetaData().setCodec(codec)).setChecksum(checksum);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void emptyFile(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[0]);
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)0L, (long)in.getRowCount());
        Assertions.assertEquals((long)0L, (long)in.getColumnCount());
        in.close();
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void emptyColumn(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.INT)});
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)0L, (long)in.getRowCount());
        Assertions.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues values = in.getValues("test");
        Iterator iterator = values.iterator();
        if (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            throw new Exception("no value should be found");
        }
        in.close();
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void ints(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.INT)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{TestUtil.randomLength(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)65536L, (long)in.getRowCount());
        Assertions.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assertions.assertEquals((int)TestUtil.randomLength(random), (int)((Integer)i.next()));
            ++count;
        }
        Assertions.assertEquals((int)65536, (int)count);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void longs(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.LONG)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{random.nextLong()});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)65536L, (long)in.getRowCount());
        Assertions.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assertions.assertEquals((long)random.nextLong(), (long)((Long)i.next()));
            ++count;
        }
        Assertions.assertEquals((int)65536, (int)count);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void strings(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.STRING)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{TestUtil.randomString(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)65536L, (long)in.getRowCount());
        Assertions.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assertions.assertEquals((Object)TestUtil.randomString(random), i.next());
            ++count;
        }
        Assertions.assertEquals((int)65536, (int)count);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void twoColumn(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("a", ValueType.FIXED32), new ColumnMetaData("b", ValueType.STRING)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{random.nextInt(), TestUtil.randomString(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assertions.assertEquals((long)65536L, (long)in.getRowCount());
        Assertions.assertEquals((long)2L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("a");
        ColumnValues j = in.getValues("b");
        int count = 0;
        while (i.hasNext() && j.hasNext()) {
            Assertions.assertEquals((Object)random.nextInt(), i.next());
            Assertions.assertEquals((Object)TestUtil.randomString(random), j.next());
            ++count;
        }
        Assertions.assertEquals((int)65536, (int)count);
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void seekLongs(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.LONG)});
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        int[] seekRows = new int[seekCount];
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRows[seekRowMap.size()] = row;
            seekRowMap.put(row, seekRowMap.size());
        }
        Long[] seekValues = new Long[seekCount];
        for (int i = 0; i < 65536; ++i) {
            long l = random.nextLong();
            out.writeRow(new Object[]{l});
            if (!seekRowMap.containsKey(i)) continue;
            seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i))).intValue()] = l;
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues v = in.getValues("test");
        for (int i = 0; i < seekCount; ++i) {
            v.seek((long)seekRows[i]);
            Assertions.assertEquals((Long)seekValues[i], (Long)((Long)v.next()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    void seekStrings(ColumnFileMetaData fileMeta) throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(fileMeta, new ColumnMetaData[]{new ColumnMetaData("test", ValueType.STRING).hasIndexValues(true)});
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRowMap.put(row, seekRowMap.size());
        }
        Object[] values = new String[65536];
        for (int i = 0; i < 65536; ++i) {
            values[i] = TestUtil.randomString(random);
        }
        Arrays.sort(values);
        String[] seekValues = new String[seekCount];
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{values[i]});
            if (!seekRowMap.containsKey(i)) continue;
            seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i))).intValue()] = values[i];
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues v = in.getValues("test");
        for (int i = 0; i < seekCount; ++i) {
            v.seek((Comparable)((Object)seekValues[i]));
            Assertions.assertEquals((Object)seekValues[i], (Object)v.next());
        }
    }
}

