/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.util.Arrays;
import java.util.Random;
import org.apache.trevni.InputBytes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInputBytes {
    private static final int SIZE = 1000;
    private static final int COUNT = 100;

    @Test
    void randomReads() throws Exception {
        Random random = new Random(19820210L);
        int length = random.nextInt(1000) + 1;
        byte[] data = new byte[length];
        random.nextBytes(data);
        InputBytes in = new InputBytes(data);
        for (int i = 0; i < 100; ++i) {
            int p = random.nextInt(length);
            int l = Math.min(random.nextInt(100), length - p);
            byte[] buffer = new byte[l];
            in.read((long)p, buffer, 0, l);
            Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(data, p, p + l), (byte[])buffer);
        }
        in.close();
    }
}

