/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.TestUtil;
import org.apache.trevni.ValueType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestColumnFile {
    private static final File FILE = new File("target", "test.trv");
    private static final int COUNT = 65536;
    private String codec;
    private String checksum;

    public TestColumnFile(String codec, String checksum) {
        this.codec = codec;
        this.checksum = checksum;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> codecs() {
        Object[][] data = new Object[][]{{"null", "null"}, {"snappy", "crc32"}, {"deflate", "crc32"}};
        return Arrays.asList(data);
    }

    private ColumnFileMetaData createFileMeta() {
        return (ColumnFileMetaData)((ColumnFileMetaData)new ColumnFileMetaData().setCodec(this.codec)).setChecksum(this.checksum);
    }

    @Test
    public void testEmptyFile() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[0]);
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)0L, (long)in.getRowCount());
        Assert.assertEquals((long)0L, (long)in.getColumnCount());
        in.close();
    }

    @Test
    public void testEmptyColumn() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.INT)});
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)0L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues values = in.getValues("test");
        Iterator i$ = values.iterator();
        if (i$.hasNext()) {
            int i = (Integer)i$.next();
            throw new Exception("no value should be found");
        }
        in.close();
    }

    @Test
    public void testInts() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.INT)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{TestUtil.randomLength(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assert.assertEquals((long)TestUtil.randomLength(random), (long)((Integer)i.next()).intValue());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testLongs() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.LONG)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{random.nextLong()});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assert.assertEquals((long)random.nextLong(), (long)((Long)i.next()));
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testStrings() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.STRING)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{TestUtil.randomString(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("test");
        int count = 0;
        while (i.hasNext()) {
            Assert.assertEquals((Object)TestUtil.randomString(random), i.next());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testTwoColumn() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("a", ValueType.FIXED32), new ColumnMetaData("b", ValueType.STRING)});
        Random random = TestUtil.createRandom();
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{random.nextInt(), TestUtil.randomString(random)});
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)2L, (long)in.getColumnCount());
        ColumnValues i = in.getValues("a");
        ColumnValues j = in.getValues("b");
        int count = 0;
        while (i.hasNext() && j.hasNext()) {
            Assert.assertEquals((Object)random.nextInt(), i.next());
            Assert.assertEquals((Object)TestUtil.randomString(random), j.next());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testSeekLongs() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.LONG)});
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        int[] seekRows = new int[seekCount];
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRows[seekRowMap.size()] = row;
            seekRowMap.put(row, seekRowMap.size());
        }
        Long[] seekValues = new Long[seekCount];
        for (int i = 0; i < 65536; ++i) {
            long l = random.nextLong();
            out.writeRow(new Object[]{l});
            if (!seekRowMap.containsKey(i)) continue;
            seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i))).intValue()] = l;
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues v = in.getValues("test");
        for (int i = 0; i < seekCount; ++i) {
            v.seek((long)seekRows[i]);
            Assert.assertEquals((Object)seekValues[i], (Object)v.next());
        }
    }

    @Test
    public void testSeekStrings() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[]{new ColumnMetaData("test", ValueType.STRING).hasIndexValues(true)});
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRowMap.put(row, seekRowMap.size());
        }
        Object[] values = new String[65536];
        for (int i = 0; i < 65536; ++i) {
            values[i] = TestUtil.randomString(random);
        }
        Arrays.sort(values);
        String[] seekValues = new String[seekCount];
        for (int i = 0; i < 65536; ++i) {
            out.writeRow(new Object[]{values[i]});
            if (!seekRowMap.containsKey(i)) continue;
            seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i))).intValue()] = values[i];
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues v = in.getValues("test");
        for (int i = 0; i < seekCount; ++i) {
            v.seek((Comparable)((Object)seekValues[i]));
            Assert.assertEquals((Object)seekValues[i], (Object)v.next());
        }
    }
}

