/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.core.catalog.CatalogLoadMode;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogInitialization
implements ManagementContextInjectable {
    private static final Logger log = LoggerFactory.getLogger(CatalogInitialization.class);
    private String initialUri;
    private boolean reset;
    private List<String> additionsUris;
    private boolean force;
    private boolean disallowLocal = false;
    private List<Function<CatalogInitialization, Void>> callbacks = MutableList.of();
    private boolean hasRunUnofficialInitialization = false;
    private boolean hasRunTransientOfficialInitialization = false;
    private boolean hasRunFinalInitialization = false;
    private boolean isPopulating = false;
    private ManagementContext managementContext;
    private boolean isStartingUp = false;
    private boolean failOnStartupErrors = false;
    private Object populatingCatalogMutex = new Object();
    boolean hasRunAdditions = false;
    private Object setFromCLMMutex = new Object();
    private boolean setFromCatalogLoadMode = false;

    public CatalogInitialization() {
        this(null, false, (Iterable<String>)ImmutableList.of(), false);
    }

    public CatalogInitialization(String initialUri, boolean reset, Iterable<String> additionUris, boolean force) {
        this.initialUri = initialUri;
        this.reset = reset;
        this.additionsUris = additionUris != null ? ImmutableList.copyOf(additionUris) : ImmutableList.of();
        this.force = force;
    }

    @Override
    public void setManagementContext(ManagementContext managementContext) {
        Preconditions.checkNotNull((Object)managementContext, (Object)"management context");
        if (this.managementContext != null && managementContext != this.managementContext) {
            throw new IllegalStateException("Cannot switch management context, from " + this.managementContext + " to " + managementContext);
        }
        this.managementContext = managementContext;
    }

    public void setStartingUp(boolean isStartingUp) {
        this.isStartingUp = isStartingUp;
    }

    public void setFailOnStartupErrors(boolean startupFailOnCatalogErrors) {
        this.failOnStartupErrors = startupFailOnCatalogErrors;
    }

    public CatalogInitialization addPopulationCallback(Function<CatalogInitialization, Void> callback) {
        this.callbacks.add(callback);
        return this;
    }

    public ManagementContext getManagementContext() {
        return (ManagementContext)Preconditions.checkNotNull((Object)this.managementContext, (Object)("management context has not been injected into " + this));
    }

    public boolean isInitialResetRequested() {
        return this.reset;
    }

    public boolean hasRunFinalInitialization() {
        return this.hasRunFinalInitialization;
    }

    public boolean hasRunOfficialInitialization() {
        return this.hasRunFinalInitialization || this.hasRunTransientOfficialInitialization;
    }

    public boolean hasRunAnyInitialization() {
        return this.hasRunFinalInitialization || this.hasRunTransientOfficialInitialization || this.hasRunUnofficialInitialization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCatalog(ManagementNodeState nodeState, boolean needsInitialItemsLoaded, boolean needsAdditionsLoaded, Collection<CatalogItem<?, ?>> optionalExplicitItemsForResettingCatalog) {
        if (log.isDebugEnabled()) {
            String message = "Populating catalog for " + nodeState + ", needsInitial=" + needsInitialItemsLoaded + ", needsAdditional=" + needsAdditionsLoaded + ", explicitItems=" + (optionalExplicitItemsForResettingCatalog == null ? "null" : Integer.valueOf(optionalExplicitItemsForResettingCatalog.size())) + "; from " + JavaClassNames.callerNiceClassAndMethod((int)1);
            if (!ManagementNodeState.isHotProxy((ManagementNodeState)nodeState)) {
                log.debug(message);
            } else {
                log.trace(message);
            }
        }
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            try {
                if (this.hasRunFinalInitialization() && (needsInitialItemsLoaded || needsAdditionsLoaded)) {
                    log.warn("Catalog initialization called to populate initial, even though it has already run the final official initialization");
                }
                this.isPopulating = true;
                BasicBrooklynCatalog catalog = (BasicBrooklynCatalog)this.managementContext.getCatalog();
                if (!catalog.getCatalog().isLoaded()) {
                    catalog.load();
                } else if (needsInitialItemsLoaded && this.hasRunAnyInitialization()) {
                    if (this.hasRunTransientOfficialInitialization) {
                        log.debug("Catalog initialization now populating, but has noted a previous official run which was not final (probalby loaded while in a standby mode, or a previous run failed); overwriting any items installed earlier");
                    } else {
                        log.warn("Catalog initialization now populating, but has noted a previous unofficial run (it may have been an early web request); overwriting any items installed earlier");
                    }
                    catalog.reset((Collection<CatalogItem<?, ?>>)ImmutableList.of());
                }
                this.populateCatalogImpl(catalog, needsInitialItemsLoaded, needsAdditionsLoaded, optionalExplicitItemsForResettingCatalog);
                if (nodeState == ManagementNodeState.MASTER) {
                    this.hasRunFinalInitialization = true;
                }
            }
            catch (Throwable e) {
                log.warn("Error populating catalog (rethrowing): " + e, e);
                throw Exceptions.propagate((Throwable)e);
            }
            finally {
                if (!this.hasRunFinalInitialization) {
                    this.hasRunTransientOfficialInitialization = true;
                }
                this.isPopulating = false;
            }
        }
    }

    private void populateCatalogImpl(BasicBrooklynCatalog catalog, boolean needsInitialItemsLoaded, boolean needsAdditionsLoaded, Collection<CatalogItem<?, ?>> optionalItemsForResettingCatalog) {
        this.applyCatalogLoadMode();
        if (optionalItemsForResettingCatalog != null) {
            catalog.reset(optionalItemsForResettingCatalog);
        }
        if (needsInitialItemsLoaded) {
            this.populateInitial(catalog);
        }
        if (needsAdditionsLoaded) {
            this.populateAdditions(catalog);
            this.populateViaCallbacks(catalog);
        }
    }

    protected void populateInitial(BasicBrooklynCatalog catalog) {
        if (this.disallowLocal) {
            if (!this.hasRunFinalInitialization()) {
                log.debug("CLI initial catalog not being read when local catalog load mode is disallowed.");
            }
            return;
        }
        if (this.initialUri != null) {
            this.populateInitialFromUri(catalog, this.initialUri);
            return;
        }
        String catalogUrl = (String)this.managementContext.getConfig().getConfig(BrooklynServerConfig.BROOKLYN_CATALOG_URL);
        if (Strings.isNonBlank((CharSequence)catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl);
            return;
        }
        catalogUrl = Os.mergePaths((String[])new String[]{BrooklynServerConfig.getMgmtBaseDir(this.managementContext.getConfig()), "catalog.bom"});
        if (new File(catalogUrl).exists()) {
            this.populateInitialFromUri(catalog, new File(catalogUrl).toURI().toString());
            return;
        }
        catalogUrl = "classpath:/brooklyn/default.catalog.bom";
        if (new ResourceUtils(this).doesUrlExist(catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl);
            return;
        }
        log.info("No catalog found on classpath or specified; catalog will not be initialized.");
    }

    private void populateInitialFromUri(BasicBrooklynCatalog catalog, String catalogUrl) {
        log.debug("Loading initial catalog from {}", (Object)catalogUrl);
        try {
            String contents = new ResourceUtils(this).getResourceAsString(catalogUrl);
            catalog.reset((Collection<CatalogItem<?, ?>>)MutableList.of());
            Iterable result = catalog.addItems(contents);
            log.debug("Loaded initial catalog from {}: {}", (Object)catalogUrl, (Object)result);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error importing catalog from " + catalogUrl + ": " + e, (Throwable)e);
        }
    }

    protected void populateAdditions(BasicBrooklynCatalog catalog) {
        if (!this.additionsUris.isEmpty()) {
            if (this.disallowLocal) {
                if (!this.hasRunAdditions) {
                    log.warn("CLI additions supplied but not supported when catalog load mode disallows local loads; ignoring.");
                }
                return;
            }
            if (!this.hasRunAdditions) {
                log.debug("Adding to catalog from CLI: " + this.additionsUris + " (force: " + this.force + ")");
            }
            ArrayList items = Lists.newArrayList();
            for (String additionsUri : this.additionsUris) {
                Iterable addedItems = catalog.addItems(new ResourceUtils(this).getResourceAsString(additionsUri), this.force);
                items.addAll(addedItems);
            }
            if (!this.hasRunAdditions) {
                log.debug("Added to catalog from CLI: " + items);
            } else {
                log.debug("Added to catalog from CLI: count " + Iterables.size((Iterable)items));
            }
            this.hasRunAdditions = true;
        }
    }

    protected void populateViaCallbacks(BasicBrooklynCatalog catalog) {
        for (Function<CatalogInitialization, Void> callback : this.callbacks) {
            callback.apply((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void applyCatalogLoadMode() {
        Object object = this.setFromCLMMutex;
        synchronized (object) {
            if (this.setFromCatalogLoadMode) {
                return;
            }
            this.setFromCatalogLoadMode = true;
            Maybe clmm = ((ManagementContextInternal)this.managementContext).getConfig().getConfigLocalRaw(BrooklynServerConfig.CATALOG_LOAD_MODE);
            if (clmm.isAbsent()) {
                return;
            }
            CatalogLoadMode clm = TypeCoercions.coerce(clmm.get(), CatalogLoadMode.class);
            log.warn("Legacy CatalogLoadMode " + (Object)((Object)clm) + " set: applying, but this should be changed to use new CLI --catalogXxx commands");
            switch (clm) {
                case LOAD_BROOKLYN_CATALOG_URL: {
                    this.reset = true;
                    break;
                }
                case LOAD_BROOKLYN_CATALOG_URL_IF_NO_PERSISTED_STATE: {
                    break;
                }
                case LOAD_PERSISTED_STATE: {
                    this.disallowLocal = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateUnofficial(BasicBrooklynCatalog catalog) {
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            if (this.hasRunAnyInitialization() || this.isPopulating) {
                return;
            }
            log.debug("Populating catalog unofficially (" + catalog + ")");
            this.isPopulating = true;
            try {
                if (this.isStartingUp) {
                    log.warn("Catalog access requested when not yet initialized; populating best effort rather than through recommended pathway. Catalog data may be replaced subsequently.");
                }
                this.populateCatalogImpl(catalog, true, true, null);
            }
            finally {
                this.hasRunUnofficialInitialization = true;
                this.isPopulating = false;
            }
        }
    }

    public void handleException(Throwable throwable, Object details) {
        if (throwable instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)throwable);
        }
        if (throwable instanceof RuntimeInterruptedException) {
            throw (RuntimeInterruptedException)throwable;
        }
        if (details instanceof CatalogItem && ((CatalogItem)details).getCatalogItemId() != null) {
            details = ((CatalogItem)details).getCatalogItemId();
        }
        PropagatedRuntimeException wrap = new PropagatedRuntimeException("Error loading catalog item " + details, throwable);
        log.warn(Exceptions.collapseText((Throwable)wrap));
        log.debug("Trace for: " + wrap, (Throwable)wrap);
        ((ManagementContextInternal)this.getManagementContext()).errors().add((Throwable)wrap);
        if (this.isStartingUp && this.failOnStartupErrors) {
            throw new FatalRuntimeException("Unable to load catalog item " + details, (Throwable)wrap);
        }
    }
}

