/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynPropertiesImpl
implements BrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynPropertiesImpl.class);
    private final Map<String, Object> contents = new LinkedHashMap<String, Object>();

    protected BrooklynPropertiesImpl() {
    }

    @Override
    public BrooklynPropertiesImpl addEnvironmentVars() {
        this.addFrom(System.getenv());
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addSystemProperties() {
        this.addFrom(System.getProperties());
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addFrom(ConfigBag cfg) {
        this.addFrom(cfg.getAllConfig());
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addFrom(Map map) {
        this.putAll(Maps.transformValues((Map)map, (Function)StringFunctions.trim()));
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addFrom(InputStream i) {
        Properties p = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                String s = (String)value;
                s = Strings.isBlank((CharSequence)s) ? "" : CharMatcher.BREAKING_WHITESPACE.trimFrom((CharSequence)s);
                return BrooklynPropertiesImpl.this.put(key, s);
            }
        };
        try {
            p.load(i);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addFrom(File f) {
        if (!f.exists()) {
            LOG.warn("Unable to find file '" + f.getAbsolutePath() + "' when loading properties; ignoring");
            return this;
        }
        try {
            return this.addFrom(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public BrooklynPropertiesImpl addFrom(URL u) {
        try {
            return this.addFrom(u.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading properties from " + u + ": " + e, e);
        }
    }

    @Override
    public BrooklynPropertiesImpl addFromUrl(String url) {
        try {
            if (url == null) {
                return this;
            }
            return this.addFrom(ResourceUtils.create(this).getResourceFromUrl(url));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading properties from " + url + ": " + e, e);
        }
    }

    @Override
    public BrooklynPropertiesImpl addFromUrlProperty(String urlProperty) {
        String url = (String)this.get(urlProperty);
        if (url == null) {
            this.addFromUrl(url);
        }
        return this;
    }

    @Override
    public BrooklynPropertiesImpl addFromMap(Map properties) {
        this.putAll(properties);
        return this;
    }

    @Override
    public boolean putIfAbsent(String key, Object value) {
        if (this.containsKey(key)) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    @Override
    @Deprecated
    public String get(Map flags, String key) {
        LOG.warn("Discouraged use of 'BrooklynProperties.get(Map,String)' (ambiguous); use getFirst(Map,String) or get(String) -- assuming the former");
        LOG.debug("Trace for discouraged use of 'BrooklynProperties.get(Map,String)'", new Throwable("Arguments: " + flags + " " + key));
        return this.getFirst(flags, key);
    }

    @Override
    public String getFirst(String ... keys) {
        return this.getFirst((Map)MutableMap.of(), keys);
    }

    @Override
    public String getFirst(Map flags, String ... keys) {
        for (String k : keys) {
            if (k == null || !this.containsKey(k)) continue;
            return (String)this.get(k);
        }
        if (flags.get("warnIfNone") != null && !Boolean.FALSE.equals(flags.get("warnIfNone"))) {
            if (Boolean.TRUE.equals(flags.get("warnIfNone"))) {
                LOG.warn("Unable to find Brooklyn property " + keys);
            } else {
                LOG.warn("" + flags.get("warnIfNone"));
            }
        }
        if (flags.get("failIfNone") != null && !Boolean.FALSE.equals(flags.get("failIfNone"))) {
            Object f = flags.get("failIfNone");
            if (f instanceof Closure) {
                LOG.warn("Use of groovy.lang.Closure is deprecated as value for 'failIfNone', in BrooklynProperties.getFirst()");
                ((Closure)f).call((Object[])keys);
            }
            if (Boolean.TRUE.equals(f)) {
                throw new NoSuchElementException("Brooklyn unable to find mandatory property " + keys[0] + (keys.length > 1 ? " (or " + (keys.length - 1) + " other possible names, full list is " + Arrays.asList(keys) + ")" : ""));
            }
            throw new NoSuchElementException("" + f);
        }
        if (flags.get("defaultIfNone") != null) {
            return (String)flags.get("defaultIfNone");
        }
        return null;
    }

    public String toString() {
        return "BrooklynProperties[" + this.size() + "]";
    }

    @Override
    public Object put(Object rawKey, Object value) {
        String key;
        if (rawKey == null) {
            throw new NullPointerException("Null key not permitted in BrooklynProperties");
        }
        if (rawKey instanceof String) {
            key = (String)rawKey;
        } else if (rawKey instanceof CharSequence) {
            key = rawKey.toString();
        } else if (rawKey instanceof ConfigKey.HasConfigKey) {
            key = ((ConfigKey.HasConfigKey)rawKey).getConfigKey().getName();
        } else if (rawKey instanceof ConfigKey) {
            key = ((ConfigKey)rawKey).getName();
        } else {
            throw new IllegalArgumentException("Invalid key (value='" + rawKey + "', type=" + rawKey.getClass().getName() + ") for BrooklynProperties");
        }
        return this.putImpl(key, value);
    }

    @Override
    public void putAll(Map vals) {
        for (Map.Entry entry : vals.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> Object put(ConfigKey.HasConfigKey<T> key, T value) {
        return this.putImpl(key.getConfigKey().getName(), value);
    }

    @Override
    public <T> Object put(ConfigKey<T> key, T value) {
        return this.putImpl(key.getName(), value);
    }

    @Override
    public <T> boolean putIfAbsent(ConfigKey<T> key, T value) {
        return this.putIfAbsent(key.getName(), value);
    }

    @Override
    public Object getConfig(String key) {
        return this.get(key);
    }

    @Override
    public <T> T getConfig(ConfigKey<T> key) {
        return this.getConfig(key, null);
    }

    @Override
    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return this.getConfig(key.getConfigKey(), null);
    }

    @Override
    public <T> T getConfig(ConfigKey.HasConfigKey<T> key, T defaultValue) {
        return this.getConfig(key.getConfigKey(), defaultValue);
    }

    @Override
    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        if (!this.containsKey(key.getName())) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return (T)key.getDefaultValue();
        }
        Object value = this.get(key.getName());
        if (value == null) {
            return null;
        }
        return TypeCoercions.coerce(value, key.getTypeToken());
    }

    @Override
    public Maybe<Object> getConfigRaw(ConfigKey<?> key) {
        if (this.containsKey(key.getName())) {
            return Maybe.of((Object)this.get(key.getName()));
        }
        return Maybe.absent();
    }

    @Override
    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        return this.getConfigRaw(key);
    }

    public Maybe<Object> getConfigLocalRaw(ConfigKey<?> key) {
        return this.getConfigRaw(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ConfigKey<?>, Object> getAllConfigLocalRaw() {
        LinkedHashMap result = new LinkedHashMap();
        Map<String, Object> map = this.contents;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                result.put(new BasicConfigKey<Object>(Object.class, entry.getKey()), entry.getValue());
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig() {
        return this.getAllConfigLocalRaw();
    }

    @Deprecated
    public Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter) {
        return this.findKeysDeclared(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ConfigKey<?>> findKeysDeclared(Predicate<? super ConfigKey<?>> filter) {
        LinkedHashSet result = new LinkedHashSet();
        Map<String, Object> map = this.contents;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                BasicConfigKey<Object> k = new BasicConfigKey<Object>(Object.class, "" + entry.getKey());
                if (!filter.apply(k)) continue;
                result.add(k);
            }
        }
        return result;
    }

    public Set<ConfigKey<?>> findKeysPresent(Predicate<? super ConfigKey<?>> filter) {
        return this.findKeysDeclared(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrooklynProperties submap(Predicate<ConfigKey<?>> filter) {
        BrooklynPropertiesImpl result = Factory.newEmpty();
        Map<String, Object> map = this.contents;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                BasicConfigKey<Object> k = new BasicConfigKey<Object>(Object.class, entry.getKey());
                if (!filter.apply(k)) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrooklynProperties submapByName(Predicate<? super String> filter) {
        BrooklynPropertiesImpl result = Factory.newEmpty();
        Map<String, Object> map = this.contents;
        synchronized (map) {
            for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
                if (!filter.apply((Object)entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> asMapWithStringKeys() {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return MutableMap.copyOf(this.contents).asUnmodifiable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return this.contents.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return this.contents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return this.contents.containsKey(key);
        }
    }

    @Override
    public boolean containsKey(ConfigKey<?> key) {
        return this.containsKey(key.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            boolean result = this.contents.containsKey(key);
            this.contents.remove(key);
            return result;
        }
    }

    @Override
    public boolean remove(ConfigKey<?> key) {
        return this.remove(key.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get(String key) {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return this.contents.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object putImpl(String key, Object value) {
        Map<String, Object> map = this.contents;
        synchronized (map) {
            return this.contents.put(key, value);
        }
    }

    public static class Factory {
        public static BrooklynPropertiesImpl newEmpty() {
            return new BrooklynPropertiesImpl();
        }

        public static BrooklynPropertiesImpl newDefault() {
            return new Builder(true).build();
        }

        public static Builder builderDefault() {
            return new Builder(true);
        }

        public static Builder builderEmpty() {
            return new Builder(false);
        }

        private static void addPropertiesFromUrl(BrooklynPropertiesImpl p, String url, boolean warnIfNotFound) {
            block4: {
                if (url == null) {
                    return;
                }
                try {
                    p.addFrom(ResourceUtils.create(BrooklynPropertiesImpl.class).getResourceFromUrl(url));
                }
                catch (Exception e) {
                    if (warnIfNotFound) {
                        LOG.warn("Could not load {}; continuing", (Object)url);
                    }
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("Could not load " + url + "; continuing", (Throwable)e);
                }
            }
        }

        private static void addPropertiesFromFile(BrooklynPropertiesImpl p, String file) {
            if (file == null) {
                return;
            }
            String fileTidied = Os.tidyPath((String)file);
            File f = new File(fileTidied);
            if (f.exists()) {
                p.addFrom(f);
            }
        }

        public static class Builder {
            private String defaultLocationMetadataUrl;
            private String globalLocationMetadataFile = null;
            private String globalPropertiesFile = null;
            private String localPropertiesFile = null;
            private BrooklynPropertiesImpl originalProperties = null;

            @Deprecated
            public Builder() {
                this(true);
            }

            private Builder(boolean setGlobalFileDefaults) {
                this.resetDefaultLocationMetadataUrl();
                if (setGlobalFileDefaults) {
                    this.resetGlobalFiles();
                }
            }

            public Builder resetDefaultLocationMetadataUrl() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                return this;
            }

            public Builder resetGlobalFiles() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                this.globalLocationMetadataFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "location-metadata.properties"});
                this.globalPropertiesFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "brooklyn.properties"});
                return this;
            }

            private Builder(BrooklynPropertiesImpl originalProperties) {
                this.originalProperties = new BrooklynPropertiesImpl().addFromMap(originalProperties.asMapWithStringKeys());
            }

            public Builder defaultLocationMetadataUrl(String val) {
                this.defaultLocationMetadataUrl = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalLocationMetadataFile(String val) {
                this.globalLocationMetadataFile = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalPropertiesFile(String val) {
                this.globalPropertiesFile = val;
                return this;
            }

            @Beta
            public boolean hasDelegateOriginalProperties() {
                return this.originalProperties == null;
            }

            public Builder localPropertiesFile(String val) {
                this.localPropertiesFile = val;
                return this;
            }

            public BrooklynPropertiesImpl build() {
                if (this.originalProperties != null) {
                    return new BrooklynPropertiesImpl().addFromMap(this.originalProperties.asMapWithStringKeys());
                }
                BrooklynPropertiesImpl properties = new BrooklynPropertiesImpl();
                Factory.addPropertiesFromUrl(properties, this.defaultLocationMetadataUrl, false);
                Factory.addPropertiesFromFile(properties, this.globalLocationMetadataFile);
                Factory.addPropertiesFromFile(properties, this.globalPropertiesFile);
                Factory.addPropertiesFromFile(properties, this.localPropertiesFile);
                properties.addEnvironmentVars();
                properties.addSystemProperties();
                return properties;
            }

            public static Builder fromProperties(BrooklynPropertiesImpl brooklynProperties) {
                return new Builder(brooklynProperties);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalProperties", (Object)this.originalProperties).add("defaultLocationMetadataUrl", (Object)this.defaultLocationMetadataUrl).add("globalLocationMetadataUrl", (Object)this.globalLocationMetadataFile).add("globalPropertiesFile", (Object)this.globalPropertiesFile).add("localPropertiesFile", (Object)this.localPropertiesFile).toString();
            }
        }
    }
}

