/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.util.guava.SerializablePredicate;

public class LocationPredicates {
    @Deprecated
    private static <T> Predicate<Location> idEqualToOld(final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getId(), (Object)val);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> displayNameEqualToOld(final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getDisplayName(), (Object)val);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> configEqualToOld(final ConfigKey<T> configKey, final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> configEqualToOld(final ConfigKey.HasConfigKey<T> configKey, final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> isChildOfOld(final Location parent) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getParent(), (Object)parent);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> isDescendantOfOld(final Location ancestor) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                Location contenderAncestor;
                Location location = contenderAncestor = input == null ? input : input.getParent();
                while (contenderAncestor != null) {
                    if (Objects.equal((Object)contenderAncestor, (Object)ancestor)) {
                        return true;
                    }
                    contenderAncestor = contenderAncestor.getParent();
                }
                return false;
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Location> managedOld() {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Locations.isManaged(input);
            }
        };
    }

    public static Predicate<Location> idEqualTo(String val) {
        return LocationPredicates.idSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<Location> idSatisfies(Predicate<? super String> condition) {
        return new IdSatisfies(condition);
    }

    public static Predicate<Location> displayNameEqualTo(String val) {
        return LocationPredicates.displayNameSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<Location> displayNameSatisfies(Predicate<? super String> condition) {
        return new DisplayNameSatisfies(condition);
    }

    public static <T> Predicate<Location> configEqualTo(ConfigKey<T> configKey, T val) {
        return LocationPredicates.configSatisfies(configKey, Predicates.equalTo(val));
    }

    public static <T> Predicate<Location> configSatisfies(ConfigKey<T> configKey, Predicate<T> condition) {
        return new ConfigKeySatisfies(configKey, condition);
    }

    public static <T> Predicate<Location> configEqualTo(ConfigKey.HasConfigKey<T> configKey, T val) {
        return LocationPredicates.configEqualTo(configKey.getConfigKey(), val);
    }

    public static <T> Predicate<Location> configSatisfies(ConfigKey.HasConfigKey<T> configKey, Predicate<T> condition) {
        return new ConfigKeySatisfies(configKey.getConfigKey(), condition);
    }

    public static Predicate<Location> isChildOf(Location parent) {
        return new IsChildOf(parent);
    }

    public static <T> Predicate<Location> isDescendantOf(Location ancestor) {
        return new IsDescendantOf(ancestor);
    }

    public static <T> Predicate<Location> managed() {
        return IsManaged.INSTANCE;
    }

    protected static class IsManaged
    implements Predicate<Location> {
        protected static final IsManaged INSTANCE = new IsManaged();

        protected IsManaged() {
        }

        public boolean apply(@Nullable Location input) {
            return input != null && Locations.isManaged(input);
        }
    }

    protected static class IsDescendantOf
    implements SerializablePredicate<Location> {
        protected final Location ancestor;

        protected IsDescendantOf(Location ancestor) {
            this.ancestor = ancestor;
        }

        public boolean apply(@Nullable Location input) {
            Location contenderAncestor;
            Location location = contenderAncestor = input == null ? input : input.getParent();
            while (contenderAncestor != null) {
                if (Objects.equal((Object)contenderAncestor, (Object)this.ancestor)) {
                    return true;
                }
                contenderAncestor = contenderAncestor.getParent();
            }
            return false;
        }
    }

    protected static class IsChildOf
    implements SerializablePredicate<Location> {
        protected final Location parent;

        protected IsChildOf(Location parent) {
            this.parent = parent;
        }

        public boolean apply(@Nullable Location input) {
            return input != null && Objects.equal((Object)input.getParent(), (Object)this.parent);
        }

        public String toString() {
            return "isChildOf(" + this.parent + ")";
        }
    }

    protected static class ConfigKeySatisfies<T>
    implements SerializablePredicate<Location> {
        protected final ConfigKey<T> configKey;
        protected final Predicate<T> condition;

        private ConfigKeySatisfies(ConfigKey<T> configKey, Predicate<T> condition) {
            this.configKey = configKey;
            this.condition = condition;
        }

        public boolean apply(@Nullable Location input) {
            return input != null && this.condition.apply(input.getConfig(this.configKey));
        }

        public String toString() {
            return "configKeySatisfies(" + this.configKey.getName() + "," + this.condition + ")";
        }
    }

    protected static class DisplayNameSatisfies
    implements SerializablePredicate<Location> {
        protected final Predicate<? super String> condition;

        protected DisplayNameSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Location input) {
            return input != null && this.condition.apply((Object)input.getDisplayName());
        }

        public String toString() {
            return "displayNameSatisfies(" + this.condition + ")";
        }
    }

    protected static class IdSatisfies
    implements SerializablePredicate<Location> {
        protected final Predicate<? super String> condition;

        protected IdSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Location input) {
            return input != null && this.condition.apply((Object)input.getId());
        }

        public String toString() {
            return "idSatisfies(" + this.condition + ")";
        }
    }
}

