/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.HasSubnetHostname;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.HasNetworkAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Machines {
    private static final Logger log = LoggerFactory.getLogger(Machines.class);

    public static Maybe<String> getSubnetHostname(Location where) {
        String hostname = null;
        if (where instanceof HasSubnetHostname) {
            hostname = ((HasSubnetHostname)where).getSubnetHostname();
        }
        if (hostname == null && where instanceof MachineLocation) {
            Maybe<String> subnetIp = Machines.getSubnetIp(where);
            if (subnetIp.isPresent()) {
                hostname = (String)subnetIp.get();
            } else {
                InetAddress addr = ((MachineLocation)where).getAddress();
                if (addr != null) {
                    hostname = addr.getHostAddress();
                }
            }
        }
        log.debug("computed subnet hostname {} for {}", (Object)hostname, (Object)where);
        return Maybe.fromNullable((Object)hostname);
    }

    public static Maybe<String> getSubnetIp(Location where) {
        InetAddress addr;
        Set privateAddrs;
        String result = null;
        if (where instanceof HasSubnetHostname) {
            result = ((HasSubnetHostname)where).getSubnetIp();
        }
        if (where instanceof HasNetworkAddresses && (privateAddrs = ((HasNetworkAddresses)where).getPrivateAddresses()).size() > 0) {
            result = (String)Iterables.get((Iterable)privateAddrs, (int)0);
        }
        if (result == null && where instanceof MachineLocation && (addr = ((MachineLocation)where).getAddress()) != null) {
            result = addr.getHostAddress();
        }
        log.debug("computed subnet host ip {} for {}", (Object)result, (Object)where);
        return Maybe.fromNullable((Object)result);
    }

    @Nonnull
    public static <T> Maybe<T> findUniqueElement(Iterable<?> items, Class<T> type) {
        if (items == null) {
            return Maybe.absent((Throwable)new NullPointerException("Null iterable"));
        }
        Iterator<?> i = items.iterator();
        Object result = null;
        while (i.hasNext()) {
            Object candidate = i.next();
            if (!type.isInstance(candidate)) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace("Multiple instances of " + type + " in " + items + "; ignoring");
            }
            return Maybe.absent((Throwable)new IllegalStateException("Multiple instances of " + type + " in " + items + "; expected a single one"));
        }
        if (result == null) {
            return Maybe.absent((Throwable)new IllegalStateException("No instances of " + type + " available (in " + items + ")"));
        }
        return Maybe.of(result);
    }

    @Deprecated
    public static Maybe<SshMachineLocation> findUniqueSshMachineLocation(Iterable<? extends Location> locations) {
        return Machines.findUniqueMachineLocation(locations, SshMachineLocation.class);
    }

    public static Maybe<MachineLocation> findUniqueMachineLocation(Iterable<? extends Location> locations) {
        return Machines.findUniqueMachineLocation(locations, MachineLocation.class);
    }

    public static <T extends MachineLocation> Maybe<T> findUniqueMachineLocation(Iterable<? extends Location> locations, Class<T> clazz) {
        return Machines.findUniqueElement(locations, clazz);
    }

    public static Maybe<String> findSubnetHostname(Iterable<? extends Location> ll) {
        Maybe<MachineLocation> l = Machines.findUniqueMachineLocation(ll);
        if (!l.isPresent()) {
            return Maybe.absent();
        }
        return Machines.getSubnetHostname((Location)l.get());
    }

    public static Maybe<String> findSubnetHostname(Entity entity) {
        String sh = (String)entity.getAttribute(Attributes.SUBNET_HOSTNAME);
        if (sh != null) {
            return Maybe.of((Object)sh);
        }
        return Machines.findSubnetHostname(entity.getLocations());
    }

    public static Maybe<String> findSubnetOrPublicHostname(Entity entity) {
        String hn = (String)entity.getAttribute(Attributes.HOSTNAME);
        if (hn != null) {
            Maybe<String> sn = Machines.findSubnetHostname(entity);
            if (sn.isPresent()) {
                return sn;
            }
            return Maybe.of((Object)hn);
        }
        Maybe<MachineLocation> l = Machines.findUniqueMachineLocation(entity.getLocations());
        if (!l.isPresent()) {
            return Maybe.absent();
        }
        InetAddress addr = ((MachineLocation)l.get()).getAddress();
        if (addr == null) {
            return Maybe.absent();
        }
        return Maybe.fromNullable((Object)addr.getHostName());
    }

    public static Maybe<String> findSubnetOrPrivateIp(Entity entity) {
        String hn = (String)entity.getAttribute(Attributes.ADDRESS);
        if (hn != null) {
            Maybe<String> sn = Machines.findSubnetIp(entity);
            if (sn.isPresent()) {
                return sn;
            }
            return Maybe.of((Object)hn);
        }
        Maybe<MachineLocation> l = Machines.findUniqueMachineLocation(entity.getLocations());
        if (!l.isPresent()) {
            return Maybe.absent();
        }
        InetAddress addr = ((MachineLocation)l.get()).getAddress();
        if (addr == null) {
            return Maybe.absent();
        }
        return Maybe.fromNullable((Object)addr.getHostAddress());
    }

    public static Maybe<String> findSubnetIp(Entity entity) {
        String sh = (String)entity.getAttribute(Attributes.SUBNET_ADDRESS);
        if (sh != null) {
            return Maybe.of((Object)sh);
        }
        return Machines.findSubnetIp(entity.getLocations());
    }

    public static Maybe<String> findSubnetIp(Iterable<? extends Location> ll) {
        Maybe<MachineLocation> l = Machines.findUniqueMachineLocation(ll);
        return l.isPresent() ? Machines.getSubnetIp((Location)l.get()) : Maybe.absent();
    }

    public static boolean warnIfLocalhost(Collection<? extends Location> locations, String message) {
        Location l;
        if (locations.size() == 1 && ((l = locations.iterator().next()) instanceof LocalhostMachineProvisioningLocation || l instanceof LocalhostMachineProvisioningLocation.LocalhostMachine)) {
            log.warn(message);
            return true;
        }
        return false;
    }
}

