/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.text.StringEscapes;

public class PortRanges {
    public static final int MAX_PORT = 65535;
    public static final PortRange ANY_HIGH_PORT = new LinearPortRange(1024, 65535);
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    public static PortRange fromInteger(int x) {
        return new SinglePort(x);
    }

    public static PortRange fromIterable(Iterable<?> c) {
        ArrayList<PortRange> l = new ArrayList<PortRange>();
        for (Object o : c) {
            if (o instanceof Integer) {
                l.add(PortRanges.fromInteger((Integer)o));
                continue;
            }
            if (o instanceof String) {
                for (String string : StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)((String)o))) {
                    l.add(PortRanges.fromString(string));
                }
                continue;
            }
            if (o instanceof Iterable) {
                l.add(PortRanges.fromIterable((Iterable)o));
                continue;
            }
            if (o instanceof int[]) {
                l.add(PortRanges.fromIterable(Ints.asList((int[])((int[])o))));
                continue;
            }
            if (o instanceof String[]) {
                for (String string : (String[])o) {
                    l.add(PortRanges.fromString(string));
                }
                continue;
            }
            if (o instanceof Object[]) {
                for (Object object : (Object[])o) {
                    if (object instanceof Integer) {
                        l.add(PortRanges.fromInteger((Integer)object));
                        continue;
                    }
                    if (object instanceof String) {
                        l.add(PortRanges.fromString((String)object));
                        continue;
                    }
                    throw new IllegalArgumentException("'" + object + "' must be of type Integer or String");
                }
                continue;
            }
            l.add(TypeCoercions.coerce(o, PortRange.class));
        }
        return new AggregatePortRange(l);
    }

    public static PortRange fromString(String s) {
        ArrayList<PortRange> l = new ArrayList<PortRange>();
        for (String si : s.split(",")) {
            int end;
            int start;
            if ((si = si.trim()).endsWith("+")) {
                String si2 = si.substring(0, si.length() - 1).trim();
                start = Integer.parseInt(si2);
                end = 65535;
            } else if (si.indexOf(45) > 0) {
                int v = si.indexOf(45);
                start = Integer.parseInt(si.substring(0, v).trim());
                end = Integer.parseInt(si.substring(v + 1).trim());
            } else {
                if (si.length() == 0) continue;
                l.add(new SinglePort(Integer.parseInt(si)));
                continue;
            }
            l.add(new LinearPortRange(start, end));
        }
        if (l.size() == 1) {
            return (PortRange)l.get(0);
        }
        return new AggregatePortRange(l);
    }

    public static void init() {
        if (initialized.compareAndSet(false, true)) {
            TypeCoercions.registerAdapter(Integer.class, PortRange.class, new Function<Integer, PortRange>(){

                public PortRange apply(Integer x) {
                    return PortRanges.fromInteger(x);
                }
            });
            TypeCoercions.registerAdapter(String.class, PortRange.class, new Function<String, PortRange>(){

                public PortRange apply(String x) {
                    return PortRanges.fromString(x);
                }
            });
            TypeCoercions.registerAdapter(Iterable.class, PortRange.class, new Function<Iterable, PortRange>(){

                public PortRange apply(Iterable x) {
                    return PortRanges.fromIterable(x);
                }
            });
        }
    }

    static {
        PortRanges.init();
    }

    public static class AggregatePortRange
    implements PortRange,
    Serializable {
        private static final long serialVersionUID = 7332682500816739660L;
        final List<PortRange> ranges;

        private AggregatePortRange(List<PortRange> ranges) {
            this.ranges = ImmutableList.copyOf(ranges);
        }

        public Iterator<Integer> iterator() {
            return Iterables.concat(this.ranges).iterator();
        }

        public boolean isEmpty() {
            for (PortRange r : this.ranges) {
                if (r.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean asBoolean() {
            return !this.isEmpty();
        }

        public String toString() {
            String s = "";
            for (PortRange r : this.ranges) {
                if (s.length() > 0) {
                    s = s + ",";
                }
                s = s + r;
            }
            return s;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ranges});
        }

        public boolean equals(Object obj) {
            return obj instanceof AggregatePortRange && this.ranges.equals(((AggregatePortRange)obj).ranges);
        }
    }

    public static class LinearPortRange
    implements PortRange,
    Serializable {
        private static final long serialVersionUID = -9165280509363743508L;
        final int start;
        final int end;
        final int delta;

        private LinearPortRange(int start, int end, int delta) {
            this.start = start;
            this.end = end;
            this.delta = delta;
            Preconditions.checkArgument((start > 0 && start <= 65535 ? 1 : 0) != 0, (String)"start port %s out of range", (Object[])new Object[]{start});
            Preconditions.checkArgument((end > 0 && end <= 65535 ? 1 : 0) != 0, (String)"end port %s out of range", (Object[])new Object[]{end});
            Preconditions.checkArgument((boolean)(delta > 0 ? start <= end : start >= end), (String)"start and end out of order: %s to %s, delta %s", (Object[])new Object[]{start, end, delta});
            Preconditions.checkArgument((delta != 0 ? 1 : 0) != 0, (Object)"delta must be non-zero");
        }

        public LinearPortRange(int start, int end) {
            this(start, end, start <= end ? 1 : -1);
        }

        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                int next;
                boolean hasNext;
                {
                    this.next = start;
                    this.hasNext = true;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Integer next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException("Exhausted available ports");
                    }
                    int result = this.next;
                    this.next += delta;
                    if (delta > 0 && this.next > end || delta < 0 && this.next < end) {
                        this.hasNext = false;
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean asBoolean() {
            return true;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.start, this.end, this.delta});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LinearPortRange)) {
                return false;
            }
            LinearPortRange o = (LinearPortRange)obj;
            return this.start == o.start && this.end == o.end && this.delta == o.delta;
        }
    }

    public static class SinglePort
    implements PortRange,
    Serializable {
        private static final long serialVersionUID = 7446781416534230401L;
        final int port;

        private SinglePort(int port) {
            this.port = port;
        }

        public Iterator<Integer> iterator() {
            return Collections.singletonList(this.port).iterator();
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean asBoolean() {
            return true;
        }

        public String toString() {
            return "" + this.port;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.port});
        }

        public boolean equals(Object obj) {
            return obj instanceof SinglePort && this.port == ((SinglePort)obj).port;
        }
    }
}

