/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.access;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.SupportsPortForwarding;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynAccessUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynAccessUtils.class);
    public static final ConfigKey<PortForwardManager> PORT_FORWARDING_MANAGER = new BasicConfigKey<PortForwardManager>(PortForwardManager.class, "brooklyn.portforwarding.manager", "A port-forwarding manager to use at an entity or a location, where supported; note this should normally be a serializable client instance to prevent the creation of multiple disconnected instances via config duplication");
    public static final ConfigKey<Cidr> MANAGEMENT_ACCESS_CIDR = new BasicConfigKey<Object>(Cidr.class, "brooklyn.portforwarding.management.cidr", "CIDR to enable by default for port-forwarding for management", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostAndPort getBrooklynAccessibleAddress(Entity entity, int port) {
        EntityInternal entityInternal = (EntityInternal)entity;
        PortForwardManager pfw = (PortForwardManager)entity.getConfig(PORT_FORWARDING_MANAGER);
        if (pfw == null) {
            log.debug("No PortForwardManager, using default");
            pfw = (PortForwardManager)entityInternal.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
        }
        Collection ll = entity.getLocations();
        Class<BrooklynAccessUtils> clazz = BrooklynAccessUtils.class;
        synchronized (BrooklynAccessUtils.class) {
            for (MachineLocation machine : Iterables.filter((Iterable)ll, MachineLocation.class)) {
                HostAndPort hp = pfw.lookup((Location)machine, port);
                if (hp == null) continue;
                log.debug("BrooklynAccessUtils found port-forwarded address {} for entity {}, port {}, using machine {}", new Object[]{hp, entity, port, machine});
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return hp;
            }
            Maybe<SupportsPortForwarding> supportPortForwardingLoc = Machines.findUniqueElement(ll, SupportsPortForwarding.class);
            if (supportPortForwardingLoc.isPresent()) {
                Cidr source = (Cidr)entity.getConfig(MANAGEMENT_ACCESS_CIDR);
                SupportsPortForwarding loc = (SupportsPortForwarding)supportPortForwardingLoc.get();
                if (source != null) {
                    log.debug("BrooklynAccessUtils requesting new port-forwarding rule to access " + port + " on " + entity + " (at " + loc + ", enabled for " + source + ")");
                    HostAndPort hp = loc.getSocketEndpointFor(source, port);
                    if (hp != null) {
                        log.debug("BrooklynAccessUtils created port-forwarded address {} for entity {}, port {}, using {}", new Object[]{hp, entity, port, loc});
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                        return hp;
                    }
                } else {
                    log.warn("No " + MANAGEMENT_ACCESS_CIDR.getName() + " configured for " + entity + ", so cannot forward port " + port + " even though " + PORT_FORWARDING_MANAGER.getName() + " was supplied, and have location supporting port forwarding " + loc);
                }
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            String host = (String)entity.getAttribute(Attributes.HOSTNAME);
            if (host != null) {
                return HostAndPort.fromParts((String)host, (int)port);
            }
            throw new IllegalStateException("Cannot find way to access port " + port + " on " + entity + " from Brooklyn (no host.name)");
        }
    }

    public static String getResolvedAddress(Entity entity, SshMachineLocation origin, String hostnameTarget) {
        ProcessTaskWrapper task = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory(origin, "ping -c 1 -t 1 " + hostnameTarget).summary("checking resolution of " + hostnameTarget).allowingNonZeroExitCode().newTask();
        DynamicTasks.queueIfPossible(task).orSubmitAndBlock(entity).asTask().blockUntilEnded();
        if (task.asTask().isError()) {
            log.warn("ping could not be run, at " + entity + " / " + origin + ": " + Tasks.getError(task.asTask()));
            return "";
        }
        if (task.getExitCode() == null || task.getExitCode() != 0) {
            if (task.getExitCode() != null && task.getExitCode() < 10) {
                log.debug("not able to resolve " + hostnameTarget + " from " + origin + " for " + entity + " because exit code was " + task.getExitCode());
                return null;
            }
            log.warn("ping not run as expected, at " + entity + " / " + origin + " (code " + task.getExitCode() + "):\n" + task.getStdout().trim() + " --- " + task.getStderr().trim());
            return "";
        }
        String out = task.getStdout();
        try {
            String line1 = Strings.getFirstLine((String)out);
            String ip = Strings.getFragmentBetween((String)line1, (String)"(", (String)")");
            if (Strings.isNonBlank((CharSequence)ip)) {
                return ip;
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        if (out.contains("127.0.0.1")) {
            return "127.0.0.1";
        }
        return "";
    }

    public static Supplier<String> resolvedAddressSupplier(final Entity entity, final SshMachineLocation origin, final String hostnameTarget) {
        return new Supplier<String>(){

            public String get() {
                return BrooklynAccessUtils.getResolvedAddress(entity, origin, hostnameTarget);
            }
        };
    }
}

