/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.access;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.location.access.PortMapping;
import org.apache.brooklyn.core.mgmt.rebind.BasicLocationRebindSupport;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardManagerImpl
extends AbstractLocation
implements PortForwardManager {
    private static final Logger log = LoggerFactory.getLogger(PortForwardManagerImpl.class);
    protected final Map<String, PortMapping> mappings = new LinkedHashMap<String, PortMapping>();
    private final Map<PortForwardManager.AssociationListener, Predicate<? super PortForwardManager.AssociationMetadata>> associationListeners = new ConcurrentHashMap<PortForwardManager.AssociationListener, Predicate<? super PortForwardManager.AssociationMetadata>>();
    @Deprecated
    protected final Map<String, String> publicIpIdToHostname = new LinkedHashMap<String, String>();
    private final AtomicInteger portReserved = new AtomicInteger(11000);
    private final Object mutex = new Object();

    public PortForwardManagerImpl() {
        if (this.isLegacyConstruction()) {
            log.warn("Deprecated construction of " + PortForwardManagerImpl.class.getName() + "; instead use location resolver");
        }
    }

    @Override
    public void init() {
        super.init();
        Object rawPort = this.getAllConfigBag().getStringKey(PORT_FORWARD_MANAGER_STARTING_PORT.getName());
        Integer portStartingPoint = rawPort != null ? (Integer)this.getConfig(PORT_FORWARD_MANAGER_STARTING_PORT) : (Integer)this.getManagementContext().getConfig().getConfig(PORT_FORWARD_MANAGER_STARTING_PORT);
        this.portReserved.set(portStartingPoint);
        log.debug(this + " set initial port to " + portStartingPoint);
    }

    @Override
    public RebindSupport<LocationMemento> getRebindSupport() {
        return new BasicLocationRebindSupport(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LocationMemento getMemento() {
                MutableMap publicIpIdToHostnameCopy;
                MutableMap mappingsCopy;
                Object object = PortForwardManagerImpl.this.mutex;
                synchronized (object) {
                    mappingsCopy = MutableMap.copyOf(PortForwardManagerImpl.this.mappings);
                    publicIpIdToHostnameCopy = MutableMap.copyOf(PortForwardManagerImpl.this.publicIpIdToHostname);
                }
                return this.getMementoWithProperties((Map<String, ?>)MutableMap.of((Object)"mappings", (Object)mappingsCopy, (Object)"portReserved", (Object)PortForwardManagerImpl.this.portReserved.get(), (Object)"publicIpIdToHostname", (Object)publicIpIdToHostnameCopy));
            }

            @Override
            protected void doReconstruct(RebindContext rebindContext, LocationMemento memento) {
                super.doReconstruct(rebindContext, memento);
                PortForwardManagerImpl.this.mappings.putAll((Map)Preconditions.checkNotNull((Object)((Map)memento.getCustomField("mappings")), (Object)"mappings was not serialized correctly"));
                PortForwardManagerImpl.this.portReserved.set((Integer)memento.getCustomField("portReserved"));
                PortForwardManagerImpl.this.publicIpIdToHostname.putAll((Map)Preconditions.checkNotNull((Object)((Map)memento.getCustomField("publicIpIdToHostname")), (Object)"publicIpIdToHostname was not serialized correctly"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int acquirePublicPort(String publicIpId) {
        int port;
        Object object = this.mutex;
        synchronized (object) {
            port = this.getNextPort();
            PortMapping mapping = new PortMapping(publicIpId, port, null, -1);
            log.debug(this + " allocating public port " + port + " on " + publicIpId + " (no association info yet)");
            this.mappings.put(this.makeKey(publicIpId, port), mapping);
        }
        this.onChanged();
        return port;
    }

    protected int getNextPort() {
        return this.portReserved.getAndIncrement();
    }

    @Override
    public void associate(String publicIpId, HostAndPort publicEndpoint, Location l, int privatePort) {
        this.associateImpl(publicIpId, publicEndpoint, l, privatePort);
        this.emitAssociationCreatedEvent(publicIpId, publicEndpoint, l, privatePort);
    }

    @Override
    public void associate(String publicIpId, HostAndPort publicEndpoint, int privatePort) {
        this.associateImpl(publicIpId, publicEndpoint, null, privatePort);
        this.emitAssociationCreatedEvent(publicIpId, publicEndpoint, null, privatePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateImpl(String publicIpId, HostAndPort publicEndpoint, Location l, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            String publicIp = publicEndpoint.getHostText();
            int publicPort = publicEndpoint.getPort();
            this.recordPublicIpHostname(publicIpId, publicIp);
            PortMapping mapping = new PortMapping(publicIpId, publicEndpoint, l, privatePort);
            PortMapping oldMapping = this.getPortMappingWithPublicSide(publicIpId, publicPort);
            log.debug(this + " associating public " + publicEndpoint + " on " + publicIpId + " with private port " + privatePort + " at " + l + " (" + mapping + ")" + (oldMapping == null ? "" : " (overwriting " + oldMapping + " )"));
            this.mappings.put(this.makeKey(publicIpId, publicPort), mapping);
        }
        this.onChanged();
    }

    private void emitAssociationCreatedEvent(String publicIpId, HostAndPort publicEndpoint, Location location, int privatePort) {
        PortForwardManager.AssociationMetadata metadata = new PortForwardManager.AssociationMetadata(publicIpId, publicEndpoint, location, privatePort);
        for (Map.Entry<PortForwardManager.AssociationListener, Predicate<? super PortForwardManager.AssociationMetadata>> entry : this.associationListeners.entrySet()) {
            if (!entry.getValue().apply((Object)metadata)) continue;
            try {
                entry.getKey().onAssociationCreated(metadata);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Exception thrown when emitting association creation event " + metadata, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostAndPort lookup(Location l, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            for (PortMapping m : this.mappings.values()) {
                if (!l.equals(m.target) || privatePort != m.privatePort) continue;
                return this.getPublicHostAndPort(m);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostAndPort lookup(String publicIpId, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            for (PortMapping m : this.mappings.values()) {
                if (!publicIpId.equals(m.publicIpId) || privatePort != m.privatePort) continue;
                return this.getPublicHostAndPort(m);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forgetPortMapping(String publicIpId, int publicPort) {
        PortMapping old;
        Object object = this.mutex;
        synchronized (object) {
            old = this.mappings.remove(this.makeKey(publicIpId, publicPort));
            if (old != null) {
                this.emitAssociationDeletedEvent(this.associationMetadataFromPortMapping(old));
            }
            log.debug("cleared port mapping for " + publicIpId + ":" + publicPort + " - " + old);
        }
        if (old != null) {
            this.onChanged();
        }
        return old != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forgetPortMappings(Location l) {
        ArrayList result = Lists.newArrayList();
        Object object = this.mutex;
        synchronized (object) {
            Iterator<PortMapping> iter = this.mappings.values().iterator();
            while (iter.hasNext()) {
                PortMapping m = iter.next();
                if (!l.equals(m.target)) continue;
                iter.remove();
                result.add(m);
                this.emitAssociationDeletedEvent(this.associationMetadataFromPortMapping(m));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("cleared all port mappings for " + l + " - " + result);
        }
        if (!result.isEmpty()) {
            this.onChanged();
        }
        return !result.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forgetPortMappings(String publicIpId) {
        ArrayList result = Lists.newArrayList();
        Object object = this.mutex;
        synchronized (object) {
            Iterator<PortMapping> iter = this.mappings.values().iterator();
            while (iter.hasNext()) {
                PortMapping m = iter.next();
                if (!publicIpId.equals(m.publicIpId)) continue;
                iter.remove();
                result.add(m);
                this.emitAssociationDeletedEvent(this.associationMetadataFromPortMapping(m));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("cleared all port mappings for " + publicIpId + " - " + result);
        }
        if (!result.isEmpty()) {
            this.onChanged();
        }
        return !result.isEmpty();
    }

    private void emitAssociationDeletedEvent(PortForwardManager.AssociationMetadata metadata) {
        for (Map.Entry<PortForwardManager.AssociationListener, Predicate<? super PortForwardManager.AssociationMetadata>> entry : this.associationListeners.entrySet()) {
            if (!entry.getValue().apply((Object)metadata)) continue;
            try {
                entry.getKey().onAssociationDeleted(metadata);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Exception thrown when emitting association creation event " + metadata, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Objects.ToStringHelper string() {
        int size;
        Object object = this.mutex;
        synchronized (object) {
            size = this.mappings.size();
        }
        return super.string().add("scope", (Object)this.getScope()).add("mappingsSize", size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toVerboseString() {
        String mappingsStr;
        Object object = this.mutex;
        synchronized (object) {
            mappingsStr = this.mappings.toString();
        }
        return this.string().add("mappings", (Object)mappingsStr).toString();
    }

    @Override
    public String getScope() {
        return (String)Preconditions.checkNotNull(this.getConfig(SCOPE), (Object)"scope");
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void addAssociationListener(PortForwardManager.AssociationListener listener, Predicate<? super PortForwardManager.AssociationMetadata> filter) {
        this.associationListeners.put(listener, filter);
    }

    @Override
    public void removeAssociationListener(PortForwardManager.AssociationListener listener) {
        this.associationListeners.remove(listener);
    }

    protected String makeKey(String publicIpId, int publicPort) {
        return publicIpId + ":" + publicPort;
    }

    private PortForwardManager.AssociationMetadata associationMetadataFromPortMapping(PortMapping portMapping) {
        String publicIpId = portMapping.getPublicEndpoint().getHostText();
        HostAndPort publicEndpoint = portMapping.getPublicEndpoint();
        Location location = portMapping.getTarget();
        int privatePort = portMapping.getPrivatePort();
        return new PortForwardManager.AssociationMetadata(publicIpId, publicEndpoint, location, privatePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PortMapping> getPortMappings() {
        Object object = this.mutex;
        synchronized (object) {
            return ImmutableList.copyOf(this.mappings.values());
        }
    }

    public Map<String, Integer> getPortCounters() {
        return ImmutableMap.of((Object)"global", (Object)this.portReserved.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PortMapping acquirePublicPortExplicit(String publicIpId, int port) {
        PortMapping result;
        PortMapping mapping = new PortMapping(publicIpId, port, null, -1);
        log.debug("assigning explicit public port " + port + " at " + publicIpId);
        Object object = this.mutex;
        synchronized (object) {
            result = this.mappings.put(this.makeKey(publicIpId, port), mapping);
        }
        this.onChanged();
        return result;
    }

    @Override
    @Deprecated
    public boolean forgetPortMapping(PortMapping m) {
        return this.forgetPortMapping(m.publicIpId, m.publicPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void recordPublicIpHostname(String publicIpId, String hostnameOrPublicIpAddress) {
        log.debug("recording public IP " + publicIpId + " associated with " + hostnameOrPublicIpAddress);
        Object object = this.mutex;
        synchronized (object) {
            String old = this.publicIpIdToHostname.put(publicIpId, hostnameOrPublicIpAddress);
            if (old != null && !old.equals(hostnameOrPublicIpAddress)) {
                log.warn("Changing hostname recorded against public IP " + publicIpId + "; from " + old + " to " + hostnameOrPublicIpAddress);
            }
        }
        this.onChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getPublicIpHostname(String publicIpId) {
        Object object = this.mutex;
        synchronized (object) {
            return this.publicIpIdToHostname.get(publicIpId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean forgetPublicIpHostname(String publicIpId) {
        boolean result;
        log.debug("forgetting public IP " + publicIpId + " association");
        Object object = this.mutex;
        synchronized (object) {
            result = this.publicIpIdToHostname.remove(publicIpId) != null;
        }
        this.onChanged();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int acquirePublicPort(String publicIpId, Location l, int privatePort) {
        int publicPort;
        Object object = this.mutex;
        synchronized (object) {
            PortMapping old = this.getPortMappingWithPrivateSide(l, privatePort);
            if (old != null && old.publicIpId.equals(publicIpId)) {
                log.debug("request to acquire public port at " + publicIpId + " for " + l + ":" + privatePort + ", reusing old assignment " + old);
                return old.getPublicPort();
            }
            publicPort = this.acquirePublicPort(publicIpId);
            log.debug("request to acquire public port at " + publicIpId + " for " + l + ":" + privatePort + ", allocating " + publicPort);
            this.associateImpl(publicIpId, publicPort, l, privatePort);
        }
        this.onChanged();
        return publicPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void associate(String publicIpId, int publicPort, Location l, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            this.associateImpl(publicIpId, publicPort, l, privatePort);
        }
        this.onChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateImpl(String publicIpId, int publicPort, Location l, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            PortMapping mapping = new PortMapping(publicIpId, publicPort, l, privatePort);
            PortMapping oldMapping = this.getPortMappingWithPublicSide(publicIpId, publicPort);
            log.debug("associating public port " + publicPort + " on " + publicIpId + " with private port " + privatePort + " at " + l + " (" + mapping + ")" + (oldMapping == null ? "" : " (overwriting " + oldMapping + " )"));
            this.mappings.put(this.makeKey(publicIpId, publicPort), mapping);
        }
    }

    @Override
    public HostAndPort getPublicHostAndPort(PortMapping m) {
        if (m.publicEndpoint == null) {
            String hostname = this.getPublicIpHostname(m.publicIpId);
            if (hostname == null) {
                throw new IllegalStateException("No public hostname associated with " + m.publicIpId + " (mapping " + m + ")");
            }
            return HostAndPort.fromParts((String)hostname, (int)m.publicPort);
        }
        return m.publicEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortMapping getPortMappingWithPublicSide(String publicIpId, int publicPort) {
        Object object = this.mutex;
        synchronized (object) {
            return this.mappings.get(this.makeKey(publicIpId, publicPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PortMapping> getPortMappingWithPublicIpId(String publicIpId) {
        ArrayList<PortMapping> result = new ArrayList<PortMapping>();
        Object object = this.mutex;
        synchronized (object) {
            for (PortMapping m : this.mappings.values()) {
                if (!publicIpId.equals(m.publicIpId)) continue;
                result.add(m);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PortMapping> getLocationPublicIpIds(Location l) {
        ArrayList<PortMapping> result = new ArrayList<PortMapping>();
        Object object = this.mutex;
        synchronized (object) {
            for (PortMapping m : this.mappings.values()) {
                if (!l.equals(m.getTarget())) continue;
                result.add(m);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortMapping getPortMappingWithPrivateSide(Location l, int privatePort) {
        Object object = this.mutex;
        synchronized (object) {
            for (PortMapping m : this.mappings.values()) {
                if (!l.equals(m.getTarget()) || privatePort != m.privatePort) continue;
                return m;
            }
        }
        return null;
    }
}

