/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.util.collections.MutableList;

@Beta
public class BrooklynTags {
    public static final String YAML_SPEC_KIND = "yaml_spec";
    public static final String NOTES_KIND = "notes";
    public static final String OWNER_ENTITY_ID = "owner_entity_id";
    public static final String ICON_URL = "icon_url";
    public static final Object CATALOG_TEMPLATE = "catalog_template";

    public static NamedStringTag newYamlSpecTag(String contents) {
        return new NamedStringTag(YAML_SPEC_KIND, contents);
    }

    public static NamedStringTag newNotesTag(String contents) {
        return new NamedStringTag(NOTES_KIND, contents);
    }

    public static NamedStringTag newOwnerEntityTag(String ownerId) {
        return new NamedStringTag(OWNER_ENTITY_ID, ownerId);
    }

    public static NamedStringTag newIconUrlTag(String iconUrl) {
        return new NamedStringTag(ICON_URL, iconUrl);
    }

    public static TraitsTag newTraitsTag(List<Class<?>> interfaces) {
        return new TraitsTag(interfaces);
    }

    public static NamedStringTag findFirst(String kind, Iterable<Object> tags) {
        for (Object object : tags) {
            if (!(object instanceof NamedStringTag) || !kind.equals(((NamedStringTag)object).kind)) continue;
            return (NamedStringTag)object;
        }
        return null;
    }

    public static List<NamedStringTag> findAll(String kind, Iterable<Object> tags) {
        MutableList result = MutableList.of();
        for (Object object : tags) {
            if (!(object instanceof NamedStringTag) || !kind.equals(((NamedStringTag)object).kind)) continue;
            result.add((NamedStringTag)object);
        }
        return result;
    }

    public static class TraitsTag
    extends ListTag<String> {
        public TraitsTag(List<Class<?>> interfaces) {
            super(new ArrayList(Lists.transform(interfaces, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
        }

        @JsonProperty(value="traits")
        public List<String> getTraits() {
            return this.list;
        }
    }

    public static class ListTag<T> {
        @JsonIgnore
        final List<T> list;

        public ListTag(List<T> list) {
            this.list = list;
        }

        public List<T> getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListTag that = (ListTag)o;
            return this.list == null ? that.list == null : this.list.equals(that.list);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.list});
        }
    }

    public static class NamedStringTag
    implements Serializable {
        private static final long serialVersionUID = 7932098757009051348L;
        @JsonProperty
        final String kind;
        @JsonProperty
        final String contents;

        public NamedStringTag(@JsonProperty(value="kind") String kind, @JsonProperty(value="contents") String contents) {
            this.kind = kind;
            this.contents = contents;
        }

        public String toString() {
            return this.kind + "[" + this.contents + "]";
        }

        public String getKind() {
            return this.kind;
        }

        public String getContents() {
            return this.contents;
        }

        public boolean equals(Object other) {
            if (!(other instanceof NamedStringTag)) {
                return false;
            }
            NamedStringTag o = (NamedStringTag)other;
            return Objects.equal((Object)this.kind, (Object)o.kind) && Objects.equal((Object)this.contents, (Object)o.contents);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.kind, this.contents});
        }
    }
}

