/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Runnables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagementUtils {
    private static final Logger log = LoggerFactory.getLogger(EntityManagementUtils.class);
    public static final ConfigKey<Boolean> WRAPPER_APP_MARKER = ((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class, "brooklyn.wrapper_app").runtimeInheritance(BasicConfigInheritance.NEVER_INHERITED)).build();

    public static <T extends Application> T createUnstarted(ManagementContext mgmt, EntitySpec<T> spec) {
        return EntityManagementUtils.createUnstarted(mgmt, spec, (Optional<String>)Optional.absent());
    }

    @Beta
    public static <T extends Application> T createUnstarted(ManagementContext mgmt, EntitySpec<T> spec, Optional<String> entityId) {
        Application app = (Application)((EntityManagerInternal)mgmt.getEntityManager()).createEntity(spec, entityId);
        return (T)app;
    }

    public static Application createUnstarted(ManagementContext mgmt, String plan) {
        EntitySpec<? extends Application> spec = EntityManagementUtils.createEntitySpecForApplication(mgmt, plan);
        return EntityManagementUtils.createUnstarted(mgmt, spec);
    }

    public static EntitySpec<? extends Application> createEntitySpecForApplication(ManagementContext mgmt, String plan) {
        return (EntitySpec)mgmt.getTypeRegistry().createSpecFromPlan(null, (Object)plan, RegisteredTypeLoadingContexts.spec(Application.class), EntitySpec.class);
    }

    @Deprecated
    public static <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT createCatalogSpec(ManagementContext mgmt, CatalogItem<T, SpecT> item) {
        return EntityManagementUtils.createCatalogSpec(mgmt, item, (Set<String>)ImmutableSet.of());
    }

    @Deprecated
    public static <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT createCatalogSpec(ManagementContext mgmt, CatalogItem<T, SpecT> item, Set<String> encounteredTypes) {
        return BasicBrooklynCatalog.internalCreateSpecLegacy(mgmt, item, encounteredTypes, true);
    }

    public static <T extends Application> CreationResult<T, Void> createStarting(ManagementContext mgmt, EntitySpec<T> appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static CreationResult<? extends Application, Void> createStarting(ManagementContext mgmt, String appSpec) {
        return EntityManagementUtils.start(EntityManagementUtils.createUnstarted(mgmt, appSpec));
    }

    public static <T extends Application> CreationResult<T, Void> start(T app) {
        Task<Void> task = Entities.invokeEffector(app, app, Startable.START, MutableMap.of((Object)"locations", (Object)MutableList.of()));
        return CreationResult.of(app, task);
    }

    public static CreationResult<List<Entity>, List<String>> addChildren(Entity parent, String yaml, Boolean start) {
        if (Boolean.FALSE.equals(start)) {
            return CreationResult.of(EntityManagementUtils.addChildrenUnstarted(parent, yaml), null);
        }
        return EntityManagementUtils.addChildrenStarting(parent, yaml);
    }

    public static List<Entity> addChildrenUnstarted(Entity parent, String yaml) {
        log.debug("Creating child of " + parent + " from yaml:\n{}", (Object)yaml);
        ManagementContext mgmt = parent.getApplication().getManagementContext();
        EntitySpec<? extends Application> specA = EntityManagementUtils.createEntitySpecForApplication(mgmt, yaml);
        MutableList specs = MutableList.of();
        if (!EntityManagementUtils.canUnwrapEntity(specA) && Strings.isEmpty((CharSequence)specA.getDisplayName())) {
            int size = specA.getChildren().size();
            String childrenCountString = size + " " + (size != 1 ? "children" : "child");
            specA.displayName("Dynamically added " + childrenCountString);
        }
        specs.add(EntityManagementUtils.unwrapEntity(specA));
        MutableList children = MutableList.of();
        for (EntitySpec spec : specs) {
            Entity child = parent.addChild(spec);
            children.add(child);
        }
        return children;
    }

    public static CreationResult<List<Entity>, List<String>> addChildrenStarting(Entity parent, String yaml) {
        final List<Entity> children = EntityManagementUtils.addChildrenUnstarted(parent, yaml);
        int size = children.size();
        String childrenCountString = size + " " + (size != 1 ? "children" : "child");
        TaskBuilder<List<String>> taskM = Tasks.builder().displayName("add children").dynamic(true).tag("NON-TRANSIENT").body(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)children, EntityFunctions.id()));
            }
        }).description("Add and start " + childrenCountString);
        TaskBuilder taskS = Tasks.builder().parallel(true).displayName("add (parallel)").description("Start each new entity");
        for (Entity child : children) {
            if (child instanceof Startable) {
                taskS.add((TaskAdaptable<?>)Effectors.invocation(child, Startable.START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of())));
                continue;
            }
            taskS.add((TaskAdaptable<?>)Tasks.builder().displayName("create").description("Skipping start (not a Startable Entity)").body(Runnables.doNothing()).tag(BrooklynTaskTags.tagForTargetEntity(child)).build());
        }
        taskM.add((TaskAdaptable<?>)taskS.build());
        Task<List<String>> task = Entities.submit(parent, taskM.build());
        return CreationResult.of(children, task);
    }

    public static EntitySpec<? extends Entity> unwrapEntity(EntitySpec<? extends Entity> wrapperApplication) {
        if (!EntityManagementUtils.canUnwrapEntity(wrapperApplication)) {
            return wrapperApplication;
        }
        EntitySpec wrappedEntity = (EntitySpec)Iterables.getOnlyElement((Iterable)wrapperApplication.getChildren());
        EntitySpec<? extends Entity> wrapperApplicationTyped = wrapperApplication;
        EntityManagementUtils.mergeWrapperParentSpecToChildEntity(wrapperApplicationTyped, wrappedEntity);
        return wrappedEntity;
    }

    public static EntitySpec<? extends Application> unwrapApplication(EntitySpec<? extends Application> wrapperApplication) {
        if (!EntityManagementUtils.canUnwrapApplication(wrapperApplication)) {
            return wrapperApplication;
        }
        EntitySpec<? extends Entity> wrappedApplication = EntityManagementUtils.unwrapEntity(wrapperApplication);
        return wrappedApplication;
    }

    private static void mergeWrapperParentSpecToChildEntity(EntitySpec<? extends Application> wrapperParent, EntitySpec<?> wrappedChild) {
        if (Strings.isNonEmpty((CharSequence)wrapperParent.getDisplayName())) {
            wrappedChild.displayName(wrapperParent.getDisplayName());
        }
        wrappedChild.locationSpecs((Iterable)wrapperParent.getLocationSpecs());
        wrappedChild.locations((Iterable)wrapperParent.getLocations());
        if (!wrapperParent.getParameters().isEmpty()) {
            wrappedChild.parametersAdd((Iterable)wrapperParent.getParameters());
        }
        wrappedChild.catalogItemIdAndSearchPath(wrapperParent.getCatalogItemId(), (Collection)wrapperParent.getCatalogItemIdSearchPath());
        Map configWithoutWrapperMarker = Maps.filterKeys((Map)wrapperParent.getConfig(), (Predicate)Predicates.not((Predicate)Predicates.equalTo(WRAPPER_APP_MARKER)));
        wrappedChild.configure(configWithoutWrapperMarker);
        wrappedChild.configure(wrapperParent.getFlags());
        wrappedChild.tagsReplace((Iterable)MutableList.copyOf((Iterable)wrapperParent.getTags()).appendAll((Iterable)wrappedChild.getTags()));
    }

    public static EntitySpec<? extends Application> newWrapperApp() {
        return (EntitySpec)EntitySpec.create(BasicApplication.class).configure(WRAPPER_APP_MARKER, (Object)true);
    }

    public static boolean canUnwrapApplication(EntitySpec<? extends Application> wrapperApplication) {
        if (!EntityManagementUtils.canUnwrapEntity(wrapperApplication)) {
            return false;
        }
        EntitySpec childSpec = (EntitySpec)Iterables.getOnlyElement((Iterable)wrapperApplication.getChildren());
        return childSpec.getType() != null && Application.class.isAssignableFrom(childSpec.getType());
    }

    @Deprecated
    public static boolean canPromoteWrappedApplication(EntitySpec<? extends Application> app) {
        return EntityManagementUtils.canUnwrapApplication(app);
    }

    public static boolean canUnwrapEntity(EntitySpec<? extends Entity> spec) {
        return EntityManagementUtils.isWrapperApp(spec) && EntityManagementUtils.hasSingleChild(spec) && spec.getEnrichers().isEmpty() && spec.getEnricherSpecs().isEmpty() && spec.getInitializers().isEmpty() && spec.getPolicies().isEmpty() && spec.getPolicySpecs().isEmpty() && (spec.getLocations().isEmpty() && spec.getLocationSpecs().isEmpty() || ((EntitySpec)Iterables.getOnlyElement((Iterable)spec.getChildren())).getLocations().isEmpty() && ((EntitySpec)Iterables.getOnlyElement((Iterable)spec.getChildren())).getLocationSpecs().isEmpty());
    }

    @Deprecated
    public static boolean canPromoteChildrenInWrappedApplication(EntitySpec<? extends Application> spec) {
        return EntityManagementUtils.canUnwrapEntity(spec);
    }

    public static boolean isWrapperApp(EntitySpec<?> spec) {
        return Boolean.TRUE.equals(spec.getConfig().get(WRAPPER_APP_MARKER));
    }

    private static boolean hasSingleChild(EntitySpec<?> spec) {
        return spec.getChildren().size() == 1;
    }

    public static class CreationResult<T, U> {
        private final T thing;
        @Nullable
        private final Task<U> task;

        public CreationResult(T thing, Task<U> task) {
            this.thing = thing;
            this.task = task;
        }

        protected static <T, U> CreationResult<T, U> of(T thing, @Nullable Task<U> task) {
            return new CreationResult<T, U>(thing, task);
        }

        @Nullable
        public T get() {
            return this.thing;
        }

        public Task<U> task() {
            return this.task;
        }

        public CreationResult<T, U> blockUntilComplete(Duration timeout) {
            if (this.task != null) {
                this.task.blockUntilEnded(timeout);
            }
            return this;
        }

        public CreationResult<T, U> blockUntilComplete() {
            if (this.task != null) {
                this.task.blockUntilEnded();
            }
            return this;
        }
    }
}

