/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.classloading;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URL;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.mgmt.classloading.AbstractBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBrooklynClassLoadingContext
extends AbstractBrooklynClassLoadingContext {
    private static final Logger LOG = LoggerFactory.getLogger(JavaBrooklynClassLoadingContext.class);
    private final transient ClassLoader loader;

    @Deprecated
    public static JavaBrooklynClassLoadingContext create(ClassLoader loader) {
        return new JavaBrooklynClassLoadingContext(null, (ClassLoader)Preconditions.checkNotNull((Object)loader, (Object)"loader"));
    }

    @Deprecated
    public static JavaBrooklynClassLoadingContext create(ManagementContext mgmt, ClassLoader loader) {
        Preconditions.checkState((mgmt != null || loader != null ? 1 : 0) != 0, (Object)"mgmt and loader must not both be null");
        return new JavaBrooklynClassLoadingContext(mgmt, loader);
    }

    public static JavaBrooklynClassLoadingContext create(ManagementContext mgmt) {
        return new JavaBrooklynClassLoadingContext((ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt"), null);
    }

    @Deprecated
    public static JavaBrooklynClassLoadingContext newDefault(ManagementContext mgmt) {
        return new JavaBrooklynClassLoadingContext((ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt"), null);
    }

    @Deprecated
    public JavaBrooklynClassLoadingContext(ManagementContext mgmt, ClassLoader loader) {
        super(mgmt);
        this.loader = loader;
    }

    private ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.mgmt != null) {
            return this.mgmt.getCatalogClassLoader();
        }
        return JavaBrooklynClassLoadingContext.class.getClassLoader();
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        String mappedClassName = DeserializingClassRenamesProvider.INSTANCE.findMappedName(className);
        Maybe<Class<?>> cls = this.tryLoadClass0(mappedClassName);
        if (cls.isPresent()) {
            return cls;
        }
        try {
            return Maybe.of(new ClassLoaderUtils(this.loader, this.mgmt).loadClass(mappedClassName));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return cls;
        }
    }

    private Maybe<Class<?>> tryLoadClass0(String className) {
        try {
            return Maybe.of(this.getClassLoader().loadClass(className));
        }
        catch (NoClassDefFoundError e) {
            String msg = "Invalid linkage in (transitive dependencies of) class " + className + ": " + e.toString();
            LOG.debug(msg);
            return Maybe.absent((String)msg, (Throwable)e);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return Maybe.absent((String)("Invalid class: " + className), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "java:" + this.getClassLoader();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getClassLoader()});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof JavaBrooklynClassLoadingContext)) {
            return false;
        }
        return Objects.equal((Object)this.getClassLoader(), (Object)((JavaBrooklynClassLoadingContext)obj).getClassLoader());
    }

    public URL getResource(String name) {
        return new ClassLoaderUtils(this.loader, this.mgmt).getResource(name);
    }

    public Iterable<URL> getResources(String name) {
        return new ClassLoaderUtils(this.loader, this.mgmt).getResources(name);
    }
}

