/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.osgi.BundleMaker;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsgiArchiveInstaller {
    private static final Logger log = LoggerFactory.getLogger(OsgiArchiveInstaller.class);
    private final OsgiManager osgiManager;
    private ManagedBundle suppliedKnownBundleMetadata;
    private InputStream zipIn;
    private boolean start = true;
    private boolean loadCatalogBom = true;
    private boolean force = false;
    private boolean deferredStart = false;
    private boolean validateTypes = true;
    private File zipFile;
    private Manifest discoveredManifest;
    private VersionedName discoveredBomVersionedName;
    OsgiBundleInstallationResult result;
    private ManagedBundle inferredMetadata;
    private final boolean inputStreamSupplied;

    OsgiArchiveInstaller(OsgiManager osgiManager, ManagedBundle knownBundleMetadata, InputStream zipIn) {
        this.osgiManager = osgiManager;
        this.suppliedKnownBundleMetadata = knownBundleMetadata;
        this.zipIn = zipIn;
        this.inputStreamSupplied = zipIn != null;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setLoadCatalogBom(boolean loadCatalogBom) {
        this.loadCatalogBom = loadCatalogBom;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDeferredStart(boolean deferredStart) {
        this.deferredStart = deferredStart;
    }

    public void setValidateTypes(boolean validateTypes) {
        this.validateTypes = validateTypes;
    }

    private ManagementContextInternal mgmt() {
        return (ManagementContextInternal)this.osgiManager.mgmt;
    }

    private synchronized void init() {
        if (this.result != null) {
            if (this.zipFile != null || this.zipIn == null) {
                return;
            }
            throw new IllegalStateException("This installer instance has already been used and the input stream discarded");
        }
        this.result = new OsgiBundleInstallationResult();
        this.inferredMetadata = this.suppliedKnownBundleMetadata == null ? new BasicManagedBundle() : this.suppliedKnownBundleMetadata;
    }

    private synchronized void makeLocalZipFileFromInputStreamOrUrl() {
        if (this.zipIn == null) {
            Maybe<Bundle> installedBundle = Maybe.absent();
            if (this.suppliedKnownBundleMetadata != null) {
                ManagedBundle mbFromUrl;
                if (!this.suppliedKnownBundleMetadata.isNameResolved() && (mbFromUrl = this.osgiManager.getManagedBundleFromUrl(this.suppliedKnownBundleMetadata.getUrl())) != null) {
                    ((BasicManagedBundle)this.suppliedKnownBundleMetadata).setSymbolicName(mbFromUrl.getSymbolicName());
                    ((BasicManagedBundle)this.suppliedKnownBundleMetadata).setVersion(mbFromUrl.getSuppliedVersionString());
                }
                if (installedBundle.isAbsent() && this.suppliedKnownBundleMetadata.getOsgiUniqueUrl() != null) {
                    installedBundle = Osgis.bundleFinder(this.osgiManager.framework).requiringFromUrl(this.suppliedKnownBundleMetadata.getOsgiUniqueUrl()).find();
                }
                if (installedBundle.isAbsent() && this.suppliedKnownBundleMetadata.getUrl() != null) {
                    installedBundle = Osgis.bundleFinder(this.osgiManager.framework).requiringFromUrl(this.suppliedKnownBundleMetadata.getUrl()).find();
                }
                if (installedBundle.isAbsent() && this.suppliedKnownBundleMetadata.isNameResolved()) {
                    installedBundle = Osgis.bundleFinder(this.osgiManager.framework).symbolicName(this.suppliedKnownBundleMetadata.getSymbolicName()).version(this.suppliedKnownBundleMetadata.getSuppliedVersionString()).find();
                }
                if (this.suppliedKnownBundleMetadata.getUrl() != null && (installedBundle.isAbsent() || this.force)) {
                    this.zipIn = ResourceUtils.create(this.mgmt()).getResourceFromUrl(this.suppliedKnownBundleMetadata.getUrl());
                }
            }
            if (this.zipIn == null) {
                if (installedBundle.isPresent()) {
                    this.result.metadata = this.osgiManager.getManagedBundle(new VersionedName((Bundle)installedBundle.get()));
                    if (this.result.metadata == null) {
                        this.result.metadata = new BasicManagedBundle(((Bundle)installedBundle.get()).getSymbolicName(), ((Bundle)installedBundle.get()).getVersion().toString(), this.suppliedKnownBundleMetadata != null ? this.suppliedKnownBundleMetadata.getUrl() : null);
                    }
                    this.result.setIgnoringAlreadyInstalled();
                    return;
                }
                this.result.metadata = this.suppliedKnownBundleMetadata;
                throw new IllegalArgumentException("No input stream available and no URL could be found; nothing to install");
            }
            this.result.bundle = (Bundle)installedBundle.orNull();
        }
        this.zipFile = Os.newTempFile((String)("brooklyn-bundle-transient-" + this.suppliedKnownBundleMetadata), (String)"zip");
        try (FileOutputStream fos = new FileOutputStream(this.zipFile);){
            Streams.copy((InputStream)this.zipIn, (OutputStream)fos);
            this.zipIn.close();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.zipIn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverManifestFromCatalogBom(boolean isCatalogBomRequired) {
        String bomS;
        ZipEntry bom;
        ZipFile zf;
        block8: {
            block9: {
                this.discoveredManifest = new BundleMaker(this.mgmt()).getManifest(this.zipFile);
                zf = null;
                try {
                    try {
                        zf = new ZipFile(this.zipFile);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid ZIP/JAR archive: " + e);
                    }
                    bom = zf.getEntry("catalog.bom");
                    if (bom == null) {
                        bom = zf.getEntry("/catalog.bom");
                    }
                    if (bom != null) break block8;
                    if (!isCatalogBomRequired) break block9;
                    throw new IllegalArgumentException("Archive must contain a catalog.bom file in the root");
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly(zf);
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)zf);
            return;
        }
        try {
            bomS = Streams.readFullyString((InputStream)zf.getInputStream(bom));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading catalog.bom from ZIP/JAR archive: " + e);
        }
        this.discoveredBomVersionedName = BasicBrooklynCatalog.getVersionedName(BasicBrooklynCatalog.getCatalogMetadata(bomS), false);
        Streams.closeQuietly((Closeable)zf);
    }

    private void updateManifestFromAllSourceInformation() {
        if (this.discoveredBomVersionedName != null) {
            this.matchSetOrFail("catalog.bom in archive", this.discoveredBomVersionedName.getSymbolicName(), this.discoveredBomVersionedName.getVersionString());
        }
        boolean manifestNeedsUpdating = false;
        if (this.discoveredManifest == null) {
            this.discoveredManifest = new Manifest();
            manifestNeedsUpdating = true;
        }
        if (!this.matchSetOrFail("MANIFEST.MF in archive", this.discoveredManifest.getMainAttributes().getValue("Bundle-SymbolicName"), this.discoveredManifest.getMainAttributes().getValue("Bundle-Version"))) {
            manifestNeedsUpdating = true;
            this.discoveredManifest.getMainAttributes().putValue("Bundle-SymbolicName", this.inferredMetadata.getSymbolicName());
            this.discoveredManifest.getMainAttributes().putValue("Bundle-Version", this.inferredMetadata.getOsgiVersionString());
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            throw new IllegalArgumentException("Missing bundle symbolic name in BOM or MANIFEST");
        }
        if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            throw new IllegalArgumentException("Missing bundle version in BOM or MANIFEST");
        }
        if (this.discoveredManifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            this.discoveredManifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            manifestNeedsUpdating = true;
        }
        if (manifestNeedsUpdating) {
            File zf2 = new BundleMaker(this.mgmt()).copyAddingManifest(this.zipFile, this.discoveredManifest);
            this.zipFile.delete();
            this.zipFile = zf2;
        }
    }

    private synchronized void close() {
        if (this.zipFile != null) {
            this.zipFile.delete();
            this.zipFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReferenceWithError<OsgiBundleInstallationResult> install() {
        boolean startedInstallation = false;
        try {
            File oldZipFile;
            boolean updating;
            block48: {
                block50: {
                    String knownIdForThisUrl;
                    this.init();
                    this.makeLocalZipFileFromInputStreamOrUrl();
                    if (this.result.code != null) {
                        ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                        return referenceWithError;
                    }
                    this.discoverManifestFromCatalogBom(false);
                    if (this.result.code != null) {
                        ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                        return referenceWithError;
                    }
                    this.updateManifestFromAllSourceInformation();
                    if (this.result.code != null) {
                        ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                        return referenceWithError;
                    }
                    assert (this.inferredMetadata.isNameResolved()) : "Should have resolved " + this.inferredMetadata;
                    assert (this.inferredMetadata instanceof BasicManagedBundle) : "Only BasicManagedBundles supported";
                    ((BasicManagedBundle)this.inferredMetadata).setChecksum(OsgiArchiveInstaller.getChecksum(new ZipFile(this.zipFile)));
                    this.result.metadata = this.osgiManager.getManagedBundle(this.inferredMetadata.getVersionedName());
                    if (this.result.getMetadata() == null) break block50;
                    if (this.suppliedKnownBundleMetadata != null && this.suppliedKnownBundleMetadata.getUrl() != null) {
                        knownIdForThisUrl = this.osgiManager.managedBundlesRecord.getManagedBundleIdFromUrl(this.suppliedKnownBundleMetadata.getUrl());
                        if (knownIdForThisUrl == null) {
                            log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is not recognized but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                            this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                        } else if (!knownIdForThisUrl.equals(this.result.getMetadata().getId())) {
                            log.warn("Request to install from " + this.suppliedKnownBundleMetadata.getUrl() + " which is associated to " + knownIdForThisUrl + " but appears to match " + this.result.getMetadata() + "; now associating with the latter");
                            this.osgiManager.managedBundlesRecord.setManagedBundleUrl(this.suppliedKnownBundleMetadata.getUrl(), this.result.getMetadata().getId());
                        }
                    }
                    if (this.canUpdate()) {
                        this.result.bundle = this.osgiManager.framework.getBundleContext().getBundle(this.result.getMetadata().getOsgiUniqueUrl());
                        if (this.result.getBundle() == null) {
                            log.warn("Brooklyn thought is was already managing bundle " + this.result.getMetadata().getVersionedName() + " but it's not installed to framework; reinstalling it");
                            updating = false;
                            break block48;
                        } else {
                            updating = true;
                        }
                        break block48;
                    } else {
                        if (this.result.getMetadata().getChecksum() == null || this.inferredMetadata.getChecksum() == null) {
                            log.warn("Missing bundle checksum data for " + this.result + "; assuming bundle replacement is permitted");
                        } else if (!Objects.equal((Object)this.result.getMetadata().getChecksum(), (Object)this.inferredMetadata.getChecksum())) {
                            throw new IllegalArgumentException("Bundle " + this.result.getMetadata().getVersionedName() + " already installed; cannot install a different bundle at a same non-snapshot version");
                        }
                        this.result.setIgnoringAlreadyInstalled();
                        knownIdForThisUrl = ReferenceWithError.newInstanceWithoutError((Object)this.result);
                        return knownIdForThisUrl;
                    }
                }
                this.result.metadata = this.inferredMetadata;
                Maybe<Bundle> b = Osgis.bundleFinder(this.osgiManager.framework).symbolicName(this.result.getMetadata().getSymbolicName()).version(this.result.getMetadata().getSuppliedVersionString()).find();
                if (b.isPresent()) {
                    log.debug("Brooklyn install of " + this.result.getMetadata().getVersionedName() + " detected already loaded in OSGi; uninstalling that to reinstall as Brooklyn-managed");
                    ((Bundle)b.get()).uninstall();
                }
                updating = false;
            }
            startedInstallation = true;
            try (FileInputStream fin = new FileInputStream(this.zipFile);){
                if (!updating) {
                    assert (this.result.getBundle() == null);
                    this.result.bundle = this.osgiManager.framework.getBundleContext().installBundle(this.result.getMetadata().getOsgiUniqueUrl(), (InputStream)fin);
                } else {
                    this.result.bundle.update((InputStream)fin);
                }
            }
            this.osgiManager.checkCorrectlyInstalled((OsgiBundleWithUrl)this.result.getMetadata(), this.result.bundle);
            if (!updating) {
                oldZipFile = null;
                this.osgiManager.managedBundlesRecord.addManagedBundle(this.result, this.zipFile);
                this.result.code = OsgiBundleInstallationResult.ResultCode.INSTALLED_NEW_BUNDLE;
                this.result.message = "Installed Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " with ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
                ((BasicManagedBundle)this.result.getMetadata()).setPersistenceNeeded(true);
                this.mgmt().getRebindManager().getChangeListener().onManaged((BrooklynObject)this.result.getMetadata());
            } else {
                oldZipFile = this.osgiManager.managedBundlesRecord.updateManagedBundleFile(this.result, this.zipFile);
                this.result.code = OsgiBundleInstallationResult.ResultCode.UPDATED_EXISTING_BUNDLE;
                this.result.message = "Updated Brooklyn catalog bundle " + this.result.getMetadata().getVersionedName() + " as existing ID " + this.result.getMetadata().getId() + " [" + this.result.bundle.getBundleId() + "]";
                ((BasicManagedBundle)this.result.getMetadata()).setPersistenceNeeded(true);
                this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)this.result.getMetadata());
            }
            log.debug(this.result.message + " (in osgi container)");
            this.zipFile.delete();
            this.zipFile = null;
            Runnable startRunnable = new Runnable(){

                private void rollbackBundle() {
                    if (updating) {
                        if (oldZipFile == null) {
                            throw new IllegalStateException("Did not have old ZIP file to install");
                        }
                        log.debug("Rolling back bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + " to state from " + oldZipFile);
                        try {
                            File zipFileNow = ((OsgiArchiveInstaller)OsgiArchiveInstaller.this).osgiManager.managedBundlesRecord.rollbackManagedBundleFile(OsgiArchiveInstaller.this.result, oldZipFile);
                            OsgiArchiveInstaller.this.result.bundle.update((InputStream)new FileInputStream((File)Preconditions.checkNotNull((Object)zipFileNow, (Object)"Couldn't find contents of old version of bundle")));
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            log.error("Error rolling back following failed install of updated " + OsgiArchiveInstaller.this.result.getVersionedName() + "; installation will likely be corrupted and correct version should be manually installed.", (Throwable)e);
                        }
                        ((BasicManagedBundle)OsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                        OsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onChanged((BrooklynObject)OsgiArchiveInstaller.this.result.getMetadata());
                    } else {
                        log.debug("Uninstalling bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + " (roll back of failed fresh install, no previous version to revert to)");
                        OsgiArchiveInstaller.this.osgiManager.uninstallUploadedBundle(OsgiArchiveInstaller.this.result.getMetadata());
                        ((BasicManagedBundle)OsgiArchiveInstaller.this.result.getMetadata()).setPersistenceNeeded(true);
                        OsgiArchiveInstaller.this.mgmt().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)OsgiArchiveInstaller.this.result.getMetadata());
                    }
                }

                @Override
                public void run() {
                    if (OsgiArchiveInstaller.this.start) {
                        try {
                            log.debug("Starting bundle " + OsgiArchiveInstaller.this.result.getVersionedName());
                            OsgiArchiveInstaller.this.result.bundle.start();
                        }
                        catch (BundleException e) {
                            log.warn("Error starting bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle, then re-throwing error: " + (Object)((Object)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + OsgiArchiveInstaller.this.result.getVersionedName() + " after bundle start problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure installing and rolling back; server may be in inconsistent state regarding bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                    if (OsgiArchiveInstaller.this.loadCatalogBom) {
                        Iterable<RegisteredType> itemsFromOldBundle = null;
                        MutableMap itemsReplacedHere = null;
                        try {
                            if (updating) {
                                itemsFromOldBundle = OsgiArchiveInstaller.this.osgiManager.uninstallCatalogItemsFromBundle(OsgiArchiveInstaller.this.result.getVersionedName());
                            }
                            itemsReplacedHere = MutableMap.of();
                            OsgiArchiveInstaller.this.osgiManager.loadCatalogBom(OsgiArchiveInstaller.this.result.bundle, OsgiArchiveInstaller.this.force, OsgiArchiveInstaller.this.validateTypes, (Map<RegisteredType, RegisteredType>)itemsReplacedHere);
                            Iterable items = OsgiArchiveInstaller.this.mgmt().getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle((OsgiBundleWithUrl)OsgiArchiveInstaller.this.result.getMetadata()));
                            log.debug("Adding items from bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ": " + items);
                            for (RegisteredType ci : items) {
                                OsgiArchiveInstaller.this.result.catalogItemsInstalled.add(ci.getId());
                            }
                        }
                        catch (Exception e) {
                            log.warn("Error adding Brooklyn items from bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ", uninstalling, restoring any old bundle and items, then re-throwing error: " + Exceptions.collapseText((Throwable)e));
                            try {
                                this.rollbackBundle();
                            }
                            catch (Throwable t) {
                                Exceptions.propagateIfFatal((Throwable)t);
                                log.warn("Error rolling back " + OsgiArchiveInstaller.this.result.getVersionedName() + " after catalog install problem; server may be in inconsistent state (swallowing this error and propagating installation error): " + Exceptions.collapseText((Throwable)t), t);
                                throw Exceptions.propagate((Throwable)new BundleException("Failure loading catalog items, and also failed rolling back; server may be in inconsistent state regarding bundle " + OsgiArchiveInstaller.this.result.getVersionedName() + ". Rollback failure (" + Exceptions.collapseText((Throwable)t) + ") detailed in log. Installation error is: " + Exceptions.collapseText((Throwable)e), (Throwable)e));
                            }
                            if (itemsFromOldBundle != null) {
                                for (RegisteredType oldItem : itemsFromOldBundle) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced bundle item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)OsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            if (itemsReplacedHere != null) {
                                MutableList replaced = MutableList.copyOf(itemsReplacedHere.values());
                                Collections.reverse(replaced);
                                for (RegisteredType oldItem : replaced) {
                                    if (oldItem == null) continue;
                                    if (log.isTraceEnabled()) {
                                        log.trace("RESTORING replaced external item " + oldItem + "\n" + RegisteredTypes.getImplementationDataStringForSpec(oldItem));
                                    }
                                    ((BasicBrooklynTypeRegistry)OsgiArchiveInstaller.this.mgmt().getTypeRegistry()).addToLocalUnpersistedTypeRegistry(oldItem, true);
                                }
                            }
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                }
            };
            if (this.deferredStart) {
                this.result.deferredStart = startRunnable;
                log.debug(this.result.message + " (Brooklyn load deferred)");
            } else {
                startRunnable.run();
                if (!this.result.catalogItemsInstalled.isEmpty()) {
                    int MAX_TO_LIST_EXPLICITLY = 5;
                    MutableList firstN = MutableList.copyOf((Iterable)Iterables.limit(this.result.catalogItemsInstalled, (int)5));
                    log.info(this.result.message + ", items: " + firstN + (this.result.catalogItemsInstalled.size() > 5 ? " (and others, " + this.result.catalogItemsInstalled.size() + " total)" : ""));
                    if (log.isDebugEnabled() && this.result.catalogItemsInstalled.size() > 5) {
                        log.debug(this.result.message + ", all items: " + this.result.catalogItemsInstalled);
                    }
                } else {
                    log.debug(this.result.message + " (into Brooklyn), with no catalog items");
                }
            }
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceWithoutError((Object)this.result);
            return referenceWithError;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            this.result.code = startedInstallation ? OsgiBundleInstallationResult.ResultCode.ERROR_LAUNCHING_BUNDLE : OsgiBundleInstallationResult.ResultCode.ERROR_PREPARING_BUNDLE;
            this.result.message = "Bundle " + this.inferredMetadata + " failed " + (startedInstallation ? "installation" : "preparation") + ": " + Exceptions.collapseText((Throwable)e);
            ReferenceWithError referenceWithError = ReferenceWithError.newInstanceThrowingError((Object)this.result, (Throwable)new IllegalStateException(this.result.message, e));
            return referenceWithError;
        }
        finally {
            this.close();
        }
    }

    private static String getChecksum(ZipFile zf) {
        try {
            MutableMap entriesToChecksum = MutableMap.of();
            for (ZipEntry zipEntry : Collections.list(zf.entries())) {
                entriesToChecksum.put(zipEntry.getName(), Streams.getMd5Checksum((InputStream)zf.getInputStream(zipEntry)));
            }
            return Streams.getMd5Checksum((InputStream)Streams.newInputStreamWithContents((String)new TreeMap(entriesToChecksum).toString()));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private boolean canUpdate() {
        return this.force || VersionComparator.isSnapshot((String)this.inferredMetadata.getSuppliedVersionString()) && this.inputStreamSupplied;
    }

    private boolean matchSetOrFail(String source, String name, String version) {
        boolean suppliedIsComplete = true;
        if (Strings.isBlank((CharSequence)name)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSymbolicName())) {
            ((BasicManagedBundle)this.inferredMetadata).setSymbolicName(name);
        } else if (!Objects.equal((Object)this.inferredMetadata.getSymbolicName(), (Object)name)) {
            throw new IllegalArgumentException("Symbolic name mismatch '" + name + "' from " + source + " (expected '" + this.inferredMetadata.getSymbolicName() + "')");
        }
        if (Strings.isBlank((CharSequence)version)) {
            suppliedIsComplete = false;
        } else if (Strings.isBlank((CharSequence)this.inferredMetadata.getSuppliedVersionString())) {
            ((BasicManagedBundle)this.inferredMetadata).setVersion(version);
        } else if (!BrooklynVersionSyntax.equalAsOsgiVersions((String)this.inferredMetadata.getSuppliedVersionString(), (String)version)) {
            throw new IllegalArgumentException("Bundle version mismatch '" + version + "' from " + source + " (expected '" + this.inferredMetadata.getSuppliedVersionString() + "')");
        }
        return suppliedIsComplete;
    }
}

