/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.CampYamlParser;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredBrooklynProperties
implements BrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredBrooklynProperties.class);
    private static final String BROOKLYN_YAML_PREFIX = "$brooklyn:";
    private final BrooklynProperties delegate;
    private final ManagementContextInternal mgmt;

    public DeferredBrooklynProperties(BrooklynProperties delegate, ManagementContextInternal mgmt) {
        this.delegate = (BrooklynProperties)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.mgmt = (ManagementContextInternal)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
    }

    private Object transform(ConfigKey<?> key, Object value) {
        String raw;
        if (value instanceof CharSequence && (raw = value.toString()).startsWith(BROOKLYN_YAML_PREFIX)) {
            CampYamlParser parser = (CampYamlParser)this.mgmt.getScratchpad().get(CampYamlParser.YAML_PARSER_KEY);
            if (parser == null) {
                LOG.debug("Not transforming external-config {}, as no camp-yaml parser available", key);
                return value;
            }
            return parser.parse(raw);
        }
        return value;
    }

    private <T> T resolve(ConfigKey<T> key, Object value) {
        Object result;
        Object transformed = this.transform(key, value);
        if (transformed instanceof DeferredSupplier) {
            ExecutionContext exec = this.mgmt.getServerExecutionContext();
            try {
                result = Tasks.resolveValue(transformed, key.getType(), exec);
            }
            catch (InterruptedException | ExecutionException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            result = transformed;
        }
        return TypeCoercions.coerce(result, key.getTypeToken());
    }

    @Override
    public boolean containsKey(String key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsKey(ConfigKey<?> key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean remove(String key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean remove(ConfigKey<?> key) {
        return this.delegate.remove(key);
    }

    @Override
    public Object getConfig(String key) {
        Object raw = this.delegate.getConfig(key);
        return this.resolve(ConfigKeys.newConfigKey(Object.class, key), raw);
    }

    @Override
    public <T> T getConfig(ConfigKey<T> key) {
        T raw = this.delegate.getConfig(key);
        return this.resolve(key, raw);
    }

    @Override
    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        T raw = this.delegate.getConfig(key);
        return this.resolve(key.getConfigKey(), raw);
    }

    @Override
    public <T> T getConfig(ConfigKey.HasConfigKey<T> key, T defaultValue) {
        T raw = this.delegate.getConfig(key, defaultValue);
        return this.resolve(key.getConfigKey(), raw);
    }

    @Override
    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        T raw = this.delegate.getConfig(key, defaultValue);
        return this.resolve(key, raw);
    }

    @Override
    public Maybe<Object> getConfigRaw(ConfigKey<?> key) {
        return this.getConfigRaw(key, true);
    }

    @Override
    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        Maybe<Object> result = this.delegate.getConfigRaw(key, includeInherited);
        return result.isPresent() ? Maybe.of((Object)this.transform(key, result.get())) : Maybe.absent();
    }

    public Maybe<Object> getConfigLocalRaw(ConfigKey<?> key) {
        return this.getConfigRaw(key, false);
    }

    public Map<ConfigKey<?>, Object> getAllConfigLocalRaw() {
        Map raw = this.delegate.getAllConfigLocalRaw();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : raw.entrySet()) {
            result.put(entry.getKey(), this.transform((ConfigKey)entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @Override
    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig() {
        return this.getAllConfigLocalRaw();
    }

    @Override
    public Map<String, Object> asMapWithStringKeys() {
        Map raw = this.delegate.getAllConfigLocalRaw();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry entry : raw.entrySet()) {
            result.put(((ConfigKey)entry.getKey()).getName(), this.transform((ConfigKey)entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @Override
    @Deprecated
    public String get(Map flags, String key) {
        return this.delegate.get(flags, key);
    }

    @Override
    public String getFirst(String ... keys) {
        return this.delegate.getFirst(keys);
    }

    @Override
    public String getFirst(Map flags, String ... keys) {
        return this.delegate.getFirst(flags, keys);
    }

    @Override
    public BrooklynProperties submap(Predicate<ConfigKey<?>> filter) {
        StringConfigMap submap = this.delegate.submap((Predicate)filter);
        return new DeferredBrooklynProperties((BrooklynProperties)submap, this.mgmt);
    }

    @Override
    public BrooklynProperties submapByName(Predicate<? super String> filter) {
        BrooklynProperties submap = this.delegate.submapByName(filter);
        return new DeferredBrooklynProperties(submap, this.mgmt);
    }

    @Deprecated
    public Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter) {
        return this.delegate.findKeys(filter);
    }

    public Set<ConfigKey<?>> findKeysDeclared(Predicate<? super ConfigKey<?>> filter) {
        return this.delegate.findKeysDeclared(filter);
    }

    public Set<ConfigKey<?>> findKeysPresent(Predicate<? super ConfigKey<?>> filter) {
        return this.delegate.findKeysPresent(filter);
    }

    @Override
    public BrooklynProperties addEnvironmentVars() {
        this.delegate.addEnvironmentVars();
        return this;
    }

    @Override
    public BrooklynProperties addSystemProperties() {
        this.delegate.addSystemProperties();
        return this;
    }

    @Override
    public BrooklynProperties addFrom(ConfigBag cfg) {
        this.delegate.addFrom(cfg);
        return this;
    }

    @Override
    public BrooklynProperties addFrom(Map map) {
        this.delegate.addFrom(map);
        return this;
    }

    @Override
    public BrooklynProperties addFrom(InputStream i) {
        this.delegate.addFrom(i);
        return this;
    }

    @Override
    public BrooklynProperties addFrom(File f) {
        this.delegate.addFrom(f);
        return this;
    }

    @Override
    public BrooklynProperties addFrom(URL u) {
        this.delegate.addFrom(u);
        return this;
    }

    @Override
    public BrooklynProperties addFromUrl(String url) {
        this.delegate.addFromUrl(url);
        return this;
    }

    @Override
    public BrooklynProperties addFromUrlProperty(String urlProperty) {
        this.delegate.addFromUrlProperty(urlProperty);
        return this;
    }

    @Override
    public BrooklynProperties addFromMap(Map properties) {
        this.delegate.addFromMap(properties);
        return this;
    }

    @Override
    public boolean putIfAbsent(String key, Object value) {
        return this.delegate.putIfAbsent(key, value);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Object put(Object key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map vals) {
        this.delegate.putAll(vals);
    }

    @Override
    public <T> Object put(ConfigKey.HasConfigKey<T> key, T value) {
        return this.delegate.put(key, value);
    }

    @Override
    public <T> Object put(ConfigKey<T> key, T value) {
        return this.delegate.put(key, value);
    }

    @Override
    public <T> boolean putIfAbsent(ConfigKey<T> key, T value) {
        return this.delegate.putIfAbsent(key, value);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

