/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.annotations.Beta;
import com.google.common.io.ByteSource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.util.time.Duration;

public interface PersistenceObjectStore {
    public String getSummaryName();

    @Beta
    public void injectManagementContext(ManagementContext var1);

    @Beta
    public void prepareForSharedUse(PersistMode var1, HighAvailabilityMode var2);

    @Beta
    public void prepareForMasterUse();

    @Beta
    public StoreObjectAccessor newAccessor(String var1);

    public void createSubPath(String var1);

    public List<String> listContentsWithSubPath(String var1);

    public void deleteCompletely();

    public void close();

    public static interface StoreObjectAccessorWithLock
    extends StoreObjectAccessor {
        public void waitForCurrentWrites(Duration var1) throws InterruptedException, TimeoutException;

        public ReadWriteLock getLockObject();
    }

    public static interface StoreObjectAccessor {
        public String get();

        public byte[] getBytes();

        public boolean exists();

        public void put(String var1);

        public void put(ByteSource var1);

        public void append(String var1);

        public void delete();

        public Date getLastModifiedDate();
    }
}

