/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.PathTrackingReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.CatalogBundleDto;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.effector.BasicParameterType;
import org.apache.brooklyn.core.effector.EffectorAndBody;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.mgmt.classloading.ClassLoaderFromStackOfBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.persist.CatalogItemLibrariesConverter;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.core.mgmt.persist.MementoSerializer;
import org.apache.brooklyn.core.mgmt.persist.UnwantedStateLoggingMapper;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicCatalogItemMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicEnricherMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicEntityMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicFeedMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicLocationMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicManagedBundleMemento;
import org.apache.brooklyn.core.mgmt.rebind.dto.BasicPolicyMemento;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.util.core.xstream.XmlSerializer;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMementoSerializer<T>
extends XmlSerializer<T>
implements MementoSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlMementoSerializer.class);
    private final ClassLoaderFromStackOfBrooklynClassLoadingContext delegatingClassLoader;
    private BrooklynMementoPersister.LookupContext lookupContext;
    static boolean loggedTaskWarning = false;

    public XmlMementoSerializer(ClassLoader classLoader) {
        this(classLoader, DeserializingClassRenamesProvider.INSTANCE.loadDeserializingMapping());
    }

    public XmlMementoSerializer(ClassLoader classLoader, Map<String, String> deserializingClassRenames) {
        super(new ClassLoaderFromStackOfBrooklynClassLoadingContext(classLoader), deserializingClassRenames);
        this.delegatingClassLoader = (ClassLoaderFromStackOfBrooklynClassLoadingContext)this.xstream.getClassLoader();
        this.xstream.alias("entity", BasicEntityMemento.class);
        this.xstream.alias("location", BasicLocationMemento.class);
        this.xstream.alias("policy", BasicPolicyMemento.class);
        this.xstream.alias("feed", BasicFeedMemento.class);
        this.xstream.alias("enricher", BasicEnricherMemento.class);
        this.xstream.alias("configKey", BasicConfigKey.class);
        this.xstream.alias("catalogItem", BasicCatalogItemMemento.class);
        this.xstream.alias("managedBundle", BasicManagedBundleMemento.class);
        this.xstream.alias("bundle", CatalogBundleDto.class);
        this.xstream.alias("attributeSensor", BasicAttributeSensor.class);
        this.xstream.alias("effector", Effector.class);
        this.xstream.addDefaultImplementation(EffectorAndBody.class, Effector.class);
        this.xstream.alias("parameter", BasicParameterType.class);
        this.xstream.addDefaultImplementation(EffectorTasks.EffectorBodyTaskFactory.class, EffectorTasks.EffectorTaskFactory.class);
        this.xstream.alias("entityRef", Entity.class);
        this.xstream.alias("locationRef", Location.class);
        this.xstream.alias("policyRef", Policy.class);
        this.xstream.alias("enricherRef", Enricher.class);
        this.xstream.registerConverter((SingleValueConverter)new LocationConverter());
        this.xstream.registerConverter((SingleValueConverter)new PolicyConverter());
        this.xstream.registerConverter((SingleValueConverter)new EnricherConverter());
        this.xstream.registerConverter((SingleValueConverter)new EntityConverter());
        this.xstream.registerConverter((SingleValueConverter)new FeedConverter());
        this.xstream.registerConverter((SingleValueConverter)new CatalogItemConverter());
        this.xstream.registerConverter((Converter)new SpecConverter());
        this.xstream.registerConverter((Converter)new ManagementContextConverter());
        this.xstream.registerConverter((Converter)new TaskConverter(this.xstream.getMapper()));
        this.xstream.aliasField("registeredTypeName", BasicCatalogItemMemento.class, "symbolicName");
        this.configureXstreamWithDeprecatedItems();
    }

    private void configureXstreamWithDeprecatedItems() {
        this.xstream.registerLocalConverter(BasicCatalogItemMemento.class, "libraries", (Converter)new CatalogItemLibrariesConverter());
    }

    @Override
    protected MapperWrapper wrapMapperForNormalUsage(Mapper next) {
        MapperWrapper mapper = super.wrapMapperForNormalUsage(next);
        mapper = new CustomMapper((Mapper)mapper, Entity.class, "entityProxy");
        mapper = new CustomMapper((Mapper)mapper, Location.class, "locationProxy");
        mapper = new UnwantedStateLoggingMapper((Mapper)mapper);
        return mapper;
    }

    @Override
    public void serialize(Object object, Writer writer) {
        super.serialize(object, writer);
        try {
            writer.append("\n");
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void setLookupContext(BrooklynMementoPersister.LookupContext lookupContext) {
        this.lookupContext = (BrooklynMementoPersister.LookupContext)Preconditions.checkNotNull((Object)lookupContext, (Object)"lookupContext");
        this.delegatingClassLoader.setManagementContext(lookupContext.lookupManagementContext());
    }

    @Override
    public void unsetLookupContext() {
        this.lookupContext = null;
    }

    private static Class<?> readClassType(HierarchicalStreamReader reader, Mapper mapper) {
        String classAttribute = XmlMementoSerializer.readClassAttribute(reader, mapper);
        Class type = classAttribute == null ? mapper.realClass(reader.getNodeName()) : mapper.realClass(classAttribute);
        return type;
    }

    private static String readClassAttribute(HierarchicalStreamReader reader, Mapper mapper) {
        String classAttribute;
        String attributeName = mapper.aliasForSystemAttribute("resolves-to");
        String string = classAttribute = attributeName == null ? null : reader.getAttribute(attributeName);
        if (classAttribute == null && (attributeName = mapper.aliasForSystemAttribute("class")) != null) {
            classAttribute = reader.getAttribute(attributeName);
        }
        return classAttribute;
    }

    public class SpecConverter
    extends ReflectionConverter {
        SpecConverter() {
            super(XmlMementoSerializer.this.xstream.getMapper(), XmlMementoSerializer.this.xstream.getReflectionProvider());
        }

        public boolean canConvert(Class type) {
            return AbstractBrooklynObjectSpec.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source == null) {
                return;
            }
            AbstractBrooklynObjectSpec spec = (AbstractBrooklynObjectSpec)source;
            String catalogItemId = spec.getCatalogItemId();
            if (Strings.isNonBlank((CharSequence)catalogItemId)) {
                writer.startNode("catalogItemId");
                writer.setValue(catalogItemId);
                writer.endNode();
                super.marshal(source, writer, context);
            } else {
                super.marshal(source, writer, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String catalogItemId = null;
            this.instantiateNewInstanceSettingCache(reader, context);
            if (reader instanceof PathTrackingReader && "catalogItemId".equals(((PathTrackingReader)reader).peekNextChild())) {
                reader.moveDown();
                catalogItemId = reader.getValue();
                reader.moveUp();
            }
            boolean customLoaderSet = false;
            try {
                if (Strings.isNonBlank(catalogItemId)) {
                    if (XmlMementoSerializer.this.lookupContext == null) {
                        throw new NullPointerException("lookupContext required to load catalog item " + catalogItemId);
                    }
                    RegisteredType cat = XmlMementoSerializer.this.lookupContext.lookupManagementContext().getTypeRegistry().get(catalogItemId);
                    if (cat == null) {
                        throw new NoSuchElementException("catalog item: " + catalogItemId);
                    }
                    BrooklynClassLoadingContext clcNew = CatalogUtils.newClassLoadingContext(XmlMementoSerializer.this.lookupContext.lookupManagementContext(), cat);
                    XmlMementoSerializer.this.delegatingClassLoader.pushClassLoadingContext(clcNew);
                    customLoaderSet = true;
                }
                AbstractBrooklynObjectSpec result = (AbstractBrooklynObjectSpec)super.unmarshal(reader, context);
                result.catalogItemId(catalogItemId);
                AbstractBrooklynObjectSpec abstractBrooklynObjectSpec = result;
                return abstractBrooklynObjectSpec;
            }
            finally {
                context.put((Object)"SpecConverter.instance", null);
                if (customLoaderSet) {
                    XmlMementoSerializer.this.delegatingClassLoader.popClassLoadingContext();
                }
            }
        }

        protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object instance = context.get((Object)"SpecConverter.instance");
            if (instance == null) {
                throw new IllegalStateException("Instance should be created and cached");
            }
            return instance;
        }

        protected void instantiateNewInstanceSettingCache(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object instance = super.instantiateNewInstance(reader, context);
            context.put((Object)"SpecConverter.instance", instance);
        }
    }

    public class ManagementContextConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return ManagementContext.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return XmlMementoSerializer.this.lookupContext.lookupManagementContext();
        }
    }

    public class TaskConverter
    implements Converter {
        private final Mapper mapper;

        TaskConverter(Mapper mapper) {
            this.mapper = mapper;
        }

        public boolean canConvert(Class type) {
            return Task.class.isAssignableFrom(type);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source == null) {
                return;
            }
            if (((Task)source).isDone() && !((Task)source).isError()) {
                try {
                    Object nextItem = ((Task)source).get();
                    if (nextItem == null) return;
                    context.convertAnother(nextItem);
                    return;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unexpected exception getting done (and non-error) task result for " + source + "; continuing: " + e, (Throwable)e);
                    return;
                }
            } else {
                if (loggedTaskWarning) return;
                LOG.warn("Intercepting and skipping request to serialize a Task" + (context instanceof ReferencingMarshallingContext ? " at " + ((ReferencingMarshallingContext)context).currentPath() : "") + " (only logging this once): " + source);
                loggedTaskWarning = true;
                return;
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (reader.hasMoreChildren()) {
                Class type = XmlMementoSerializer.readClassType(reader, this.mapper);
                reader.moveDown();
                Object result = context.convertAnother(null, type);
                reader.moveUp();
                return result;
            }
            return null;
        }
    }

    public class CatalogItemConverter
    extends IdentifiableConverter<CatalogItem> {
        CatalogItemConverter() {
            super(CatalogItem.class);
        }

        @Override
        protected CatalogItem<?, ?> lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupCatalogItem(id);
        }
    }

    public class EntityConverter
    extends IdentifiableConverter<Entity> {
        EntityConverter() {
            super(Entity.class);
        }

        @Override
        protected Entity lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupEntity(id);
        }
    }

    public class FeedConverter
    extends IdentifiableConverter<Feed> {
        FeedConverter() {
            super(Feed.class);
        }

        @Override
        protected Feed lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupFeed(id);
        }
    }

    public class EnricherConverter
    extends IdentifiableConverter<Enricher> {
        EnricherConverter() {
            super(Enricher.class);
        }

        @Override
        protected Enricher lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupEnricher(id);
        }
    }

    public class PolicyConverter
    extends IdentifiableConverter<Policy> {
        PolicyConverter() {
            super(Policy.class);
        }

        @Override
        protected Policy lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupPolicy(id);
        }
    }

    public class LocationConverter
    extends IdentifiableConverter<Location> {
        LocationConverter() {
            super(Location.class);
        }

        @Override
        protected Location lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupLocation(id);
        }
    }

    public abstract class IdentifiableConverter<IT extends Identifiable>
    implements SingleValueConverter {
        private final Class<IT> clazz;

        IdentifiableConverter(Class<IT> clazz) {
            this.clazz = clazz;
        }

        public boolean canConvert(Class type) {
            boolean result = this.clazz.isAssignableFrom(type);
            return result;
        }

        public String toString(Object obj) {
            return obj == null ? null : ((Identifiable)obj).getId();
        }

        public Object fromString(String str) {
            if (XmlMementoSerializer.this.lookupContext == null) {
                LOG.warn("Cannot unmarshal from persisted xml {} {}; no lookup context supplied!", (Object)this.clazz.getSimpleName(), (Object)str);
                return null;
            }
            return this.lookup(str);
        }

        protected abstract IT lookup(String var1);
    }

    public static class CustomMapper
    extends MapperWrapper {
        private final Class<?> clazz;
        private final String alias;

        public CustomMapper(Mapper wrapped, Class<?> clazz, String alias) {
            super(wrapped);
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"alias");
        }

        public String getAlias() {
            return this.alias;
        }

        public String serializedClass(Class type) {
            if (type != null && this.clazz.isAssignableFrom(type)) {
                return this.alias;
            }
            return super.serializedClass(type);
        }

        public Class<?> realClass(String elementName) {
            if (elementName.equals(this.alias)) {
                return this.clazz;
            }
            return super.realClass(elementName);
        }
    }
}

