/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoManifest;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EnricherMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.FeedMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.LocationMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.ManagedBundleMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.PolicyMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.BrooklynObjectManagementMode;
import org.apache.brooklyn.core.mgmt.internal.BrooklynObjectManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.LocationManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.core.mgmt.persist.PersistenceActivityMetrics;
import org.apache.brooklyn.core.mgmt.rebind.PersisterDeltaImpl;
import org.apache.brooklyn.core.mgmt.rebind.RebindContextImpl;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.proxy.InternalEntityFactory;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.core.objs.proxy.InternalLocationFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.typereg.BasicManagedBundle;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RebindIteration {
    private static final Logger LOG = LoggerFactory.getLogger(RebindIteration.class);
    protected final RebindManagerImpl rebindManager;
    protected final ClassLoader classLoader;
    protected final RebindExceptionHandler exceptionHandler;
    protected final ManagementNodeState mode;
    protected final ManagementContextInternal managementContext;
    protected final Semaphore rebindActive;
    protected final AtomicInteger readOnlyRebindCount;
    protected final PersistenceActivityMetrics rebindMetrics;
    protected final BrooklynMementoPersister persistenceStoreAccess;
    protected final AtomicBoolean iterationStarted = new AtomicBoolean();
    protected final RebindContextImpl rebindContext;
    protected final Reflections reflections;
    protected final BrooklynObjectInstantiator instantiator;
    protected Stopwatch timer;
    protected int phase = 0;
    protected BrooklynMementoRawData mementoRawData;
    protected BrooklynMementoManifest mementoManifest;
    protected Boolean overwritingMaster;
    protected Boolean isEmpty;
    protected BrooklynMemento memento;
    protected List<Application> applications;

    public RebindIteration(RebindManagerImpl rebindManager, ManagementNodeState mode, ClassLoader classLoader, RebindExceptionHandler exceptionHandler, Semaphore rebindActive, AtomicInteger readOnlyRebindCount, PersistenceActivityMetrics rebindMetrics, BrooklynMementoPersister persistenceStoreAccess) {
        this.rebindManager = rebindManager;
        this.mode = mode;
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.exceptionHandler = (RebindExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        this.rebindActive = rebindActive;
        this.readOnlyRebindCount = readOnlyRebindCount;
        this.rebindMetrics = rebindMetrics;
        this.persistenceStoreAccess = persistenceStoreAccess;
        this.managementContext = rebindManager.getManagementContext();
        this.rebindContext = new RebindContextImpl(this.managementContext, exceptionHandler, classLoader);
        this.reflections = new Reflections(classLoader).applyClassRenames(DeserializingClassRenamesProvider.INSTANCE.loadDeserializingMapping());
        this.instantiator = new BrooklynObjectInstantiator(classLoader, this.rebindContext, this.reflections);
        if (mode == ManagementNodeState.HOT_STANDBY || mode == ManagementNodeState.HOT_BACKUP) {
            this.rebindContext.setAllReadOnly();
        } else {
            Preconditions.checkState((mode == ManagementNodeState.MASTER ? 1 : 0) != 0, (Object)("Must be either master or read only to rebind (mode " + mode + ")"));
        }
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    RebindContextImpl getRebindContext() {
        return this.rebindContext;
    }

    protected void doRun() throws Exception {
        this.loadManifestFiles();
        this.initPlaneId();
        this.installBundlesAndRebuildCatalog();
        this.instantiateLocationsAndEntities();
        this.instantiateMementos();
        this.instantiateAdjuncts(this.instantiator);
        this.reconstructEverything();
        this.associateAdjunctsWithEntities();
        this.manageTheObjects();
        this.finishingUp();
    }

    protected abstract void loadManifestFiles() throws Exception;

    public void run() {
        if (this.iterationStarted.getAndSet(true)) {
            throw new IllegalStateException("Iteration " + this + " has already run; create a new instance for another rebind pass.");
        }
        try {
            this.rebindActive.acquire();
        }
        catch (InterruptedException e) {
            Exceptions.propagate((Throwable)e);
        }
        try {
            RebindManagerImpl.RebindTracker.setRebinding();
            if (ManagementNodeState.isHotProxy((ManagementNodeState)this.mode)) {
                this.readOnlyRebindCount.incrementAndGet();
            }
            this.timer = Stopwatch.createStarted();
            this.exceptionHandler.onStart((RebindContext)this.rebindContext);
            this.doRun();
            this.exceptionHandler.onDone();
            this.rebindMetrics.noteSuccess(Duration.of((Object)this.timer));
            this.noteErrors(this.exceptionHandler, null);
        }
        catch (Exception e) {
            this.rebindMetrics.noteFailure(Duration.of((Object)this.timer));
            Exceptions.propagateIfFatal((Throwable)e);
            this.noteErrors(this.exceptionHandler, e);
            throw this.exceptionHandler.onFailed(e);
        }
        finally {
            this.rebindActive.release();
            RebindManagerImpl.RebindTracker.reset();
        }
    }

    protected void checkEnteringPhase(int targetPhase) {
        ++this.phase;
        this.checkContinuingPhase(targetPhase);
    }

    protected void checkContinuingPhase(int targetPhase) {
        if (targetPhase != this.phase) {
            throw new IllegalStateException("Phase mismatch: should be phase " + targetPhase + " but is currently " + this.phase);
        }
    }

    protected void preprocessManifestFiles() throws Exception {
        this.checkContinuingPhase(1);
        Preconditions.checkState((this.mementoRawData != null ? 1 : 0) != 0, (Object)"Memento raw data should be set when calling this");
        Preconditions.checkState((this.mementoManifest == null ? 1 : 0) != 0, (Object)"Memento data should not yet be set when calling this");
        this.mementoManifest = this.persistenceStoreAccess.loadMementoManifest(this.mementoRawData, this.exceptionHandler);
        this.overwritingMaster = false;
        this.isEmpty = this.mementoManifest.isEmpty();
    }

    protected void installBundlesAndRebuildCatalog() {
        boolean needsAdditionalItemsLoaded;
        boolean needsInitialItemsLoaded;
        this.checkEnteringPhase(2);
        if (this.rebindManager.persistBundlesEnabled) {
            Object bundleM2;
            MutableList installs = MutableList.of();
            this.logRebindingDebug("RebindManager installing bundles: {}", this.mementoManifest.getBundleIds());
            for (Object bundleM2 : this.mementoManifest.getBundles().values()) {
                this.logRebindingDebug("RebindManager installing bundle {}", bundleM2.getId());
                try {
                    InputStream in = bundleM2.getJarContent().openStream();
                    Throwable throwable = null;
                    try {
                        installs.add(this.rebindContext.installBundle(this.instantiator.newManagedBundle((ManagedBundleMemento)bundleM2), in));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, bundleM2.getId(), bundleM2.getSymbolicName(), e);
                }
            }
            MutableSet installedTypes = MutableSet.of();
            bundleM2 = installs.iterator();
            while (bundleM2.hasNext()) {
                OsgiBundleInstallationResult br = (OsgiBundleInstallationResult)bundleM2.next();
                try {
                    this.rebindContext.startBundle(br);
                    Iterables.addAll((Collection)installedTypes, (Iterable)this.managementContext.getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle(br.getVersionedName())));
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, br.getMetadata().getId(), br.getMetadata().getSymbolicName(), e);
                }
            }
            if (!installedTypes.isEmpty()) {
                this.validateAllTypes((Set<RegisteredType>)installedTypes);
            }
        } else {
            this.logRebindingDebug("Not rebinding bundles; feature disabled: {}", this.mementoManifest.getBundleIds());
        }
        if (this.rebindManager.persistCatalogItemsEnabled) {
            this.logRebindingDebug("RebindManager instantiating catalog items: {}", this.mementoManifest.getCatalogItemIds());
            for (CatalogItemMemento catalogItemMemento : this.mementoManifest.getCatalogItemMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating catalog item {}", catalogItemMemento);
                try {
                    CatalogItem<?, ?> catalogItem = this.instantiator.newCatalogItem(catalogItemMemento);
                    this.rebindContext.registerCatalogItem(catalogItemMemento.getId(), catalogItem);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.CATALOG_ITEM, catalogItemMemento.getId(), catalogItemMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding catalog; feature disabled: {}", this.mementoManifest.getCatalogItemIds());
        }
        if (this.rebindManager.persistCatalogItemsEnabled) {
            this.logRebindingDebug("RebindManager reconstructing catalog items", new Object[0]);
            for (CatalogItemMemento catalogItemMemento : this.mementoManifest.getCatalogItemMementos().values()) {
                CatalogItem<?, ?> item = this.rebindContext.getCatalogItem(catalogItemMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing catalog item {}", catalogItemMemento);
                if (item == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.CATALOG_ITEM, catalogItemMemento.getId());
                    continue;
                }
                try {
                    item.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)catalogItemMemento);
                    if (!(item instanceof AbstractBrooklynObject)) continue;
                    ((AbstractBrooklynObject)AbstractBrooklynObject.class.cast(item)).setManagementContext(this.managementContext);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.CATALOG_ITEM, item, e);
                }
            }
        }
        Collection<CatalogItem<?, ?>> catalogItems = this.rebindContext.getCatalogItems();
        CatalogInitialization catInit = this.managementContext.getCatalogInitialization();
        catInit.applyCatalogLoadMode();
        MutableList itemsForResettingCatalog = null;
        if (this.rebindManager.persistCatalogItemsEnabled) {
            if (!catInit.hasRunFinalInitialization() && catInit.isInitialResetRequested()) {
                String message = "RebindManager resetting catalog on first run (catalog persistence enabled, but reset explicitly specified). ";
                if (catalogItems.isEmpty()) {
                    message = message + "Catalog was empty anyway.";
                } else {
                    message = message + "Deleting " + catalogItems.size() + " persisted catalog item" + Strings.s(catalogItems) + ": " + catalogItems;
                    if (this.shouldLogRebinding()) {
                        LOG.info(message);
                    }
                }
                this.logRebindingDebug(message, new Object[0]);
                itemsForResettingCatalog = MutableList.of();
                PersisterDeltaImpl delta = new PersisterDeltaImpl();
                delta.removedCatalogItemIds.addAll(this.mementoRawData.getCatalogItems().keySet());
                this.getPersister().queueDelta((BrooklynMementoPersister.Delta)delta);
                this.mementoRawData.clearCatalogItems();
                this.rebindContext.clearCatalogItems();
                needsInitialItemsLoaded = true;
                needsAdditionalItemsLoaded = true;
            } else if (!this.isEmpty.booleanValue()) {
                this.logRebindingDebug("RebindManager clearing local catalog and loading from persisted state", new Object[0]);
                itemsForResettingCatalog = this.rebindContext.getCatalogItems();
                needsInitialItemsLoaded = false;
                needsAdditionalItemsLoaded = !catInit.hasRunFinalInitialization();
            } else if (catInit.hasRunFinalInitialization()) {
                this.logRebindingDebug("RebindManager has already done the final official run, not doing anything (even though persisted state empty)", new Object[0]);
                needsInitialItemsLoaded = false;
                needsAdditionalItemsLoaded = false;
            } else {
                this.logRebindingDebug("RebindManager loading initial catalog locally because persisted state empty and the final official run has not yet been performed", new Object[0]);
                needsInitialItemsLoaded = true;
                needsAdditionalItemsLoaded = true;
            }
        } else if (catInit.hasRunFinalInitialization()) {
            this.logRebindingDebug("RebindManager skipping catalog init because it has already run (catalog persistence disabled)", new Object[0]);
            needsInitialItemsLoaded = false;
            needsAdditionalItemsLoaded = false;
        } else {
            this.logRebindingDebug("RebindManager will initialize catalog locally because catalog persistence is disabled and the final official run has not yet been performed", new Object[0]);
            needsInitialItemsLoaded = true;
            needsAdditionalItemsLoaded = true;
        }
        catInit.populateCatalog(this.mode, needsInitialItemsLoaded, needsAdditionalItemsLoaded, (Collection<CatalogItem<?, ?>>)itemsForResettingCatalog);
    }

    private void validateAllTypes(Set<RegisteredType> installedTypes) {
        Stopwatch sw = Stopwatch.createStarted();
        LOG.debug("Getting catalog to validate all types");
        BrooklynCatalog catalog = this.managementContext.getCatalog();
        LOG.debug("Got catalog in {} now validate", (Object)sw.toString());
        sw.reset();
        sw.start();
        Map validationErrors = catalog.validateTypes(installedTypes);
        LOG.debug("Validation done in {}", (Object)sw.toString());
        if (!validationErrors.isEmpty()) {
            MutableMap errorsByBundle = MutableMap.of();
            for (RegisteredType t : validationErrors.keySet()) {
                VersionedName vn = VersionedName.fromString((String)t.getContainingBundle());
                Map errorsInBundle = (Map)errorsByBundle.get(vn);
                if (errorsInBundle == null) {
                    errorsInBundle = MutableMap.of();
                    errorsByBundle.put(vn, errorsInBundle);
                }
                errorsInBundle.put(t, validationErrors.get(t));
            }
            for (VersionedName vn : errorsByBundle.keySet()) {
                Map errorsInBundle = (Map)errorsByBundle.get(vn);
                ManagedBundle b = ((OsgiManager)this.managementContext.getOsgiManager().get()).getManagedBundle(vn);
                this.exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, b != null ? b.getId() : vn.toString(), vn.getSymbolicName(), (Exception)Exceptions.create((String)("Failed to install " + vn + ", types " + errorsInBundle.keySet() + " gave errors"), (Iterable)Iterables.concat(errorsInBundle.values())));
            }
        }
    }

    protected void instantiateLocationsAndEntities() {
        this.checkEnteringPhase(3);
        this.logRebindingDebug("RebindManager instantiating locations: {}", this.mementoManifest.getLocationIdToType().keySet());
        for (Map.Entry entry : this.mementoManifest.getLocationIdToType().entrySet()) {
            String locId = (String)entry.getKey();
            String locType = (String)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("RebindManager instantiating location {}", (Object)locId);
            }
            try {
                Location location = this.instantiator.newLocation(locId, locType);
                this.rebindContext.registerLocation(locId, location);
            }
            catch (Exception e) {
                this.exceptionHandler.onCreateFailed(BrooklynObjectType.LOCATION, locId, locType, e);
            }
        }
        this.logRebindingDebug("RebindManager instantiating entities: {}", this.mementoManifest.getEntityIdToManifest().keySet());
        for (Map.Entry entry : this.mementoManifest.getEntityIdToManifest().entrySet()) {
            String entityId = (String)entry.getKey();
            BrooklynMementoManifest.EntityMementoManifest entityManifest = (BrooklynMementoManifest.EntityMementoManifest)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("RebindManager instantiating entity {}", (Object)entityId);
            }
            try {
                Entity entity = this.instantiator.newEntity(entityManifest);
                ((EntityInternal)entity).getManagementSupport().setReadOnly(this.rebindContext.isReadOnly((BrooklynObject)entity));
                this.rebindContext.registerEntity(entityId, entity);
            }
            catch (Exception e) {
                this.exceptionHandler.onCreateFailed(BrooklynObjectType.ENTITY, entityId, entityManifest.getType(), e);
            }
        }
    }

    protected void instantiateMementos() throws IOException {
        this.checkEnteringPhase(4);
        this.memento = this.persistenceStoreAccess.loadMemento(this.mementoRawData, this.rebindContext.lookup(), this.exceptionHandler);
    }

    protected void initPlaneId() {
        String persistedPlaneId = this.mementoRawData.getPlaneId();
        if (persistedPlaneId == null) {
            if (!this.mementoRawData.isEmpty()) {
                LOG.warn("Rebinding against existing persisted state, but no planeId found. Will generate a new one. Expected if this is the first rebind after upgrading to Brooklyn 0.12.0+");
            }
            if (this.managementContext.getManagementPlaneIdMaybe().isAbsent()) {
                ((LocalManagementContext)this.managementContext).generateManagementPlaneId();
            }
        } else {
            ((LocalManagementContext)this.managementContext).setManagementPlaneId(persistedPlaneId);
        }
    }

    protected void instantiateAdjuncts(BrooklynObjectInstantiator instantiator) {
        this.checkEnteringPhase(5);
        if (this.rebindManager.persistPoliciesEnabled) {
            this.logRebindingDebug("RebindManager instantiating policies: {}", this.memento.getPolicyIds());
            for (PolicyMemento policyMemento : this.memento.getPolicyMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating policy {}", policyMemento);
                try {
                    Policy policy = instantiator.newPolicy(policyMemento);
                    this.rebindContext.registerPolicy(policyMemento.getId(), policy);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.POLICY, policyMemento.getId(), policyMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding policies; feature disabled: {}", this.memento.getPolicyIds());
        }
        if (this.rebindManager.persistEnrichersEnabled) {
            this.logRebindingDebug("RebindManager instantiating enrichers: {}", this.memento.getEnricherIds());
            for (EnricherMemento enricherMemento : this.memento.getEnricherMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating enricher {}", enricherMemento);
                try {
                    Enricher enricher = instantiator.newEnricher(enricherMemento);
                    this.rebindContext.registerEnricher(enricherMemento.getId(), enricher);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.ENRICHER, enricherMemento.getId(), enricherMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding enrichers; feature disabled: {}", this.memento.getEnricherIds());
        }
        if (this.rebindManager.persistFeedsEnabled) {
            this.logRebindingDebug("RebindManager instantiating feeds: {}", this.memento.getFeedIds());
            for (FeedMemento feedMemento : this.memento.getFeedMementos().values()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RebindManager instantiating feed {}", (Object)feedMemento);
                }
                try {
                    Feed feed = instantiator.newFeed(feedMemento);
                    this.rebindContext.registerFeed(feedMemento.getId(), feed);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.FEED, feedMemento.getId(), feedMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding feeds; feature disabled: {}", this.memento.getFeedIds());
        }
    }

    protected void reconstructEverything() {
        this.checkEnteringPhase(6);
        this.logRebindingDebug("RebindManager reconstructing locations", new Object[0]);
        for (LocationMemento locMemento : this.sortParentFirst(this.memento.getLocationMementos()).values()) {
            Location location = this.rebindContext.getLocation(locMemento.getId());
            this.logRebindingDebug("RebindManager reconstructing location {}", locMemento);
            if (location == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.LOCATION, locMemento.getId());
                continue;
            }
            try {
                ((LocationInternal)location).getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)locMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.LOCATION, (BrooklynObject)location, e);
            }
        }
        if (this.rebindManager.persistPoliciesEnabled) {
            this.logRebindingDebug("RebindManager reconstructing policies", new Object[0]);
            for (PolicyMemento policyMemento : this.memento.getPolicyMementos().values()) {
                Policy policy = this.rebindContext.getPolicy(policyMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing policy {}", policyMemento);
                if (policy == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.POLICY, policyMemento.getId());
                    continue;
                }
                try {
                    policy.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)policyMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.POLICY, (BrooklynObject)policy, e);
                    this.rebindContext.unregisterPolicy(policy);
                }
            }
        }
        if (this.rebindManager.persistEnrichersEnabled) {
            this.logRebindingDebug("RebindManager reconstructing enrichers", new Object[0]);
            for (EnricherMemento enricherMemento : this.memento.getEnricherMementos().values()) {
                Enricher enricher = this.rebindContext.getEnricher(enricherMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing enricher {}", enricherMemento);
                if (enricher == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.ENRICHER, enricherMemento.getId());
                    continue;
                }
                try {
                    enricher.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)enricherMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENRICHER, (BrooklynObject)enricher, e);
                    this.rebindContext.unregisterEnricher(enricher);
                }
            }
        }
        if (this.rebindManager.persistFeedsEnabled) {
            this.logRebindingDebug("RebindManager reconstructing feeds", new Object[0]);
            for (FeedMemento feedMemento : this.memento.getFeedMementos().values()) {
                Feed feed = this.rebindContext.getFeed(feedMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing feed {}", feedMemento);
                if (feed == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.FEED, feedMemento.getId());
                    continue;
                }
                try {
                    feed.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)feedMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.FEED, (BrooklynObject)feed, e);
                    this.rebindContext.unregisterFeed(feed);
                }
            }
        }
        this.logRebindingDebug("RebindManager reconstructing entities", new Object[0]);
        for (EntityMemento entityMemento : this.sortParentFirst(this.memento.getEntityMementos()).values()) {
            Entity entity = this.rebindContext.lookup().lookupEntity(entityMemento.getId());
            this.logRebindingDebug("RebindManager reconstructing entity {}", entityMemento);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, entityMemento.getId());
                continue;
            }
            try {
                entityMemento.injectTypeClass(entity.getClass());
                ((EntityInternal)entity).getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)entityMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
        }
    }

    protected void associateAdjunctsWithEntities() {
        this.checkEnteringPhase(7);
        this.logRebindingDebug("RebindManager associating adjuncts to entities", new Object[0]);
        for (EntityMemento entityMemento : this.sortParentFirst(this.memento.getEntityMementos()).values()) {
            Entity entity = this.rebindContext.getEntity(entityMemento.getId());
            this.logRebindingDebug("RebindManager associating adjuncts to entity {}", entityMemento);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, entityMemento.getId());
                continue;
            }
            try {
                entityMemento.injectTypeClass(entity.getClass());
                ((EntityInternal)entity).getRebindSupport().addPolicies((RebindContext)this.rebindContext, (Memento)entityMemento);
                ((EntityInternal)entity).getRebindSupport().addEnrichers((RebindContext)this.rebindContext, (Memento)entityMemento);
                ((EntityInternal)entity).getRebindSupport().addFeeds((RebindContext)this.rebindContext, (Memento)entityMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
        }
    }

    protected void manageTheObjects() {
        this.checkEnteringPhase(8);
        this.logRebindingDebug("RebindManager managing locations", new Object[0]);
        LocationManagerInternal locationManager = (LocationManagerInternal)this.managementContext.getLocationManager();
        LinkedHashSet oldLocations = Sets.newLinkedHashSet(locationManager.getLocationIds());
        for (Location location : this.rebindContext.getLocations()) {
            ManagementTransitionMode oldMode = this.updateTransitionMode(locationManager, location);
            if (oldMode == null) continue;
            oldLocations.remove(location.getId());
        }
        for (Location location : this.rebindContext.getLocations()) {
            if (location.getParent() != null) continue;
            try {
                ((LocationManagerInternal)this.managementContext.getLocationManager()).manageRebindedRoot((BrooklynObject)location);
            }
            catch (Exception e) {
                this.exceptionHandler.onManageFailed(BrooklynObjectType.LOCATION, (BrooklynObject)location, e);
            }
        }
        this.cleanupOldLocations(oldLocations);
        this.logRebindingDebug("RebindManager managing entities", new Object[0]);
        EntityManagerInternal entityManager = (EntityManagerInternal)this.managementContext.getEntityManager();
        LinkedHashSet oldEntities = Sets.newLinkedHashSet(entityManager.getEntityIds());
        for (Entity entity : this.rebindContext.getEntities()) {
            ManagementTransitionMode oldMode = this.updateTransitionMode(entityManager, entity);
            if (oldMode == null) continue;
            oldEntities.remove(entity.getId());
        }
        ArrayList apps = Lists.newArrayList();
        for (String rootId : this.getMementoRootEntities()) {
            Entity entity = this.rebindContext.getEntity(rootId);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, rootId);
                continue;
            }
            try {
                entityManager.manageRebindedRoot((BrooklynObject)entity);
            }
            catch (Exception e) {
                this.exceptionHandler.onManageFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
            if (!(entity instanceof Application)) continue;
            apps.add((Application)entity);
        }
        this.cleanupOldEntities(oldEntities);
        this.applications = apps;
    }

    private <T extends BrooklynObject> ManagementTransitionMode updateTransitionMode(BrooklynObjectManagerInternal<T> boManager, T bo) {
        BrooklynObjectManagementMode modeAfter;
        ManagementTransitionMode oldTransitionMode = boManager.getLastManagementTransitionMode(bo.getId());
        Boolean isNowReadOnly = this.rebindContext.isReadOnly(bo);
        BrooklynObjectManagementMode modeBefore = oldTransitionMode == null ? BrooklynObjectManagementMode.UNMANAGED_PERSISTED : oldTransitionMode.getModeAfter();
        if (this.isRebindingActiveAgain()) {
            Preconditions.checkState((!Boolean.TRUE.equals(isNowReadOnly) ? 1 : 0) != 0);
            Preconditions.checkState((modeBefore == BrooklynObjectManagementMode.MANAGED_PRIMARY ? 1 : 0) != 0);
            modeAfter = BrooklynObjectManagementMode.MANAGED_PRIMARY;
        } else {
            modeAfter = isNowReadOnly != false ? BrooklynObjectManagementMode.LOADED_READ_ONLY : BrooklynObjectManagementMode.MANAGED_PRIMARY;
        }
        ManagementTransitionMode newTransitionMode = ManagementTransitionMode.transitioning(modeBefore, modeAfter);
        boManager.setManagementTransitionMode(bo, newTransitionMode);
        return oldTransitionMode;
    }

    protected abstract boolean isRebindingActiveAgain();

    protected Collection<String> getMementoRootEntities() {
        return this.memento.getApplicationIds();
    }

    protected abstract void cleanupOldLocations(Set<String> var1);

    protected abstract void cleanupOldEntities(Set<String> var1);

    protected void finishingUp() {
        this.checkContinuingPhase(8);
        if (!this.isEmpty.booleanValue()) {
            BrooklynLogging.log(LOG, this.shouldLogRebinding() ? BrooklynLogging.LoggingLevel.INFO : BrooklynLogging.LoggingLevel.DEBUG, "Rebind complete (" + this.mode + (this.readOnlyRebindCount.get() >= 0 ? ", iteration " + this.readOnlyRebindCount : "") + ") in {}: {} app{}, {} entit{}, {} location{}, {} polic{}, {} enricher{}, {} feed{}, {} catalog item{}", Time.makeTimeStringRounded((Stopwatch)this.timer), this.applications.size(), Strings.s(this.applications), this.rebindContext.getEntities().size(), Strings.ies(this.rebindContext.getEntities()), this.rebindContext.getLocations().size(), Strings.s(this.rebindContext.getLocations()), this.rebindContext.getPolicies().size(), Strings.ies(this.rebindContext.getPolicies()), this.rebindContext.getEnrichers().size(), Strings.s(this.rebindContext.getEnrichers()), this.rebindContext.getFeeds().size(), Strings.s(this.rebindContext.getFeeds()), this.rebindContext.getCatalogItems().size(), Strings.s(this.rebindContext.getCatalogItems()));
        }
        this.logRebindingDebug("RebindManager complete; apps: {}", this.getMementoRootEntities());
    }

    protected void noteErrors(RebindExceptionHandler exceptionHandler, Exception primaryException) {
        List exceptions = exceptionHandler.getExceptions();
        List warnings = exceptionHandler.getWarnings();
        if (primaryException != null || !exceptions.isEmpty() || !warnings.isEmpty()) {
            MutableList messages = MutableList.of();
            if (primaryException != null) {
                messages.add(primaryException.toString());
            }
            for (Exception e : exceptions) {
                messages.add(e.toString());
            }
            for (String w : warnings) {
                messages.add(w);
            }
            this.rebindMetrics.noteError((List<?>)messages);
        }
    }

    protected CatalogItemIdAndSearchPath findCatalogItemIds(ClassLoader cl, Map<String, BrooklynMementoManifest.EntityMementoManifest> entityIdToManifest, BrooklynMementoManifest.EntityMementoManifest entityManifest) {
        if (entityManifest.getCatalogItemId() != null) {
            return new CatalogItemIdAndSearchPath(entityManifest.getCatalogItemId(), entityManifest.getCatalogItemIdSearchPath());
        }
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind")) {
            String typeId = null;
            MutableList searchPath = MutableList.of();
            BrooklynMementoManifest.EntityMementoManifest ptr = entityManifest;
            while (ptr != null) {
                String pId = ptr.getCatalogItemId();
                if (pId != null) {
                    RegisteredType type = this.managementContext.getTypeRegistry().get(pId);
                    if (type != null) {
                        typeId = type.getId();
                    }
                    for (String id : ptr.getCatalogItemIdSearchPath()) {
                        type = this.managementContext.getTypeRegistry().get(id);
                        if (type != null) {
                            searchPath.add(type.getId());
                            continue;
                        }
                        searchPath.add(id);
                    }
                    return new CatalogItemIdAndSearchPath(typeId, (List<String>)searchPath);
                }
                if (ptr.getParent() != null) {
                    ptr = entityIdToManifest.get(ptr.getParent());
                    continue;
                }
                ptr = null;
            }
            BrooklynTypeRegistry types = this.managementContext.getTypeRegistry();
            ptr = entityManifest;
            while (ptr != null) {
                RegisteredType t = types.get(ptr.getType(), "0.0.0_DEFAULT_VERSION");
                if (t != null) {
                    LOG.debug("Inferred catalog item ID " + t.getId() + " for " + entityManifest + " from ancestor " + ptr);
                    return new CatalogItemIdAndSearchPath(t.getId(), (List<String>)ImmutableList.of());
                }
                if (ptr.getParent() != null) {
                    ptr = entityIdToManifest.get(ptr.getParent());
                    continue;
                }
                ptr = null;
            }
            if (JavaBrooklynClassLoadingContext.create(this.managementContext).tryLoadClass(entityManifest.getType()).isPresent()) {
                return new CatalogItemIdAndSearchPath(null, (List<String>)ImmutableList.of());
            }
            for (RegisteredType item : types.getAll()) {
                BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext((ManagementContext)this.managementContext, item);
                boolean canLoadClass = loader.tryLoadClass(entityManifest.getType()).isPresent();
                if (!canLoadClass) continue;
                LOG.warn("Missing catalog item for " + entityManifest.getId() + " (" + entityManifest.getType() + "), inferring as " + item.getId() + " because that is able to load the item");
                return new CatalogItemIdAndSearchPath(item.getId(), (List<String>)ImmutableList.of());
            }
        }
        return new CatalogItemIdAndSearchPath(null, (List<String>)ImmutableList.of());
    }

    protected BrooklynMementoPersister getPersister() {
        return this.rebindManager.getPersister();
    }

    protected <T extends TreeNode> Map<String, T> sortParentFirst(Map<String, T> nodes) {
        return RebindManagerImpl.sortParentFirst(nodes);
    }

    protected void logRebindingDebug(String message, Object ... args) {
        if (this.shouldLogRebinding()) {
            LOG.debug(message, args);
        } else {
            LOG.trace(message, args);
        }
    }

    protected boolean shouldLogRebinding() {
        return this.readOnlyRebindCount.get() < 5 || this.readOnlyRebindCount.get() % 1000 == 0;
    }

    protected class BrooklynObjectInstantiator {
        protected final ClassLoader classLoader;
        protected final RebindContextImpl rebindContext;
        protected final Reflections reflections;

        protected BrooklynObjectInstantiator(ClassLoader classLoader, RebindContextImpl rebindContext, Reflections reflections) {
            this.classLoader = classLoader;
            this.rebindContext = rebindContext;
            this.reflections = reflections;
        }

        protected Entity newEntity(BrooklynMementoManifest.EntityMementoManifest entityManifest) {
            Object entity;
            String entityId = entityManifest.getId();
            CatalogItemIdAndSearchPath idPath = RebindIteration.this.findCatalogItemIds(this.classLoader, RebindIteration.this.mementoManifest.getEntityIdToManifest(), entityManifest);
            String entityType = entityManifest.getType();
            LoadedClass<Entity> loaded = this.load(Entity.class, entityType, idPath.getCatalogItemId(), idPath.getSearchPath(), entityId);
            Class entityClazz = loaded.clazz;
            if (InternalFactory.isNewStyle(entityClazz)) {
                InternalEntityFactory entityFactory = RebindIteration.this.managementContext.getEntityFactory();
                entity = entityFactory.constructEntity(entityClazz, Reflections.getAllInterfaces(entityClazz), entityId);
            } else {
                LOG.warn("Deprecated rebind of entity without no-arg constructor; this may not be supported in future versions: id=" + entityId + "; type=" + entityType);
                LinkedHashMap flags = Maps.newLinkedHashMap();
                flags.put("id", entityId);
                if (AbstractApplication.class.isAssignableFrom(entityClazz)) {
                    flags.put("mgmt", RebindIteration.this.managementContext);
                }
                entity = (Entity)this.invokeConstructor(null, entityClazz, {flags}, {flags, null}, {null}, new Object[0]);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)entityId), entity);
                if (entity instanceof AbstractApplication) {
                    FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"mgmt", (Object)RebindIteration.this.managementContext), entity);
                }
                ((AbstractEntity)entity).setManagementContext(RebindIteration.this.managementContext);
                RebindIteration.this.managementContext.prePreManage((Entity)entity);
            }
            this.setCatalogItemIds((BrooklynObject)entity, loaded.catalogItemId, loaded.searchPath);
            return entity;
        }

        protected void setCatalogItemIds(BrooklynObject object, String catalogItemId, List<String> searchPath) {
            BrooklynObjectInternal internal = (BrooklynObjectInternal)object;
            internal.setCatalogItemIdAndSearchPath(catalogItemId, searchPath);
        }

        protected <T extends BrooklynObject> LoadedClass<? extends T> load(Class<T> bType, Memento memento) {
            return this.load(bType, memento.getType(), memento.getCatalogItemId(), memento.getCatalogItemIdSearchPath(), memento.getId());
        }

        protected <T extends BrooklynObject> LoadedClass<? extends T> load(Class<T> bType, String jType, String catalogItemId, List<String> searchPath, String contextSuchAsId) {
            Preconditions.checkNotNull((Object)jType, (String)"Type of %s (%s) must not be null", (Object[])new Object[]{contextSuchAsId, bType.getSimpleName()});
            MutableList reboundSearchPath = MutableList.of();
            if (searchPath != null && !searchPath.isEmpty()) {
                for (String searchItemId : searchPath) {
                    CatalogItem<?, ?> ci;
                    String fixedSearchItemId = null;
                    RegisteredType t1 = RebindIteration.this.managementContext.getTypeRegistry().get(searchItemId);
                    if (t1 != null) {
                        fixedSearchItemId = t1.getId();
                    }
                    if (fixedSearchItemId == null && (ci = this.findCatalogItemInReboundCatalog(bType, searchItemId, contextSuchAsId)) != null) {
                        fixedSearchItemId = ci.getCatalogItemId();
                    }
                    if (fixedSearchItemId != null) {
                        reboundSearchPath.add(fixedSearchItemId);
                        continue;
                    }
                    LOG.warn("Unable to load catalog item " + searchItemId + " for search path of " + contextSuchAsId + " (" + bType.getSimpleName() + "); attempting to load " + jType + " nevertheless");
                }
            }
            if (catalogItemId != null) {
                String transformedCatalogItemId = null;
                Maybe registeredType = RebindIteration.this.managementContext.getTypeRegistry().getMaybe(catalogItemId, null);
                if (registeredType.isPresent()) {
                    transformedCatalogItemId = ((RegisteredType)registeredType.get()).getId();
                } else {
                    CatalogItem<?, ?> catalogItem = this.findCatalogItemInReboundCatalog(bType, catalogItemId, contextSuchAsId);
                    if (catalogItem != null) {
                        transformedCatalogItemId = catalogItem.getCatalogItemId();
                    }
                }
                if (transformedCatalogItemId != null) {
                    try {
                        BrooklynClassLoadingContextSequential loader = new BrooklynClassLoadingContextSequential(RebindIteration.this.managementContext, new BrooklynClassLoadingContext[0]);
                        loader.add(CatalogUtils.newClassLoadingContextForCatalogItems(RebindIteration.this.managementContext, transformedCatalogItemId, (List<String>)reboundSearchPath));
                        return new LoadedClass<T>(loader.loadClass(jType, bType), transformedCatalogItemId, (List<String>)reboundSearchPath);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        LOG.warn("Unable to load class " + jType + " needed for " + catalogItemId + " for " + contextSuchAsId + ", via " + transformedCatalogItemId + " loader (will try reflections)");
                    }
                } else {
                    LOG.warn("Unable to load catalog item " + catalogItemId + " (" + bType + ") for " + contextSuchAsId + " (" + bType.getSimpleName() + "); will try reflection");
                }
            }
            try {
                return new LoadedClass(this.loadClass(jType), catalogItemId, (List<String>)reboundSearchPath);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Unable to load class " + jType + " needed for " + catalogItemId + " for " + contextSuchAsId + ", via reflections (may try others, will throw if fails)");
                if (catalogItemId != null) {
                    throw new IllegalStateException("Unable to load " + jType + " for catalog item " + catalogItemId + " for " + contextSuchAsId);
                }
                if (BrooklynFeatureEnablement.isEnabled("brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind")) {
                    BrooklynCatalog catalog = RebindIteration.this.managementContext.getCatalog();
                    for (CatalogItem item : catalog.getCatalogItemsLegacy()) {
                        BrooklynClassLoadingContext catalogLoader = CatalogUtils.newClassLoadingContext((ManagementContext)RebindIteration.this.managementContext, item);
                        Maybe catalogClass = catalogLoader.tryLoadClass(jType);
                        if (!catalogClass.isPresent()) continue;
                        LOG.warn("Found " + jType + " only by scanning catalog item search paths");
                        return new LoadedClass((Class)catalogClass.get(), catalogItemId, (List<String>)reboundSearchPath);
                    }
                    throw new IllegalStateException("No catalogItemId specified for " + contextSuchAsId + " and can't load class (" + jType + ") from either classpath or catalog items");
                }
                throw new IllegalStateException("No catalogItemId specified for " + contextSuchAsId + " and can't load class (" + jType + ") from classpath");
            }
        }

        private <T extends BrooklynObject> CatalogItem<?, ?> findCatalogItemInReboundCatalog(Class<T> bType, String catalogItemId, String contextSuchAsId) {
            CatalogItem catalogItem = this.rebindContext.lookup().lookupCatalogItem(catalogItemId);
            if (catalogItem == null && BrooklynFeatureEnablement.isEnabled("brooklyn.quickfix.fixDanglingCatalogItemOnRebind") && (RegisteredTypeNaming.isUsableTypeColonVersion(catalogItemId) || CatalogUtils.looksLikeVersionedId(catalogItemId))) {
                String symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(catalogItemId);
                catalogItem = this.rebindContext.lookup().lookupCatalogItem(symbolicName);
                if (catalogItem != null) {
                    LOG.warn("Unable to load catalog item " + catalogItemId + " for " + contextSuchAsId + " (" + bType.getSimpleName() + "); will auto-upgrade to " + catalogItem.getCatalogItemId() + ":" + catalogItem.getVersion());
                }
            }
            return catalogItem;
        }

        protected Class<?> loadClass(String jType) throws ClassNotFoundException {
            try {
                return this.reflections.loadClass(jType);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return new ClassLoaderUtils(this.reflections.getClassLoader(), (ManagementContext)RebindIteration.this.managementContext).loadClass(jType);
            }
        }

        public <T> Class<? extends T> loadClass(String classname, Class<T> superType) {
            try {
                return this.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        protected Location newLocation(String locationId, String locationType) {
            Class<Location> locationClazz = this.loadClass(locationType, Location.class);
            if (InternalFactory.isNewStyle(locationClazz)) {
                InternalLocationFactory locationFactory = RebindIteration.this.managementContext.getLocationFactory();
                Location location = locationFactory.constructLocation(locationClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)locationId), location);
                RebindIteration.this.managementContext.prePreManage(location);
                ((AbstractLocation)location).setManagementContext(RebindIteration.this.managementContext);
                return location;
            }
            LOG.warn("Deprecated rebind of location without no-arg constructor; this may not be supported in future versions: id=" + locationId + "; type=" + locationType);
            MutableMap flags = MutableMap.of((Object)"id", (Object)locationId, (Object)"deferConstructionChecks", (Object)true);
            return this.invokeConstructor(this.reflections, locationClazz, new Object[][]{{flags}});
        }

        protected Policy newPolicy(PolicyMemento memento) {
            Object policy;
            String id = memento.getId();
            LoadedClass<Policy> loaded = this.load(Policy.class, (Memento)memento);
            Class policyClazz = loaded.clazz;
            if (InternalFactory.isNewStyle(policyClazz)) {
                InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
                policy = policyFactory.constructPolicy(policyClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), policy);
                ((AbstractPolicy)policy).setManagementContext(RebindIteration.this.managementContext);
                ((AbstractPolicy)policy).setHighlights(memento.getHighlights());
            } else {
                LOG.warn("Deprecated rebind of policy without no-arg constructor; this may not be supported in future versions: id=" + id + "; type=" + policyClazz);
                MutableMap flags = MutableMap.of((Object)"id", (Object)id, (Object)"deferConstructionChecks", (Object)true, (Object)"noConstructionInit", (Object)true);
                flags.putAll(memento.getConfig());
                policy = (Policy)this.invokeConstructor(null, policyClazz, new Object[][]{{flags}});
            }
            this.setCatalogItemIds((BrooklynObject)policy, loaded.catalogItemId, loaded.searchPath);
            return policy;
        }

        protected Enricher newEnricher(EnricherMemento memento) {
            Object enricher;
            String id = memento.getId();
            LoadedClass<Enricher> loaded = this.load(Enricher.class, (Memento)memento);
            Class enricherClazz = loaded.clazz;
            if (InternalFactory.isNewStyle(enricherClazz)) {
                InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
                enricher = policyFactory.constructEnricher(enricherClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), enricher);
                ((AbstractEnricher)enricher).setManagementContext(RebindIteration.this.managementContext);
            } else {
                LOG.warn("Deprecated rebind of enricher without no-arg constructor; this may not be supported in future versions: id=" + id + "; type=" + enricherClazz);
                MutableMap flags = MutableMap.of((Object)"id", (Object)id, (Object)"deferConstructionChecks", (Object)true, (Object)"noConstructionInit", (Object)true);
                flags.putAll(memento.getConfig());
                enricher = (Enricher)this.invokeConstructor(this.reflections, enricherClazz, new Object[][]{{flags}});
            }
            this.setCatalogItemIds((BrooklynObject)enricher, loaded.catalogItemId, loaded.searchPath);
            return enricher;
        }

        protected Feed newFeed(FeedMemento memento) {
            String id = memento.getId();
            LoadedClass<Feed> loaded = this.load(Feed.class, (Memento)memento);
            Class feedClazz = loaded.clazz;
            if (!InternalFactory.isNewStyle(feedClazz)) {
                throw new IllegalStateException("rebind of feed without no-arg constructor unsupported: id=" + id + "; type=" + feedClazz);
            }
            InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
            Object feed = policyFactory.constructFeed(feedClazz);
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), feed);
            ((AbstractFeed)feed).setManagementContext(RebindIteration.this.managementContext);
            this.setCatalogItemIds((BrooklynObject)feed, loaded.catalogItemId, loaded.searchPath);
            return feed;
        }

        protected CatalogItem<?, ?> newCatalogItem(CatalogItemMemento memento) {
            String id = memento.getId();
            String itemType = (String)Preconditions.checkNotNull((Object)memento.getType(), (String)"catalog item type of %s must not be null in memento", (Object[])new Object[]{id});
            Class<CatalogItem> clazz = this.loadClass(itemType, CatalogItem.class);
            return this.invokeConstructor(this.reflections, clazz, new Object[][]{new Object[0]});
        }

        protected ManagedBundle newManagedBundle(ManagedBundleMemento memento) {
            BasicManagedBundle result = new BasicManagedBundle(memento.getSymbolicName(), memento.getVersion(), memento.getUrl());
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)memento.getId()), result);
            return result;
        }

        protected <T> T invokeConstructor(Reflections reflections, Class<T> clazz, Object[] ... possibleArgs) {
            for (Object[] args : possibleArgs) {
                try {
                    Maybe v = Reflections.invokeConstructorFromArgs(clazz, (Object[])args, (boolean)true);
                    if (!v.isPresent()) continue;
                    return (T)v.get();
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            StringBuilder args = new StringBuilder();
            if (possibleArgs.length < 1) {
                args.append("no possible argument sets supplied; error");
            } else if (possibleArgs.length < 2) {
                args.append("args are " + Arrays.asList(possibleArgs[0]));
            } else {
                args.append("args are " + Arrays.asList(possibleArgs[0]));
                for (int i = 1; i < possibleArgs.length; ++i) {
                    args.append(" or ");
                    args.append(Arrays.asList(possibleArgs[i]));
                }
            }
            throw new IllegalStateException("Cannot instantiate instance of type " + clazz + "; expected constructor signature not found (" + args + ")");
        }
    }

    protected static class LoadedClass<T extends BrooklynObject> {
        protected final Class<? extends T> clazz;
        protected final String catalogItemId;
        protected final List<String> searchPath;

        protected LoadedClass(Class<? extends T> clazz, String catalogItemId, List<String> searchPath) {
            this.clazz = clazz;
            this.catalogItemId = catalogItemId;
            this.searchPath = searchPath;
        }
    }

    protected class CatalogItemIdAndSearchPath {
        private String catalogItemId;
        private List<String> searchPath;

        public CatalogItemIdAndSearchPath(String catalogItemId, List<String> searchPath) {
            this.catalogItemId = catalogItemId;
            this.searchPath = searchPath;
        }

        public String getCatalogItemId() {
            return this.catalogItemId;
        }

        public List<String> getSearchPath() {
            return this.searchPath;
        }
    }
}

