/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.core.config.StructuredConfigKey;
import org.apache.brooklyn.core.config.SubElementConfigKey;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationSupportInternal
implements BrooklynObjectInternal.ConfigurationSupportInternal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurationSupportInternal.class);

    public <T> T get(ConfigKey.HasConfigKey<T> key) {
        return this.get(key.getConfigKey());
    }

    @Override
    public Maybe<Object> getLocalRaw(ConfigKey.HasConfigKey<?> key) {
        return this.getLocalRaw(key.getConfigKey());
    }

    @Override
    public Maybe<Object> getRaw(ConfigKey.HasConfigKey<?> key) {
        return this.getRaw(key.getConfigKey());
    }

    @Override
    public <T> Maybe<T> getNonBlocking(ConfigKey.HasConfigKey<T> key) {
        return this.getNonBlocking(key.getConfigKey());
    }

    @Override
    public <T> Maybe<T> getNonBlocking(ConfigKey<T> key) {
        try {
            if (key instanceof StructuredConfigKey || key instanceof SubElementConfigKey) {
                return this.getNonBlockingResolvingStructuredKey(key);
            }
            return this.getNonBlockingResolvingSimple(key);
        }
        catch (ImmediateSupplier.ImmediateValueNotAvailableException e) {
            return Maybe.absent((Throwable)e);
        }
        catch (ImmediateSupplier.ImmediateUnsupportedException e) {
            return Maybe.absent((Throwable)e);
        }
    }

    protected <T> Maybe<T> getNonBlockingResolvingStructuredKey(final ConfigKey<T> key) {
        Callable job = new Callable<T>(){

            @Override
            public T call() {
                try {
                    return AbstractConfigurationSupportInternal.this.get(key);
                }
                catch (RuntimeInterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        };
        Task t = Tasks.builder().body(job).displayName("Resolving dependent value").description("Resolving " + key.getName()).tag("TRANSIENT").build();
        try {
            return this.getContext().getImmediately(t);
        }
        catch (ImmediateSupplier.ImmediateUnsupportedException e) {
            return Maybe.absent();
        }
    }

    protected <T> Maybe<T> getNonBlockingResolvingSimple(ConfigKey<T> key) {
        Object unresolved = this.getRaw(key).or(key.getDefaultValue());
        Maybe<Object> resolved = Tasks.resolving(unresolved).as(Object.class).immediately(true).deep(true).context(this.getContext()).getMaybe();
        if (resolved.isAbsent()) {
            return Maybe.Absent.castAbsent(resolved);
        }
        return TypeCoercions.tryCoerce(resolved.get(), key.getTypeToken());
    }

    public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
        return this.set(key.getConfigKey(), val);
    }

    public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
        return this.set(key.getConfigKey(), val);
    }

    protected abstract AbstractConfigMapImpl<? extends BrooklynObject> getConfigsInternal();

    protected abstract <T> void assertValid(ConfigKey<T> var1, T var2);

    protected abstract BrooklynObject getContainer();

    protected abstract <T> void onConfigChanging(ConfigKey<T> var1, Object var2);

    protected abstract <T> void onConfigChanged(ConfigKey<T> var1, Object var2);

    public <T> T get(ConfigKey<T> key) {
        return this.getConfigsInternal().getConfig(key);
    }

    protected <T> T setConfigInternal(ConfigKey<T> key, Object val) {
        this.onConfigChanging(key, val);
        Object result = this.getConfigsInternal().setConfig(key, val);
        this.onConfigChanged(key, val);
        return (T)result;
    }

    public <T> T set(ConfigKey<T> key, T val) {
        this.assertValid(key, val);
        return this.setConfigInternal(key, val);
    }

    public <T> T set(ConfigKey<T> key, Task<T> val) {
        return this.setConfigInternal(key, val);
    }

    @Override
    public ConfigBag getLocalBag() {
        return ConfigBag.newInstance(this.getConfigsInternal().getAllConfigLocalRaw());
    }

    @Override
    public Maybe<Object> getRaw(ConfigKey<?> key) {
        return ((ConfigValueAtContainer)this.getConfigsInternal().getConfigInheritedRaw(key).getWithoutError()).asMaybe();
    }

    @Override
    public Maybe<Object> getLocalRaw(ConfigKey<?> key) {
        return this.getConfigsInternal().getConfigLocalRaw(key);
    }

    @Override
    public void putAll(Map<?, ?> vals) {
        this.getConfigsInternal().putAll(vals);
    }

    @Override
    @Deprecated
    public void set(Map<?, ?> vals) {
        this.putAll(vals);
    }

    @Override
    public void removeKey(String key) {
        this.getConfigsInternal().removeKey(key);
    }

    @Override
    public void removeKey(ConfigKey<?> key) {
        this.getConfigsInternal().removeKey(key);
    }

    @Override
    public void removeAllLocalConfig() {
        this.getConfigsInternal().setLocalConfig((Map<ConfigKey<?>, ?>)MutableMap.of());
    }

    @Deprecated
    public Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter) {
        return this.getConfigsInternal().findKeys(filter);
    }

    public Set<ConfigKey<?>> findKeysDeclared(Predicate<? super ConfigKey<?>> filter) {
        return this.getConfigsInternal().findKeysDeclared(filter);
    }

    public Set<ConfigKey<?>> findKeysPresent(Predicate<? super ConfigKey<?>> filter) {
        return this.getConfigsInternal().findKeysPresent(filter);
    }

    @Override
    public ConfigMap.ConfigMapWithInheritance<? extends BrooklynObject> getInternalConfigMap() {
        return this.getConfigsInternal();
    }

    @Override
    public Map<ConfigKey<?>, Object> getAllLocalRaw() {
        return this.getConfigsInternal().getAllConfigLocalRaw();
    }

    @Override
    public ConfigBag getBag() {
        return this.getConfigsInternal().getAllConfigBag();
    }

    @Nullable
    protected abstract ExecutionContext getContext();
}

