/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.entity;

import java.util.Set;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.resolve.entity.AbstractEntitySpecResolver;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogEntitySpecResolver
extends AbstractEntitySpecResolver {
    private static final Logger log = LoggerFactory.getLogger(CatalogEntitySpecResolver.class);
    private static final String RESOLVER_NAME = "catalog";

    public CatalogEntitySpecResolver() {
        super(RESOLVER_NAME);
    }

    @Override
    protected boolean canResolve(String type, BrooklynClassLoadingContext loader) {
        String localType = this.getLocalType(type);
        RegisteredType item = this.mgmt.getTypeRegistry().get(localType);
        if (item == null) {
            return false;
        }
        return !item.isDisabled();
    }

    @Override
    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> parentEncounteredTypes) {
        String localType = this.getLocalType(type);
        RegisteredType item = this.mgmt.getTypeRegistry().get(localType);
        if (item == null) {
            return null;
        }
        this.checkUsable(item);
        boolean recursiveCall = parentEncounteredTypes.contains(item.getSymbolicName());
        if (recursiveCall) {
            return null;
        }
        return (EntitySpec)this.mgmt.getTypeRegistry().createSpec(item, RegisteredTypeLoadingContexts.alreadyEncountered(parentEncounteredTypes), EntitySpec.class);
    }

    private void checkUsable(RegisteredType item) {
        if (item.isDisabled()) {
            throw new IllegalStateException("Illegal use of disabled catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
        if (item.isDeprecated()) {
            log.warn("Use of deprecated catalog item " + item.getSymbolicName() + ":" + item.getVersion());
        }
    }
}

