/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttributeMap {
    static final Logger log = LoggerFactory.getLogger(AttributeMap.class);
    private final AbstractEntity entity;
    private final Map<Collection<String>, Object> values;

    public AttributeMap(AbstractEntity entity) {
        this(entity, Collections.synchronizedMap(Maps.newLinkedHashMap()));
    }

    public AttributeMap(AbstractEntity entity, Map<Collection<String>, Object> storage) {
        this.entity = (AbstractEntity)Preconditions.checkNotNull((Object)entity, (Object)"entity must be specified");
        this.values = (Map)Preconditions.checkNotNull(storage, (Object)"storage map must not be null");
    }

    @Beta
    public Object getSynchObjectInternal() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Collection<String>, Object> asRawMap() {
        Map<Collection<String>, Object> map = this.values;
        synchronized (map) {
            return ImmutableMap.copyOf(this.values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> asMap() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Map<Collection<String>, Object> map = this.values;
        synchronized (map) {
            for (Map.Entry<Collection<String>, Object> entry : this.values.entrySet()) {
                String sensorName = Joiner.on((char)'.').join((Iterable)entry.getKey());
                Object val = this.isNull(entry.getValue()) ? null : entry.getValue();
                result.put(sensorName, val);
            }
        }
        return result;
    }

    public <T> T update(Collection<String> path, T newValue) {
        Object oldValue;
        this.checkPath(path);
        if (newValue == null) {
            newValue = this.typedNull();
        }
        if (log.isTraceEnabled()) {
            log.trace("setting sensor {}={} for {}", new Object[]{path, newValue, this.entity});
        }
        return (T)(this.isNull(oldValue = this.values.put(path, newValue)) ? null : oldValue);
    }

    private void checkPath(Collection<String> path) {
        Preconditions.checkNotNull(path, (Object)"path can't be null");
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path can't be empty");
    }

    public <T> T update(AttributeSensor<T> attribute, T newValue) {
        T oldValue = this.updateWithoutPublishing(attribute, newValue);
        this.entity.emitInternal(attribute, newValue);
        return oldValue;
    }

    public <T> T updateWithoutPublishing(AttributeSensor<T> attribute, T newValue) {
        T oldValue;
        if (log.isTraceEnabled()) {
            oldValue = this.getValue(attribute);
            if (!Objects.equal(oldValue, (Object)(newValue != null ? 1 : 0))) {
                log.trace("setting attribute {} to {} (was {}) on {}", new Object[]{attribute.getName(), newValue, oldValue, this.entity});
            } else {
                log.trace("setting attribute {} to {} (unchanged) on {}", new Object[]{attribute.getName(), newValue, this});
            }
        }
        return this.isNull(oldValue = this.update(attribute.getNameParts(), newValue)) ? null : (T)oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T modify(AttributeSensor<T> attribute, Function<? super T, Maybe<T>> modifier) {
        Map<Collection<String>, Object> map = this.values;
        synchronized (map) {
            T oldValue = this.getValue(attribute);
            Maybe newValue = (Maybe)modifier.apply(oldValue);
            if (newValue.isPresent()) {
                if (log.isTraceEnabled()) {
                    log.trace("modified attribute {} to {} (was {}) on {}", new Object[]{attribute.getName(), newValue, oldValue, this.entity});
                }
                return (T)this.update(attribute, newValue.get());
            }
            if (log.isTraceEnabled()) {
                log.trace("modified attribute {} unchanged; not emitting on {}", new Object[]{attribute.getName(), newValue, this});
            }
            return oldValue;
        }
    }

    public void remove(AttributeSensor<?> attribute) {
        BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)this.entity), "removing attribute {} on {}", attribute.getName(), this.entity);
        this.remove(attribute.getNameParts());
    }

    public void remove(Collection<String> path) {
        this.checkPath(path);
        if (log.isTraceEnabled()) {
            log.trace("removing sensor {} for {}", new Object[]{path, this.entity});
        }
        this.values.remove(path);
    }

    public Object getValue(Collection<String> path) {
        this.checkPath(path);
        Object result = this.values.get(path);
        return this.isNull(result) ? null : result;
    }

    public <T> T getValue(AttributeSensor<T> sensor) {
        return TypeCoercions.coerce(this.getValue(sensor.getNameParts()), sensor.getType());
    }

    private <T> T typedNull() {
        return (T)((Object)Marker.NULL);
    }

    private boolean isNull(Object t) {
        return t == Marker.NULL;
    }

    private static enum Marker {
        NULL;

    }
}

