/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.osgi.VersionedName;

public class BasicRegisteredType
implements RegisteredType {
    final BrooklynTypeRegistry.RegisteredTypeKind kind;
    final String symbolicName;
    final String version;
    String containingBundle;
    final List<OsgiBundleWithUrl> bundles = MutableList.of();
    String displayName;
    String description;
    String iconUrl;
    final Set<Object> superTypes = MutableSet.of();
    boolean deprecated;
    boolean disabled;
    final Set<String> aliases = MutableSet.of();
    final Set<Object> tags = MutableSet.of();
    RegisteredType.TypeImplementationPlan implementationPlan;
    private transient ConfigBag cache = new ConfigBag();

    BasicRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind kind, String symbolicName, String version, RegisteredType.TypeImplementationPlan implementationPlan) {
        this.kind = kind;
        this.symbolicName = symbolicName;
        this.version = version;
        this.implementationPlan = implementationPlan;
    }

    public String getId() {
        if (this.symbolicName == null) {
            return null;
        }
        return this.symbolicName + (this.version != null ? ":" + this.version : "");
    }

    public BrooklynTypeRegistry.RegisteredTypeKind getKind() {
        return this.kind;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public VersionedName getVersionedName() {
        return new VersionedName(this.getSymbolicName(), this.getVersion());
    }

    public String getContainingBundle() {
        return this.containingBundle;
    }

    public Collection<OsgiBundleWithUrl> getLibraries() {
        return ImmutableSet.copyOf(this.bundles);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Set<Object> getSuperTypes() {
        return ImmutableSet.copyOf(this.superTypes);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Set<String> getAliases() {
        return ImmutableSet.copyOf(this.aliases);
    }

    public Set<Object> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }

    @Beta
    public ConfigBag getCache() {
        return this.cache;
    }

    public RegisteredType.TypeImplementationPlan getPlan() {
        return this.implementationPlan;
    }

    public String toString() {
        return JavaClassNames.simpleClassName((Object)this) + "[" + this.getId() + (this.isDisabled() ? ";DISABLED" : "") + (this.isDeprecated() ? ";deprecated" : "") + (this.getPlan() != null ? ";" + this.getPlan().getPlanFormat() : "") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
        result = 31 * result + (this.bundles == null ? 0 : this.bundles.hashCode());
        result = 31 * result + (this.containingBundle == null ? 0 : this.containingBundle.hashCode());
        result = 31 * result + (this.deprecated ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.disabled ? 1231 : 1237);
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.iconUrl == null ? 0 : this.iconUrl.hashCode());
        result = 31 * result + (this.implementationPlan == null ? 0 : this.implementationPlan.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.superTypes == null ? 0 : this.superTypes.hashCode());
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicRegisteredType other = (BasicRegisteredType)obj;
        if (!Objects.equal(this.aliases, other.aliases)) {
            return false;
        }
        if (!Objects.equal(this.bundles, other.bundles)) {
            return false;
        }
        if (!Objects.equal((Object)this.containingBundle, (Object)other.containingBundle)) {
            return false;
        }
        if (!Objects.equal((Object)this.deprecated, (Object)other.deprecated)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)other.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.disabled, (Object)other.disabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.iconUrl, (Object)other.iconUrl)) {
            return false;
        }
        if (!Objects.equal((Object)this.implementationPlan, (Object)other.implementationPlan)) {
            return false;
        }
        if (!Objects.equal((Object)this.kind, (Object)other.kind)) {
            return false;
        }
        if (!Objects.equal(this.superTypes, other.superTypes)) {
            return false;
        }
        if (!Objects.equal((Object)this.symbolicName, (Object)other.symbolicName)) {
            return false;
        }
        if (!Objects.equal(this.tags, other.tags)) {
            return false;
        }
        return Objects.equal((Object)this.version, (Object)other.version);
    }
}

