/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredTypePredicates {
    private static final Logger log = LoggerFactory.getLogger(RegisteredTypePredicates.class);
    public static final Function<RegisteredType, String> ID_OF_ITEM_TRANSFORMER = new IdOfItemTransformer();
    public static final Predicate<RegisteredType> IS_APPLICATION = RegisteredTypePredicates.subtypeOf(Application.class);
    public static final Predicate<RegisteredType> IS_ENTITY = RegisteredTypePredicates.subtypeOf(Entity.class);
    public static final Predicate<RegisteredType> IS_LOCATION = RegisteredTypePredicates.subtypeOf(Location.class);
    public static final Predicate<RegisteredType> IS_POLICY = RegisteredTypePredicates.subtypeOf(Policy.class);
    public static final Predicate<RegisteredType> IS_ENRICHER = RegisteredTypePredicates.subtypeOf(Enricher.class);

    public static Predicate<RegisteredType> deprecated(boolean deprecated) {
        return new DeprecatedEqualTo(deprecated);
    }

    public static Predicate<RegisteredType> disabled(boolean disabled) {
        return new DisabledEqualTo(disabled);
    }

    public static Predicate<RegisteredType> template(boolean template) {
        return new TemplateTagPresent(template);
    }

    public static Predicate<RegisteredType> displayName(Predicate<? super String> filter) {
        return new DisplayNameMatches(filter);
    }

    public static Predicate<RegisteredType> symbolicName(String name) {
        return RegisteredTypePredicates.symbolicName((Predicate<? super String>)Predicates.equalTo((Object)name));
    }

    public static Predicate<RegisteredType> symbolicName(Predicate<? super String> filter) {
        return new SymbolicNameMatches(filter);
    }

    public static Predicate<RegisteredType> version(String name) {
        return RegisteredTypePredicates.version((Predicate<? super String>)Predicates.equalTo((Object)name));
    }

    public static Predicate<RegisteredType> version(Predicate<? super String> filter) {
        return new VersionMatches(filter);
    }

    public static Predicate<RegisteredType> alias(String alias) {
        return RegisteredTypePredicates.aliases((Predicate<? super Iterable<String>>)CollectionFunctionals.any((Predicate)Predicates.equalTo((Object)alias)));
    }

    public static Predicate<RegisteredType> aliases(Predicate<? super Iterable<String>> filter) {
        return new AliasesMatch(filter);
    }

    public static Predicate<RegisteredType> tag(Object tag) {
        return RegisteredTypePredicates.tags((Predicate<? super Iterable<Object>>)CollectionFunctionals.any((Predicate)Predicates.equalTo((Object)tag)));
    }

    public static Predicate<RegisteredType> tags(Predicate<? super Iterable<Object>> filter) {
        return new TagsMatch(filter);
    }

    public static <T> Predicate<RegisteredType> anySuperType(Predicate<Class<T>> filter) {
        return new AnySuperTypeMatches(filter);
    }

    public static Predicate<RegisteredType> subtypeOf(Class<?> filter) {
        return RegisteredTypePredicates.anySuperType(Predicates.assignableFrom(filter));
    }

    public static Predicate<RegisteredType> entitledToSee(ManagementContext mgmt) {
        return new EntitledToSee(mgmt);
    }

    public static Predicate<RegisteredType> isBestVersion(ManagementContext mgmt) {
        return new IsBestVersion(mgmt);
    }

    public static boolean isBestVersion(ManagementContext mgmt, RegisteredType item) {
        if (item == null) {
            return false;
        }
        Iterable matches = mgmt.getTypeRegistry().getMatching(RegisteredTypePredicates.symbolicName(item.getSymbolicName()));
        if (!matches.iterator().hasNext()) {
            return false;
        }
        RegisteredType best = RegisteredTypes.getBestVersion(matches);
        return best.getVersion().equals(item.getVersion());
    }

    public static Predicate<RegisteredType> satisfies(RegisteredTypeLoadingContext context) {
        return new SatisfiesContext(context);
    }

    public static Predicate<? super RegisteredType> containingBundle(VersionedName versionedName) {
        return new ContainingBundle(versionedName);
    }

    public static Predicate<? super RegisteredType> containingBundle(OsgiBundleWithUrl bundle) {
        return RegisteredTypePredicates.containingBundle(bundle.getVersionedName());
    }

    public static Predicate<? super RegisteredType> containingBundle(String versionedName) {
        return RegisteredTypePredicates.containingBundle(VersionedName.fromString((String)versionedName));
    }

    @Beta
    public static Predicate<RegisteredType> stringRepresentationMatches(Predicate<? super String> filter) {
        return new StringRepresentationMatches((Predicate<? super String>)((Predicate)Preconditions.checkNotNull(filter, (Object)"filter")));
    }

    private static class StringRepresentationMatches<T, SpecT>
    implements Predicate<RegisteredType> {
        private final Predicate<? super String> filter;

        StringRepresentationMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            try {
                String thingToCompare = item.getVersionedName().toString() + "\n" + item.getVersionedName().toOsgiString() + "\n" + item.getTags() + "\n" + item.getDisplayName() + "\n" + item.getAliases() + "\n" + item.getDescription() + "\n" + RegisteredTypes.getImplementationDataStringForSpec(item);
                return this.filter.apply((Object)thingToCompare);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Problem producing string representation of " + item + "; assuming no match, and continuing", (Throwable)e);
                return false;
            }
        }
    }

    private static class ContainingBundle
    implements Predicate<RegisteredType> {
        private final VersionedName bundle;

        public ContainingBundle(VersionedName bundle) {
            this.bundle = bundle;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return this.bundle.equalsOsgi((Object)item.getContainingBundle());
        }
    }

    private static class SatisfiesContext
    implements Predicate<RegisteredType> {
        private final RegisteredTypeLoadingContext context;

        public SatisfiesContext(RegisteredTypeLoadingContext context) {
            this.context = context;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return RegisteredTypes.tryValidate(item, this.context).isPresent();
        }
    }

    private static class IsBestVersion
    implements Predicate<RegisteredType> {
        private final ManagementContext mgmt;

        public IsBestVersion(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return RegisteredTypePredicates.isBestVersion(this.mgmt, item);
        }
    }

    private static class EntitledToSee
    implements Predicate<RegisteredType> {
        private final ManagementContext mgmt;

        public EntitledToSee(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && Entitlements.isEntitled(this.mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, item.getId());
        }
    }

    private static class AnySuperTypeMatches
    implements Predicate<RegisteredType> {
        private final Predicate<Class<?>> filter;

        private AnySuperTypeMatches(Predicate filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            if (item == null) {
                return false;
            }
            return RegisteredTypes.isAnyTypeOrSuperSatisfying(item.getSuperTypes(), this.filter);
        }
    }

    private static class TagsMatch
    implements Predicate<RegisteredType> {
        private final Predicate<? super Iterable<Object>> filter;

        public TagsMatch(Predicate<? super Iterable<Object>> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && this.filter.apply((Object)item.getTags());
        }
    }

    private static class AliasesMatch
    implements Predicate<RegisteredType> {
        private final Predicate<? super Iterable<String>> filter;

        public AliasesMatch(Predicate<? super Iterable<String>> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && this.filter.apply((Object)item.getAliases());
        }
    }

    private static class VersionMatches
    implements Predicate<RegisteredType> {
        private final Predicate<? super String> filter;

        public VersionMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && this.filter.apply((Object)item.getVersion());
        }
    }

    private static class SymbolicNameMatches
    implements Predicate<RegisteredType> {
        private final Predicate<? super String> filter;

        public SymbolicNameMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && this.filter.apply((Object)item.getSymbolicName());
        }
    }

    private static class DisplayNameMatches
    implements Predicate<RegisteredType> {
        private final Predicate<? super String> filter;

        public DisplayNameMatches(Predicate<? super String> filter) {
            this.filter = filter;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && this.filter.apply((Object)item.getDisplayName());
        }
    }

    private static class IdOfItemTransformer
    implements Function<RegisteredType, String> {
        private IdOfItemTransformer() {
        }

        @Nullable
        public String apply(@Nullable RegisteredType input) {
            if (input == null) {
                return null;
            }
            return input.getId();
        }
    }

    private static class TemplateTagPresent
    implements Predicate<RegisteredType> {
        private final boolean present;

        public TemplateTagPresent(boolean present) {
            this.present = present;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && RegisteredTypes.isTemplate(item) == this.present;
        }
    }

    private static class DisabledEqualTo
    implements Predicate<RegisteredType> {
        private final boolean disabled;

        public DisabledEqualTo(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && item.isDisabled() == this.disabled;
        }
    }

    private static class DeprecatedEqualTo
    implements Predicate<RegisteredType> {
        private final boolean deprecated;

        public DeprecatedEqualTo(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public boolean apply(@Nullable RegisteredType item) {
            return item != null && item.isDeprecated() == this.deprecated;
        }
    }
}

