/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.shell;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.DelegatingPollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.feed.shell.ShellPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.core.task.system.internal.SystemProcessTaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(ShellFeed.class);
    private static final ConfigKey<SetMultimap<ShellPollIdentifier, ShellPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<ShellPollIdentifier, ShellPollConfig<?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    public ShellFeed() {
    }

    protected ShellFeed(Builder builder) {
        HashMultimap polls = HashMultimap.create();
        for (ShellPollConfig config : builder.polls) {
            if (!config.isEnabled()) continue;
            ShellPollConfig configCopy = new ShellPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period, builder.periodUnits);
            }
            String command = config.getCommand();
            Map<String, String> env = config.getEnv();
            File dir = config.getDir();
            String input = config.getInput();
            String context = config.getSensor().getName();
            long timeout = config.getTimeout();
            polls.put((Object)new ShellPollIdentifier(command, env, dir, input, context, timeout), configCopy);
        }
        this.setConfig(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    @Override
    protected void preStart() {
        SetMultimap<ShellPollIdentifier, ShellPollConfig<?>> polls = this.getConfig(POLLS);
        for (ShellPollIdentifier pollInfo : polls.keySet()) {
            Set configs = polls.get((Object)pollInfo);
            long minPeriod = Integer.MAX_VALUE;
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (ShellPollConfig config : configs) {
                handlers.add(new AttributePollHandler(config, (Entity)this.entity, this));
                if (config.getPeriod() <= 0L) continue;
                minPeriod = Math.min(minPeriod, config.getPeriod());
            }
            final ProcessTaskFactory<?> taskFactory = this.newTaskFactory(pollInfo.command, pollInfo.env, pollInfo.dir, pollInfo.input, pollInfo.context, pollInfo.timeout);
            final ExecutionContext executionContext = ((EntityInternal)this.entity).getExecutionContext();
            this.getPoller().scheduleAtFixedRate(new Callable<SshPollValue>(){

                @Override
                public SshPollValue call() throws Exception {
                    ProcessTaskWrapper taskWrapper = (ProcessTaskWrapper)taskFactory.newTask();
                    executionContext.submit((TaskAdaptable)taskWrapper);
                    taskWrapper.block();
                    Optional exitCode = Optional.fromNullable((Object)taskWrapper.getExitCode());
                    return new SshPollValue(null, (Integer)exitCode.or((Object)-1), taskWrapper.getStdout(), taskWrapper.getStderr());
                }
            }, new DelegatingPollHandler(handlers), minPeriod);
        }
    }

    protected Poller<SshPollValue> getPoller() {
        return super.getPoller();
    }

    protected ProcessTaskFactory<?> newTaskFactory(String command, Map<String, String> env, File dir, String input, String summary, long timeout) {
        if (timeout > 0L) {
            log.warn("Timeout ({}ms) not currently supported for ShellFeed {}", (Object)timeout, (Object)this);
        }
        return ((SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory)((SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory)((SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory)((SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory)new SystemProcessTaskFactory.ConcreteSystemProcessTaskFactory(command).environmentVariables((Map)env)).loginShell(true)).directory(dir)).runAsCommand()).summary(summary);
    }

    private static class ShellPollIdentifier {
        final String command;
        final Map<String, String> env;
        final File dir;
        final String input;
        final String context;
        final long timeout;

        private ShellPollIdentifier(String command, Map<String, String> env, File dir, String input, String context, long timeout) {
            this.command = (String)Preconditions.checkNotNull((Object)command, (Object)"command");
            this.env = (Map)Preconditions.checkNotNull(env, (Object)"env");
            this.dir = dir;
            this.input = input;
            this.context = (String)Preconditions.checkNotNull((Object)context, (Object)"context");
            this.timeout = timeout;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.command, this.env, this.dir, this.input, this.timeout});
        }

        public boolean equals(Object other) {
            if (!(other instanceof ShellPollIdentifier)) {
                return false;
            }
            ShellPollIdentifier o = (ShellPollIdentifier)other;
            return Objects.equal((Object)this.command, (Object)o.command) && Objects.equal(this.env, o.env) && Objects.equal((Object)this.dir, (Object)o.dir) && Objects.equal((Object)this.input, (Object)o.input) && Objects.equal((Object)this.timeout, (Object)o.timeout);
        }
    }

    public static class Builder {
        private Entity entity;
        private long period = 500L;
        private TimeUnit periodUnits = TimeUnit.MILLISECONDS;
        private List<ShellPollConfig<?>> polls = Lists.newArrayList();
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = val;
            return this;
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            this.period = val;
            this.periodUnits = units;
            return this;
        }

        public Builder poll(ShellPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public ShellFeed build() {
            this.built = true;
            ShellFeed result = new ShellFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)((EntityLocal)this.entity), (Object)"entity"));
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("ShellFeed.Builder created, but build() never called");
            }
        }
    }
}

