/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.location.BasicLocationRegistry;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.location.multi.MultiLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.KeyValueParser;
import org.apache.brooklyn.util.text.StringEscapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLocationResolver
implements LocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLocationResolver.class);
    private static final String MULTI = "multi";
    private static final Pattern PATTERN = Pattern.compile("(multi|" + "multi".toUpperCase() + "):\\((.*)\\)$");
    private volatile ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled(this.managementContext, this.getPrefix());
    }

    public LocationSpec<? extends Location> newLocationSpecFromString(String spec, Map<?, ?> locationFlags, LocationRegistry registry) {
        MutableMap locationArgs;
        Map globalProperties = registry.getProperties();
        if (spec.equalsIgnoreCase(MULTI)) {
            locationArgs = MutableMap.copyOf(locationFlags);
        } else {
            Matcher matcher = PATTERN.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid location '" + spec + "'; must specify something like multi(targets=named:foo)");
            }
            String args = matcher.group(2);
            locationArgs = MutableMap.copyOf((Map)KeyValueParser.parseMap((String)args));
        }
        String namedLocation = (String)locationFlags.get("named");
        Map<String, Object> filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(null, namedLocation, globalProperties);
        MutableMap flags = MutableMap.builder().putAll(filteredProperties).putAll(locationFlags).removeAll(new Object[]{"named"}).putAll((Map)locationArgs).build();
        if (locationArgs.get("targets") == null) {
            throw new IllegalArgumentException("target must be specified in single-machine spec");
        }
        ArrayList targets = Lists.newArrayList();
        Object targetSpecs = locationArgs.remove("targets");
        if (targetSpecs instanceof String) {
            for (String targetSpec : StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)((String)targetSpecs))) {
                targets.add(this.managementContext.getLocationRegistry().getLocationSpec(targetSpec, (Map)ImmutableMap.of()).get());
            }
        } else if (targetSpecs instanceof Iterable) {
            for (Object targetSpec : (Iterable)targetSpecs) {
                if (targetSpec instanceof String) {
                    targets.add(this.managementContext.getLocationRegistry().getLocationSpec((String)targetSpec, (Map)ImmutableMap.of()).get());
                    continue;
                }
                Set keys = ((Map)targetSpec).keySet();
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("targets supplied to MultiLocation must be a list of single-entry maps (got map of size " + keys.size() + ": " + targetSpec + ")");
                }
                Object key = keys.iterator().next();
                Object flagsS = ((Map)targetSpec).get(key);
                targets.add(this.managementContext.getLocationRegistry().getLocationSpec((String)key, (Map)flagsS).get());
            }
        } else {
            throw new IllegalArgumentException("targets must be supplied to MultiLocation, either as string spec or list of single-entry maps each being a location spec");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating multi-location spec for sub-locations " + targets);
        }
        LocationSpec result = (LocationSpec)((LocationSpec)((LocationSpec)LocationSpec.create(MultiLocation.class).configure((Map)flags)).configure((CharSequence)MultiLocation.SUB_LOCATION_SPECS.getName(), (Object)targets)).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation));
        return result;
    }

    public String getPrefix() {
        return MULTI;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec(this, spec, true);
    }
}

