/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.crypto;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.util.crypto.AuthorizedKeysParser;
import org.apache.brooklyn.util.crypto.SecureKeysWithoutBouncyCastle;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureKeys
extends SecureKeysWithoutBouncyCastle {
    private static final Logger log = LoggerFactory.getLogger(SecureKeys.class);

    public static void initBouncyCastleProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private SecureKeys() {
    }

    public static X509Principal getX509PrincipalWithCommonName(String commonName) {
        return new X509Principal("C=None,L=None,O=None,OU=None,CN=" + commonName);
    }

    @Deprecated
    public static KeyPair readPem(InputStream input, String passphrase) {
        return SecureKeys.readPem(Streams.readFully((InputStream)input), passphrase);
    }

    public static KeyPair readPem(byte[] key, String passphrase) {
        ByteArrayInputStream input = new ByteArrayInputStream(key);
        try {
            KeyPair keyPair;
            PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(input));
            Object object = pemParser.readObject();
            pemParser.close();
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object == null) {
                throw new IllegalStateException("PEM parsing failed: missing or invalid data");
            }
            if (object instanceof PEMEncryptedKeyPair) {
                if (passphrase == null) {
                    throw new PassphraseProblem("passphrase required");
                }
                try {
                    PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(passphrase.toCharArray());
                    keyPair = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv));
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new PassphraseProblem("wrong passphrase", e);
                }
            } else if (object instanceof PEMKeyPair) {
                keyPair = converter.getKeyPair((PEMKeyPair)object);
            } else if (object instanceof PrivateKeyInfo) {
                PrivateKey privKey = converter.getPrivateKey((PrivateKeyInfo)object);
                keyPair = new KeyPair(null, privKey);
            } else {
                throw new IllegalStateException("PEM parser support missing for: " + object);
            }
            return keyPair;
        }
        catch (IOException e) {
            throw new RuntimeException("Invalid key", e);
        }
    }

    public static boolean equal(KeyPair k1, KeyPair k2) {
        return Objects.equal((Object)k2.getPrivate(), (Object)k1.getPrivate()) && Objects.equal((Object)k2.getPublic(), (Object)k1.getPublic());
    }

    public static String toPem(KeyPair key) {
        return SecureKeys.stringPem(key);
    }

    public static String toPub(KeyPair key) {
        return AuthorizedKeysParser.encodePublicKey((PublicKey)key.getPublic());
    }

    public static PublicKey fromPub(String pubText) {
        return AuthorizedKeysParser.decodePublicKey((String)pubText);
    }

    @Deprecated
    public static String stringPem(KeyPair key) {
        try {
            StringWriter sw = new StringWriter();
            PEMWriter w = new PEMWriter((Writer)sw);
            w.writeObject((Object)key);
            w.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        BrooklynInitialization.initSecureKeysBouncyCastleProvider();
    }

    public static class PassphraseProblem
    extends IllegalStateException {
        private static final long serialVersionUID = -3382824813899223447L;

        public PassphraseProblem(String message) {
            super("Passphrase problem with this key: " + message);
        }

        public PassphraseProblem(String message, Exception cause) {
            super("Passphrase problem with this key: " + message, cause);
        }
    }
}

