/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.flags;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.groovy.GroovyJavaMethods;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagUtils {
    public static final Logger log = LoggerFactory.getLogger(FlagUtils.class);

    private FlagUtils() {
    }

    public static Map<?, ?> setPublicFieldsFromFlags(Map<?, ?> flags, Object o) {
        return FlagUtils.setFieldsFromFlagsInternal(o, Arrays.asList(o.getClass().getFields()), flags, null, true);
    }

    public static Map<?, ?> setFieldsFromFlags(Map<?, ?> flags, Object o) {
        return FlagUtils.setFieldsFromFlagsInternal(o, FlagUtils.getAllFields(o.getClass()), flags, null, true);
    }

    public static void setFieldsFromFlags(Object o, ConfigBag configBag) {
        FlagUtils.setFieldsFromFlagsInternal(o, FlagUtils.getAllFields(o.getClass()), configBag.getAllConfig(), configBag, true);
    }

    public static void setFieldsFromFlags(Object o, ConfigBag configBag, boolean setDefaultVals) {
        FlagUtils.setFieldsFromFlagsInternal(o, FlagUtils.getAllFields(o.getClass()), configBag.getAllConfig(), configBag, setDefaultVals);
    }

    public static void setFieldsFromFlagsWithBag(Object o, Map<?, ?> flags, ConfigBag configBag, boolean setDefaultVals) {
        FlagUtils.setFieldsFromFlagsInternal(o, FlagUtils.getAllFields(o.getClass()), flags, configBag, setDefaultVals);
    }

    public static boolean setFieldFromFlag(Object o, String flagName, Object fieldVal) {
        return FlagUtils.setFieldFromFlagInternal((String)Preconditions.checkNotNull((Object)flagName, (Object)"flagName"), fieldVal, o, FlagUtils.getAllFields(o.getClass()));
    }

    public static Map<String, ?> getFieldsWithFlags(Object o) {
        return FlagUtils.getFieldsWithFlagsInternal(o, FlagUtils.getAllFields(o.getClass()));
    }

    public static Field findFieldForFlag(String flagName, Object o) {
        return FlagUtils.findFieldForFlagInternal(flagName, o, FlagUtils.getAllFields(o.getClass()));
    }

    public static Map<String, Object> getFieldsWithFlagsExcludingModifiers(Object o, int excludingModifiers) {
        ArrayList filteredFields = Lists.newArrayList();
        for (Field contender : FlagUtils.getAllFields(o.getClass())) {
            if ((contender.getModifiers() & excludingModifiers) != 0) continue;
            filteredFields.add(contender);
        }
        return FlagUtils.getFieldsWithFlagsInternal(o, filteredFields);
    }

    public static Map<String, Object> getFieldsWithFlagsWithModifiers(Object o, int requiredModifiers) {
        ArrayList filteredFields = Lists.newArrayList();
        for (Field contender : FlagUtils.getAllFields(o.getClass())) {
            if ((contender.getModifiers() & requiredModifiers) != requiredModifiers) continue;
            filteredFields.add(contender);
        }
        return FlagUtils.getFieldsWithFlagsInternal(o, filteredFields);
    }

    @Deprecated
    public static Map<String, ?> setAllConfigKeys(Map<String, ?> flagsOrConfig, Configurable instance) {
        return FlagUtils.setAllConfigKeys(flagsOrConfig, instance, false);
    }

    public static Map<String, ?> setAllConfigKeys(Map<String, ?> flagsOrConfig, Configurable instance, boolean includeFlags) {
        ConfigBag bag = new ConfigBag().putAll(flagsOrConfig);
        FlagUtils.setAllConfigKeys(instance, bag, includeFlags);
        return bag.getUnusedConfigMutable();
    }

    @Deprecated
    public static void setAllConfigKeys(Configurable o, ConfigBag bag) {
        FlagUtils.setAllConfigKeys(o, bag, false);
    }

    public static void setAllConfigKeys(Configurable o, ConfigBag bag, boolean includeFlags) {
        for (Field f : FlagUtils.getAllFields(o.getClass())) {
            ConfigKey<?> key = FlagUtils.getFieldAsConfigKey(o, f);
            if (key == null) continue;
            FlagConfigKeyAndValueRecord record = FlagUtils.getFlagConfigKeyRecord(f, key, bag);
            if ((!includeFlags || !record.isValuePresent()) && !record.getConfigKeyMaybeValue().isPresent()) continue;
            FlagUtils.setField(o, f, record.getValueOrNullPreferringConfigKey(), null);
        }
    }

    public static Map<String, ConfigKey<?>> findAllConfigKeys(Object optionalInstance, Iterable<? extends Class<?>> types) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Class<?> type : types) {
            List<ConfigKey<?>> keys = FlagUtils.findAllConfigKeys(optionalInstance, type);
            for (ConfigKey<?> key : keys) {
                if (result.containsKey(key.getName())) continue;
                result.put(key.getName(), key);
            }
        }
        return result;
    }

    public static <T> List<ConfigKey<?>> findAllConfigKeys(T optionalInstance, Class<? extends T> type) {
        ArrayList output = new ArrayList();
        for (Field f : FlagUtils.getAllFields(type)) {
            ConfigKey<?> key = FlagUtils.getFieldAsConfigKey(optionalInstance, f);
            if (key == null) continue;
            output.add(key);
        }
        return output;
    }

    public static <T> List<FlagConfigKeyAndValueRecord> findAllFlagsAndConfigKeys(T optionalInstance, Class<? extends T> type, ConfigBag input) {
        ArrayList<FlagConfigKeyAndValueRecord> output = new ArrayList<FlagConfigKeyAndValueRecord>();
        for (Field f : FlagUtils.getAllFields(type)) {
            ConfigKey<?> key;
            FlagConfigKeyAndValueRecord record = FlagUtils.getFlagConfigKeyRecord(f, key = FlagUtils.getFieldAsConfigKey(optionalInstance, f), input);
            if (!record.isValuePresent()) continue;
            output.add(record);
        }
        return output;
    }

    public static List<FlagConfigKeyAndValueRecord> findAllParameterConfigKeys(List<SpecParameter<?>> parameters, ConfigBag input) {
        ArrayList<FlagConfigKeyAndValueRecord> output = new ArrayList<FlagConfigKeyAndValueRecord>();
        for (SpecParameter<?> param : parameters) {
            FlagConfigKeyAndValueRecord record = FlagUtils.getFlagConfigKeyRecord(null, param.getConfigKey(), input);
            if (!record.isValuePresent()) continue;
            output.add(record);
        }
        return output;
    }

    private static FlagConfigKeyAndValueRecord getFlagConfigKeyRecord(Field f, ConfigKey<?> key, ConfigBag input) {
        SetFromFlag flag;
        FlagConfigKeyAndValueRecord result = new FlagConfigKeyAndValueRecord();
        result.configKey = key;
        if (key != null && input.containsKey(key)) {
            result.configKeyValue = input.getObjKeyMaybe(key);
        }
        if (f != null && (flag = f.getAnnotation(SetFromFlag.class)) != null) {
            String flagName = JavaGroovyEquivalents.elvis((String)flag.value(), (String)f.getName());
            result.flagName = flagName;
            if (input.containsKey(flagName)) {
                result.flagValue = Maybe.of((Object)input.getStringKey(flagName));
            }
        }
        return result;
    }

    @Deprecated
    public static List<Field> getAllFields(Class<?> base, Closure<Boolean> filter) {
        return FlagUtils.getAllFields(base, (Predicate<Field>)GroovyJavaMethods.predicateFromClosure(filter));
    }

    public static List<Field> getAllFields(Class<?> base) {
        return FlagUtils.getAllFields(base, (Predicate<Field>)Predicates.alwaysTrue());
    }

    public static List<Field> getAllFields(Class<?> base, Predicate<Field> filter) {
        return FlagUtils.getLocalFields(FlagUtils.getAllAssignableTypes(base), filter);
    }

    public static List<Field> getLocalFields(List<Class<?>> classes) {
        return FlagUtils.getLocalFields(classes, (Predicate<Field>)Predicates.alwaysTrue());
    }

    @Deprecated
    public static List<Field> getLocalFields(List<Class<?>> classes, Closure<Boolean> filter) {
        return FlagUtils.getLocalFields(classes, (Predicate<Field>)GroovyJavaMethods.predicateFromClosure(filter));
    }

    public static List<Field> getLocalFields(List<Class<?>> classes, Predicate<Field> filter) {
        ArrayList fields = Lists.newArrayList();
        for (Class<?> c : classes) {
            for (Field f : c.getDeclaredFields()) {
                if (!filter.apply((Object)f)) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    public static List<Class<?>> getAllAssignableTypes(Class<?> base) {
        return FlagUtils.getAllAssignableTypes(base, new Predicate<Class<?>>(){

            public boolean apply(Class<?> it) {
                return it != Object.class && it != GroovyObject.class;
            }
        });
    }

    @Deprecated
    public static List<Class<?>> getAllAssignableTypes(Class<?> base, Closure<Boolean> filter) {
        return FlagUtils.getAllAssignableTypes(base, GroovyJavaMethods.predicateFromClosure(filter));
    }

    public static List<Class<?>> getAllAssignableTypes(Class<?> base, Predicate<Class<?>> filter) {
        ArrayList classes = Lists.newArrayList();
        for (Class<?> c = base; c != null; c = c.getSuperclass()) {
            if (!filter.apply(c)) continue;
            classes.add(c);
        }
        for (int i = 0; i < classes.size(); ++i) {
            for (Class<?> interf : ((Class)classes.get(i)).getInterfaces()) {
                if (!filter.apply(interf) || classes.contains(interf)) continue;
                classes.add(interf);
            }
        }
        return classes;
    }

    private static Map<String, Object> getFieldsWithFlagsInternal(Object o, Collection<Field> fields) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Field f : fields) {
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null) continue;
            String flagName = JavaGroovyEquivalents.elvis((String)cf.value(), (String)f.getName());
            if (JavaGroovyEquivalents.groovyTruth((String)flagName)) {
                result.put(flagName, FlagUtils.getField(o, f));
                continue;
            }
            log.warn("Ignoring field {} of object {} as no flag name available", (Object)f, o);
        }
        return result;
    }

    private static Field findFieldForFlagInternal(String flagName, Object o, Collection<Field> fields) {
        for (Field f : fields) {
            String contenderName;
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null || !flagName.equals(contenderName = JavaGroovyEquivalents.elvis((String)cf.value(), (String)f.getName()))) continue;
            return f;
        }
        throw new NoSuchElementException("Field with flag " + flagName + " not found on " + o + " of type " + (o != null ? o.getClass() : null));
    }

    private static boolean setFieldFromFlagInternal(String flagName, Object fieldVal, Object o, Collection<Field> fields) {
        for (Field f : fields) {
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null || !flagName.equals(JavaGroovyEquivalents.elvis((String)cf.value(), (String)f.getName()))) continue;
            FlagUtils.setField(o, f, fieldVal, cf);
            return true;
        }
        return false;
    }

    private static Map<String, ?> setFieldsFromFlagsInternal(Object o, Collection<Field> fields, Map<?, ?> flagsOrConfig, ConfigBag bag, boolean setDefaultVals) {
        if (bag == null) {
            bag = new ConfigBag().putAll(flagsOrConfig);
        }
        for (Field f : fields) {
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null) continue;
            FlagUtils.setFieldFromConfig(o, f, bag, cf, setDefaultVals);
        }
        return bag.getUnusedConfigMutable();
    }

    private static void setFieldFromConfig(Object o, Field f, ConfigBag bag, SetFromFlag optionalAnnotation, boolean setDefaultVals) {
        String flagName;
        String string = flagName = optionalAnnotation == null ? null : JavaGroovyEquivalents.elvis((String)optionalAnnotation.value(), (String)f.getName());
        if (JavaGroovyEquivalents.groovyTruth(flagName) && bag.containsKey(flagName)) {
            FlagUtils.setField(o, f, bag.getStringKey(flagName), optionalAnnotation);
            return;
        }
        ConfigKey<?> key = FlagUtils.getFieldAsConfigKey(o, f);
        if (key != null && bag.containsKey(key)) {
            Object uncoercedValue = bag.getObjKeyMaybe(key).get();
            FlagUtils.setField(o, f, uncoercedValue, optionalAnnotation);
            return;
        }
        if (setDefaultVals && optionalAnnotation != null && JavaGroovyEquivalents.groovyTruth((String)optionalAnnotation.defaultVal())) {
            try {
                f.setAccessible(true);
                Object oldValue = f.get(o);
                if (oldValue == null || oldValue.equals(FlagUtils.getDefaultValueForType(f.getType()))) {
                    FlagUtils.setField(o, f, optionalAnnotation.defaultVal(), optionalAnnotation);
                }
            }
            catch (Exception e) {
                Exceptions.propagate((Throwable)e);
            }
            return;
        }
    }

    private static ConfigKey<?> getFieldAsConfigKey(Object optionalInstance, Field f) {
        if (optionalInstance == null && (f.getModifiers() & 8) == 0) {
            return null;
        }
        if (ConfigKey.class.isAssignableFrom(f.getType())) {
            return (ConfigKey)FlagUtils.getField(optionalInstance, f);
        }
        if (ConfigKey.HasConfigKey.class.isAssignableFrom(f.getType())) {
            return ((ConfigKey.HasConfigKey)FlagUtils.getField(optionalInstance, f)).getConfigKey();
        }
        return null;
    }

    public static void setConfig(Object objectOfField, ConfigKey<?> key, Object value, SetFromFlag optionalAnnotation) {
        if (objectOfField instanceof Configurable) {
            ((Configurable)objectOfField).config().set(key, value);
            return;
        }
        if (optionalAnnotation == null) {
            log.warn("Cannot set key " + key.getName() + " on " + objectOfField + ": containing class is not Configurable");
        } else if (!key.getName().equals(optionalAnnotation.value())) {
            log.warn("Cannot set key " + key.getName() + " on " + objectOfField + " from flag " + optionalAnnotation.value() + ": containing class is not Configurable");
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot set key " + key.getName() + " on " + objectOfField + " from flag " + optionalAnnotation.value() + ": containing class is not Configurable");
        }
    }

    public static void setField(Object objectOfField, Field f, Object value, SetFromFlag optionalAnnotation) {
        try {
            Object newValue;
            Object oldValue;
            ConfigKey<?> key = FlagUtils.getFieldAsConfigKey(objectOfField, f);
            if (key != null) {
                FlagUtils.setConfig(objectOfField, key, value, optionalAnnotation);
                return;
            }
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if (optionalAnnotation != null && optionalAnnotation.immutable() && !Objects.equal((Object)(oldValue = f.get(objectOfField)), (Object)FlagUtils.getDefaultValueForType(f.getType())) && oldValue != value) {
                throw new IllegalStateException("Forbidden modification to immutable field " + f + " in " + objectOfField + ": attempting to change to " + value + " when was already " + oldValue);
            }
            if (optionalAnnotation != null && !optionalAnnotation.nullable() && value == null) {
                throw new IllegalArgumentException("Forbidden null assignment to non-nullable field " + f + " in " + objectOfField);
            }
            if (optionalAnnotation != null && (f.getModifiers() & 8) == 8) {
                log.warn("Setting static field " + f + " in " + objectOfField + " from flag " + optionalAnnotation.value() + ": discouraged");
            }
            try {
                newValue = TypeCoercions.coerce(value, f.getType());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot set " + f + " in " + objectOfField + " from type " + value.getClass() + " (" + value + "): " + e, e);
            }
            f.set(objectOfField, newValue);
            if (log.isTraceEnabled()) {
                log.trace("FlagUtils for " + objectOfField + ", setting field=" + f.getName() + "; val=" + value + "; newVal=" + newValue + "; key=" + key);
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Object getField(Object objectOfField, Field f) {
        try {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return f.get(objectOfField);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Object getDefaultValueForType(Class<?> t) {
        if (!t.isPrimitive()) {
            return null;
        }
        if (t == Integer.TYPE) {
            return 0;
        }
        if (t == Long.TYPE) {
            return 0L;
        }
        if (t == Double.TYPE) {
            return 0.0;
        }
        if (t == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (t == Byte.TYPE) {
            return (byte)0;
        }
        if (t == Short.TYPE) {
            return (short)0;
        }
        if (t == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (t == Boolean.TYPE) {
            return false;
        }
        throw new IllegalStateException("Class " + t + " is an unknown primitive.");
    }

    public static Map<Field, SetFromFlag> getAnnotatedFields(Class<?> type) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Field f : FlagUtils.getAllFields(type)) {
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null) continue;
            result.put(f, cf);
        }
        return result;
    }

    public static Map<ConfigKey<?>, SetFromFlag> getAnnotatedConfigKeys(Class<?> type) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        List<Field> fields = FlagUtils.getAllFields(type, new Predicate<Field>(){

            public boolean apply(Field f) {
                return f != null && ConfigKey.class.isAssignableFrom(f.getType()) && (f.getModifiers() & 8) != 0;
            }
        });
        for (Field f : fields) {
            ConfigKey<?> key;
            SetFromFlag cf = f.getAnnotation(SetFromFlag.class);
            if (cf == null || (key = FlagUtils.getFieldAsConfigKey(null, f)) == null) continue;
            result.put(key, cf);
        }
        return result;
    }

    public static Map<String, Object> getFieldsWithValues(Object o) {
        try {
            LinkedHashMap result = Maps.newLinkedHashMap();
            for (Map.Entry<Field, SetFromFlag> entry : FlagUtils.getAnnotatedFields(o.getClass()).entrySet()) {
                Field f = entry.getKey();
                SetFromFlag cf = entry.getValue();
                String flagName = JavaGroovyEquivalents.elvis((String)cf.value(), (String)f.getName());
                if (!JavaGroovyEquivalents.groovyTruth((String)flagName)) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                result.put(flagName, f.get(o));
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void checkRequiredFields(Object o) {
        try {
            LinkedHashSet unsetFields = Sets.newLinkedHashSet();
            for (Map.Entry<Field, SetFromFlag> entry : FlagUtils.getAnnotatedFields(o.getClass()).entrySet()) {
                Object v;
                Field f = entry.getKey();
                SetFromFlag cf = entry.getValue();
                if (cf.nullable()) continue;
                String flagName = JavaGroovyEquivalents.elvis((String)cf.value(), (String)f.getName());
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((v = f.get(o)) != null) continue;
                unsetFields.add(flagName);
            }
            if (JavaGroovyEquivalents.groovyTruth((Collection)unsetFields)) {
                throw new IllegalStateException("Missing required " + (unsetFields.size() > 1 ? "fields" : "field") + ": " + unsetFields);
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class FlagConfigKeyAndValueRecord {
        private String flagName = null;
        private ConfigKey<?> configKey = null;
        private Maybe<Object> flagValue = Maybe.absent();
        private Maybe<Object> configKeyValue = Maybe.absent();

        public String getFlagName() {
            return this.flagName;
        }

        public ConfigKey<?> getConfigKey() {
            return this.configKey;
        }

        public Maybe<Object> getFlagMaybeValue() {
            return this.flagValue;
        }

        public Maybe<Object> getConfigKeyMaybeValue() {
            return this.configKeyValue;
        }

        public Object getValueOrNullPreferringConfigKey() {
            return this.getConfigKeyMaybeValue().or(this.getFlagMaybeValue()).orNull();
        }

        public Object getValueOrNullPreferringFlag() {
            return this.getFlagMaybeValue().or(this.getConfigKeyMaybeValue()).orNull();
        }

        public boolean isValuePresent() {
            return this.flagValue.isPresent() || this.configKeyValue.isPresent();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("flag", (Object)this.flagName).add("configKey", this.configKey).add("flagValue", this.flagValue.orNull()).add("configKeyValue", this.configKeyValue.orNull()).toString();
        }
    }
}

