/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.mutex;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.util.core.mutex.SemaphoreWithOwners;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutexSupport
implements WithMutexes {
    private static final Logger log = LoggerFactory.getLogger(MutexSupport.class);
    private final Map<String, SemaphoreWithOwners> semaphores = new LinkedHashMap<String, SemaphoreWithOwners>();

    protected synchronized SemaphoreWithOwners getSemaphore(String mutexId) {
        return this.getSemaphore(mutexId, false);
    }

    protected synchronized SemaphoreWithOwners getSemaphore(String mutexId, boolean requestBeforeReturning) {
        SemaphoreWithOwners s = this.semaphores.get(mutexId);
        if (s == null) {
            s = new SemaphoreWithOwners(mutexId);
            this.semaphores.put(mutexId, s);
        }
        if (requestBeforeReturning) {
            s.indicateCallingThreadWillRequest();
        }
        return s;
    }

    public synchronized void cleanupMutex(String mutexId) {
        SemaphoreWithOwners s = this.semaphores.get(mutexId);
        if (!s.isInUse()) {
            this.semaphores.remove(mutexId);
        }
    }

    public synchronized void cleanup() {
        Iterator<SemaphoreWithOwners> si = this.semaphores.values().iterator();
        while (si.hasNext()) {
            SemaphoreWithOwners s = si.next();
            if (s.isInUse()) continue;
            si.remove();
        }
    }

    @Override
    public synchronized boolean hasMutex(String mutexId) {
        SemaphoreWithOwners s = this.semaphores.get(mutexId);
        if (s != null) {
            return s.isCallingThreadAnOwner();
        }
        return false;
    }

    @Override
    public void acquireMutex(String mutexId, String description) throws InterruptedException {
        SemaphoreWithOwners s = this.getSemaphore(mutexId, true);
        if (description != null) {
            Tasks.setBlockingDetails(description + " - waiting for " + mutexId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Acquiring mutex: " + mutexId + "@" + this + " - " + description);
        }
        s.acquire();
        if (description != null) {
            Tasks.setBlockingDetails(null);
        }
        s.setDescription(description);
        if (log.isDebugEnabled()) {
            log.debug("Acquired mutex: " + mutexId + "@" + this + " - " + description);
        }
    }

    @Override
    public boolean tryAcquireMutex(String mutexId, String description) {
        SemaphoreWithOwners s = this.getSemaphore(mutexId, true);
        if (s.tryAcquire()) {
            if (log.isDebugEnabled()) {
                log.debug("Acquired mutex (opportunistic): " + mutexId + "@" + this + " - " + description);
            }
            s.setDescription(description);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseMutex(String mutexId) {
        SemaphoreWithOwners s;
        if (log.isDebugEnabled()) {
            log.debug("Releasing mutex: " + mutexId + "@" + this);
        }
        MutexSupport mutexSupport = this;
        synchronized (mutexSupport) {
            s = this.semaphores.get(mutexId);
        }
        if (s == null) {
            throw new IllegalStateException("No mutex known for '" + mutexId + "'");
        }
        s.release();
        this.cleanupMutex(mutexId);
    }

    public synchronized String toString() {
        return super.toString() + "[" + this.semaphores.size() + " semaphores: " + this.semaphores.values() + "]";
    }

    public synchronized Map<String, SemaphoreWithOwners> getAllSemaphores() {
        return ImmutableMap.copyOf(this.semaphores);
    }
}

