/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.AbstractExecutionContext;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.InterruptingImmediateSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutionContext
extends AbstractExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutionContext.class);
    static final ThreadLocal<BasicExecutionContext> perThreadExecutionContext = new ThreadLocal();
    final ExecutionManager executionManager;
    final Set<Object> tags = new LinkedHashSet<Object>();

    public static BasicExecutionContext getCurrentExecutionContext() {
        return perThreadExecutionContext.get();
    }

    public BasicExecutionContext(ExecutionManager executionManager) {
        this(Collections.emptyMap(), executionManager);
    }

    public BasicExecutionContext(Map<?, ?> flags, ExecutionManager executionManager) {
        this.executionManager = executionManager;
        if (flags.get("tag") != null) {
            this.tags.add(flags.remove("tag"));
        }
        if (flags.containsKey("tags")) {
            this.tags.addAll((Collection)flags.remove("tags"));
        }
        for (Object tag : this.tags) {
            if (!(tag instanceof BrooklynTaskTags.WrappedEntity) || !Proxy.isProxyClass(((BrooklynTaskTags.WrappedEntity)tag).entity.getClass())) continue;
            log.warn("" + this + " has entity proxy in " + tag);
        }
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public Set<Task<?>> getTasks() {
        return this.executionManager.getTasksWithAllTags(this.tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Maybe<T> getImmediately(Object callableOrSupplier) {
        BasicTask fakeTaskForContext;
        if (callableOrSupplier instanceof BasicTask) {
            fakeTaskForContext = (BasicTask)callableOrSupplier;
            if (fakeTaskForContext.isQueuedOrSubmitted()) {
                if (fakeTaskForContext.isDone()) {
                    return Maybe.of(fakeTaskForContext.getUnchecked());
                }
                throw new ImmediateSupplier.ImmediateUnsupportedException("Task is in progress and incomplete: " + fakeTaskForContext);
            }
            callableOrSupplier = fakeTaskForContext.getJob();
        } else {
            fakeTaskForContext = new BasicTask((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)"immediate evaluation"));
        }
        fakeTaskForContext.tags.addAll(this.tags);
        fakeTaskForContext.tags.add("IMMEDIATE");
        fakeTaskForContext.tags.add("TRANSIENT");
        Task<?> previousTask = BasicExecutionManager.getPerThreadCurrentTask().get();
        BasicExecutionContext oldExecutionContext = BasicExecutionContext.getCurrentExecutionContext();
        this.registerPerThreadExecutionContext();
        if (previousTask != null) {
            fakeTaskForContext.setSubmittedByTask(previousTask);
        }
        fakeTaskForContext.cancel();
        try {
            BasicExecutionManager.getPerThreadCurrentTask().set(fakeTaskForContext);
            if (!(callableOrSupplier instanceof ImmediateSupplier)) {
                callableOrSupplier = InterruptingImmediateSupplier.of(callableOrSupplier);
            }
            boolean wasAlreadyInterrupted = Thread.interrupted();
            try {
                Maybe maybe = ((ImmediateSupplier)callableOrSupplier).getImmediately();
                if (wasAlreadyInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return maybe;
            }
            catch (Throwable throwable) {
                if (wasAlreadyInterrupted) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
        }
        finally {
            BasicExecutionManager.getPerThreadCurrentTask().set(previousTask);
            perThreadExecutionContext.set(oldExecutionContext);
        }
    }

    @Override
    protected <T> Task<T> submitInternal(Map<?, ?> propertiesQ, Object task) {
        EntitlementContext entitlementContext;
        if (task instanceof TaskAdaptable && !(task instanceof Task)) {
            return this.submitInternal(propertiesQ, ((TaskAdaptable)task).asTask());
        }
        MutableMap properties = MutableMap.copyOf(propertiesQ);
        ArrayList<Object> taskTags = properties.get("tags") == null ? new ArrayList<Object>() : new ArrayList((Collection)properties.get("tags"));
        properties.put("tags", taskTags);
        if (task instanceof Task) {
            taskTags.addAll(((Task)task).getTags());
        }
        Entity target = BrooklynTaskTags.getWrappedEntityOfType(taskTags, "targetEntity");
        this.checkUserSuppliedContext(task, taskTags);
        if (target != null && !this.tags.contains(BrooklynTaskTags.tagForContextEntity(target))) {
            ExecutionContext tc = ((EntityInternal)target).getExecutionContext();
            if (log.isDebugEnabled()) {
                log.debug("Switching task context on execution of " + task + ": from " + this + " to " + target + " (in " + Tasks.current() + ")");
            }
            if (task instanceof Task) {
                final Task t = (Task)task;
                if (!(Tasks.isQueuedOrSubmitted(t) || Tasks.current() instanceof HasTaskChildren && Iterables.contains((Iterable)((HasTaskChildren)Tasks.current()).getChildren(), (Object)t))) {
                    return this.submit(Tasks.builder().displayName("Cross-context execution: " + t.getDescription()).dynamic(true).body(new Callable<T>(){

                        @Override
                        public T call() {
                            return DynamicTasks.get(t);
                        }
                    }).build());
                }
                return tc.submit((TaskAdaptable)t);
            }
            this.submit(Tasks.builder().displayName("Cross-context execution").dynamic(true).body(() -> {
                if (task instanceof Callable) {
                    return DynamicTasks.queue(Tasks.builder().dynamic(false).body((Callable)task).build()).getUnchecked();
                }
                if (task instanceof Runnable) {
                    return DynamicTasks.queue(Tasks.builder().dynamic(false).body((Runnable)task).build()).getUnchecked();
                }
                throw new IllegalArgumentException("Unhandled task type: " + task + "; type=" + (task != null ? task.getClass() : "null"));
            }).build());
        }
        if ((entitlementContext = BrooklynTaskTags.getEntitlement(taskTags)) == null) {
            entitlementContext = Entitlements.getEntitlementContext();
        }
        if (entitlementContext != null) {
            taskTags.add(BrooklynTaskTags.tagForEntitlement(entitlementContext));
        }
        taskTags.addAll(this.tags);
        if (Tasks.current() != null && BrooklynTaskTags.isTransient(Tasks.current()) && !taskTags.contains("NON-TRANSIENT") && !taskTags.contains("TRANSIENT")) {
            taskTags.add("TRANSIENT");
        }
        final Object startCallback = properties.get("newTaskStartCallback");
        properties.put("newTaskStartCallback", new Function<Task<?>, Void>(){

            public Void apply(Task<?> it) {
                BasicExecutionContext.this.registerPerThreadExecutionContext();
                if (startCallback != null) {
                    BasicExecutionManager.invokeCallback(startCallback, it);
                }
                return null;
            }
        });
        final Object endCallback = properties.get("newTaskEndCallback");
        properties.put("newTaskEndCallback", new Function<Task<?>, Void>(){

            public Void apply(Task<?> it) {
                try {
                    if (endCallback != null) {
                        BasicExecutionManager.invokeCallback(endCallback, it);
                    }
                }
                finally {
                    BasicExecutionContext.this.clearPerThreadExecutionContext();
                }
                return null;
            }
        });
        if (task instanceof Task) {
            return this.executionManager.submit((Map)properties, (TaskAdaptable)((Task)task));
        }
        if (task instanceof Callable) {
            return this.executionManager.submit((Map)properties, (Callable)task);
        }
        if (task instanceof Runnable) {
            return this.executionManager.submit((Map)properties, (Runnable)task);
        }
        throw new IllegalArgumentException("Unhandled task type: task=" + task + "; type=" + (task != null ? task.getClass() : "null"));
    }

    private void registerPerThreadExecutionContext() {
        perThreadExecutionContext.set(this);
    }

    private void clearPerThreadExecutionContext() {
        perThreadExecutionContext.remove();
    }

    private void checkUserSuppliedContext(Object task, Collection<Object> taskTags) {
        Entity taskContext = BrooklynTaskTags.getWrappedEntityOfType(taskTags, "contextEntity");
        Entity defaultContext = BrooklynTaskTags.getWrappedEntityOfType(this.tags, "contextEntity");
        if (taskContext != null) {
            if (log.isWarnEnabled()) {
                String msg = "Deprecated since 0.10.0. Task " + task + " is submitted for execution but has context entity (" + taskContext + ") tag set by the caller. ";
                if (taskContext != defaultContext) {
                    msg = msg + "The context entity of the execution context (" + this + ") the task is submitted on is " + defaultContext + " which is different. This will cause any of them to be used at random at runtime. ";
                    if (task instanceof BasicTask) {
                        msg = msg + "Fixing the context entity to the latter. ";
                    }
                }
                msg = msg + "Setting the context entity by the caller is not allowed. See the documentation on BrooklynTaskTags.tagForContextEntity(Entity) method for more details. Future Apache Brooklyn releases will throw an exception instead of logging a warning.";
                log.warn(msg);
            }
            BrooklynTaskTags.WrappedEntity contextTag = BrooklynTaskTags.tagForContextEntity(taskContext);
            while (taskTags.remove(contextTag)) {
            }
            if (task instanceof BasicTask) {
                Set<Object> mutableTags = ((BasicTask)BasicTask.class.cast(task)).getMutableTags();
                mutableTags.remove(contextTag);
            }
        }
    }

    public boolean isShutdown() {
        return this.getExecutionManager().isShutdown();
    }

    public String toString() {
        return super.toString() + "(" + this.tags + ")";
    }
}

