/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public class ValueResolverIterator<T>
implements Iterator<Maybe<Object>> {
    private static final Maybe<Object> NEXT_VALUE = Maybe.absent();
    private ValueResolver<T> resolver;
    private Maybe<Object> prev;
    private Maybe<Object> next;

    public ValueResolverIterator(ValueResolver<T> resolver) {
        this.resolver = resolver;
        this.prev = Maybe.of((Object)resolver.getOriginalValue());
        this.next = this.prev;
    }

    public Maybe<Object> peek() {
        return this.prev;
    }

    @Override
    public boolean hasNext() {
        this.fetchNext();
        return this.next != null;
    }

    @Override
    public Maybe<Object> next() {
        if (!this.hasNext()) {
            if (this.prev.isPresent()) {
                throw new NoSuchElementException("The value " + this.prev.get() + " is non-resolvable");
            }
            throw new NoSuchElementException("Last resolve failed: " + this.prev);
        }
        this.prev = this.next;
        this.next = NEXT_VALUE;
        return this.prev;
    }

    private void fetchNext() {
        if (this.next == NEXT_VALUE) {
            if (this.prev.isPresent()) {
                Object prevValue = this.prev.get();
                if (prevValue != null) {
                    ValueResolver<Object> nextResolver = this.createIterativeResolver(prevValue);
                    try {
                        this.next = nextResolver.getMaybe();
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        this.next = Maybe.absent((String)("Failed resolving " + this.prev + " with resolver " + this.resolver), (Throwable)e);
                    }
                    if (this.next.isPresent() && this.next.get() == this.prev.get()) {
                        this.next = null;
                    }
                } else {
                    this.next = null;
                }
            } else {
                this.next = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Operation not supported");
    }

    private ValueResolver<Object> createIterativeResolver(Object value) {
        return this.resolver.cloneReplacingValueAndType(value, Object.class).recursive(false);
    }

    public Maybe<Object> nextOrLast(Predicate<Object> stopCondition) {
        Maybe<Object> item;
        if (!this.hasNext()) {
            return this.prev;
        }
        do {
            if (!(item = this.next()).isAbsent() && !stopCondition.apply(item.get())) continue;
            return item;
        } while (this.hasNext());
        return item;
    }

    public Maybe<Object> nextOrLast(Class<?> type) {
        return this.nextOrLast((Predicate<Object>)Predicates.instanceOf(type));
    }

    public <S> Maybe<S> next(Class<S> type) {
        while (this.hasNext()) {
            Maybe<Object> item = this.next();
            if (!item.isAbsent() && !type.isInstance(item.get())) continue;
            Maybe<Object> typedItem = item;
            return typedItem;
        }
        return Maybe.absent((String)("Did not find items of type " + type + " in " + this.resolver));
    }

    public Maybe<T> last() {
        Maybe<Object> last = this.peek();
        while (this.hasNext()) {
            last = this.next();
            if (!last.isAbsent()) continue;
            return last;
        }
        return this.coerceValue(last, this.resolver.getType());
    }

    private Maybe<T> coerceValue(Maybe<Object> valueMaybe, Class<T> type) {
        if (valueMaybe.isPresent()) {
            T coercedValue = TypeCoercions.coerce(valueMaybe.get(), type);
            return Maybe.of(coercedValue);
        }
        Maybe<Object> uncheckedValue = valueMaybe;
        return uncheckedValue;
    }
}

