/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.collections;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -2463168443382874384L;
    private static final Logger log = LoggerFactory.getLogger(MutableMap.class);

    public static <K, V> MutableMap<K, V> of() {
        return new MutableMap<K, V>();
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        result.put(k6, v6);
        return result;
    }

    public static <K, V> MutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        MutableMap<K, V> result = new MutableMap<K, V>();
        result.put(k1, v1);
        result.put(k2, v2);
        result.put(k3, v3);
        result.put(k4, v4);
        result.put(k5, v5);
        result.put(k6, v6);
        result.put(k7, v7);
        return result;
    }

    public static <K, V> MutableMap<K, V> copyOf(@Nullable Map<? extends K, ? extends V> orig) {
        MutableMap<? extends K, ? extends V> result = new MutableMap<K, V>();
        if (orig != null) {
            result.putAll(orig);
        }
        return result;
    }

    public MutableMap() {
    }

    public MutableMap(Map source) {
        super(source);
    }

    public MutableMap<K, V> add(K key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableMap<K, V> add(@Nullable Map<? extends K, ? extends V> m) {
        if (m != null) {
            this.putAll(m);
        }
        return this;
    }

    public MutableMap<K, V> addIfNotNull(K key, V value) {
        if (key != null && value != null) {
            this.add(key, value);
        }
        return this;
    }

    public Maybe<V> getMaybe(K key) {
        if (this.containsKey(key)) {
            return Maybe.of(this.get(key));
        }
        return Maybe.absent("No entry for key '" + key + "' in this map");
    }

    @Deprecated
    public ImmutableMap<K, V> toImmutable() {
        return ImmutableMap.copyOf((Map)this);
    }

    public Map<K, V> asImmutableCopy() {
        try {
            return ImmutableMap.copyOf((Map)this);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            log.warn("Error converting list to Immutable, using unmodifiable instead: " + e, (Throwable)e);
            return this.asUnmodifiableCopy();
        }
    }

    public Map<K, V> asUnmodifiable() {
        return Collections.unmodifiableMap(this);
    }

    public Map<K, V> asUnmodifiableCopy() {
        return Collections.unmodifiableMap(MutableMap.copyOf(this));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        final MutableMap<K, V> result = new MutableMap();

        public Builder<K, V> put(K key, V value) {
            this.result.put(key, value);
            return this;
        }

        public Builder<K, V> putIfNotNull(K key, V value) {
            if (value != null) {
                this.result.put(key, value);
            }
            return this;
        }

        public Builder<K, V> putIfAbsent(K key, V value) {
            if (!this.result.containsKey(key)) {
                this.result.put(key, value);
            }
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            this.result.put(entry.getKey(), entry.getValue());
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            this.result.add(map);
            return this;
        }

        public Builder<K, V> remove(K key) {
            this.result.remove(key);
            return this;
        }

        public Builder<K, V> removeAll(K ... keys) {
            for (K key : keys) {
                this.result.remove(key);
            }
            return this;
        }

        public Builder<K, V> removeAll(Iterable<? extends K> keys) {
            for (K key : keys) {
                this.result.remove(key);
            }
            return this;
        }

        public Builder<K, V> renameKey(K oldKey, K newKey) {
            if (this.result.containsKey(oldKey)) {
                Object oldValue = this.result.remove(oldKey);
                this.result.put(newKey, oldValue);
            }
            return this;
        }

        public MutableMap<K, V> build() {
            return new MutableMap(this.result);
        }

        public Builder<K, V> filterValues(Predicate<? super V> filter) {
            Iterator iter = this.result.values().iterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (filter.apply(val)) continue;
                iter.remove();
            }
            return this;
        }

        public Builder<K, V> filterKeys(Predicate<? super K> filter) {
            Iterator iter = this.result.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (filter.apply(key)) continue;
                iter.remove();
            }
            return this;
        }
    }
}

