/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.io;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.io.FilePermissions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.StreamGobbler;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static boolean loggedSetFilePermissionsWarning = false;
    private static final FilePermissions permissions600 = new FilePermissions(384);
    private static final FilePermissions permissions700 = new FilePermissions(448);

    public static void setFilePermissionsTo700(File file) throws IOException {
        FileUtil.createNewFile(file);
        try {
            permissions700.apply(file);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set permissions to 700 for file {}", (Object)file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            FileUtil.logSetFilePermissionsFailure("700", file, ex);
        }
    }

    public static void setFilePermissionsTo600(File file) throws IOException {
        FileUtil.createNewFile(file);
        try {
            permissions600.apply(file);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set permissions to 600 for file {}", (Object)file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            FileUtil.logSetFilePermissionsFailure("600", file, ex);
        }
    }

    private static void logSetFilePermissionsFailure(String permissions, File file, IOException ex) {
        if (loggedSetFilePermissionsWarning) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to set permissions to {} for file {}: {}", new Object[]{permissions, file.getAbsolutePath(), ex});
            }
        } else {
            if (Os.isMicrosoftWindows()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to set permissions to {} for file {}; expected behaviour on Windows; {}; subsequent failures (on any file) will be logged at trace", new Object[]{permissions, file.getAbsolutePath(), ex});
                }
            } else {
                LOG.warn("Failed to set permissions to {} for file {}: {}; subsequent failures (on any file) will be logged at trace", new Object[]{permissions, file.getAbsolutePath(), ex});
            }
            loggedSetFilePermissionsWarning = true;
        }
    }

    public static void moveDir(File srcDir, File destDir) throws IOException, InterruptedException {
        if (!Os.isMicrosoftWindows()) {
            String cmd = "mv '" + srcDir.getAbsolutePath() + "' '" + destDir.getAbsolutePath() + "'";
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            if (proc.exitValue() == 0) {
                return;
            }
        }
        FileUtils.moveDirectory((File)srcDir, (File)destDir);
    }

    public static void copyDir(File srcDir, File destDir) throws IOException, InterruptedException {
        if (!Os.isMicrosoftWindows()) {
            String cmd = "cp -R '" + srcDir.getAbsolutePath() + "' '" + destDir.getAbsolutePath() + "'";
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            if (proc.exitValue() == 0) {
                return;
            }
        }
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    @Beta
    public static Maybe<String> getFilePermissions(File file) {
        if (!file.exists()) {
            return Maybe.absent("File " + file + " does not exist");
        }
        if (Os.isMicrosoftWindows()) {
            return Maybe.absent("Cannot determine permissions on windows");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        int exitcode = FileUtil.exec((List<String>)ImmutableList.of((Object)"ls", (Object)"-ld", (Object)file.getAbsolutePath()), out, err);
        if (exitcode != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not determine permissions of file " + file + "; exit code " + exitcode + "; stderr " + new String(err.toByteArray()));
            }
            return Maybe.absent("Could not determine permission of file " + file + "; exit code " + exitcode);
        }
        String stdout = new String(out.toByteArray());
        return stdout.trim().isEmpty() ? Maybe.absent("empty output") : Maybe.of(stdout.split("\\s")[0]);
    }

    @Beta
    public static void copyTo(InputStream in, File dest) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            Streams.copy(in, out);
        }
        catch (FileNotFoundException e) {
            try {
                throw Exceptions.propagate(e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(out);
                throw throwable;
            }
        }
        Streams.closeQuietly(out);
    }

    private static int exec(List<String> cmds, OutputStream out, OutputStream err) {
        int n;
        StreamGobbler errgobbler = null;
        StreamGobbler outgobbler = null;
        ProcessBuilder pb = new ProcessBuilder(cmds);
        try {
            Process p = pb.start();
            if (out != null) {
                InputStream outstream = p.getInputStream();
                outgobbler = new StreamGobbler(outstream, out, (Logger)null);
                outgobbler.start();
            }
            if (err != null) {
                InputStream errstream = p.getErrorStream();
                errgobbler = new StreamGobbler(errstream, err, (Logger)null);
                errgobbler.start();
            }
            int result = p.waitFor();
            if (outgobbler != null) {
                outgobbler.blockUntilFinished();
            }
            if (errgobbler != null) {
                errgobbler.blockUntilFinished();
            }
            n = result;
        }
        catch (Exception e) {
            try {
                throw Exceptions.propagate(e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(outgobbler);
                Streams.closeQuietly(errgobbler);
                throw throwable;
            }
        }
        Streams.closeQuietly(outgobbler);
        Streams.closeQuietly(errgobbler);
        return n;
    }

    private static boolean createNewFile(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file.createNewFile();
    }
}

