/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.text.StringEscapes;

public class PrimitiveStringTypeCoercions {
    public static <T> Maybe<T> tryCoerce(Object value, Class<? super T> targetType) {
        if (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType) && PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass())) {
            return Maybe.of(PrimitiveStringTypeCoercions.castPrimitive(value, targetType));
        }
        if (value instanceof String && PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType)) {
            return Maybe.of(PrimitiveStringTypeCoercions.stringToPrimitive((String)value, targetType));
        }
        if (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass()) && targetType.equals(String.class)) {
            return Maybe.of(value.toString());
        }
        String targetTypeSimpleName = JavaClassNames.verySimpleClassName(targetType);
        if (targetTypeSimpleName != null && targetTypeSimpleName.length() > 0) {
            for (Method m : value.getClass().getMethods()) {
                if (!m.getName().startsWith("as") || m.getParameterTypes().length != 0 || !targetType.isAssignableFrom(m.getReturnType()) || !m.getName().equals("as" + JavaClassNames.verySimpleClassName(m.getReturnType()))) continue;
                try {
                    return Maybe.of(m.invoke(value, new Object[0]));
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): " + m.getName() + " adapting failed, " + e));
                }
            }
        }
        return null;
    }

    public static <T> T castPrimitive(Object value, Class<T> targetType) {
        Class targetWrapType;
        if (value == null) {
            return null;
        }
        assert (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(targetType)) : "targetType=" + targetType;
        assert (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass())) : "value=" + targetType + "; valueType=" + value.getClass();
        Class sourceWrapType = Primitives.wrap(value.getClass());
        if (sourceWrapType == (targetWrapType = Primitives.wrap(targetType))) {
            return (T)value;
        }
        if (targetWrapType == Boolean.class) {
            if (sourceWrapType == Character.class) {
                return PrimitiveStringTypeCoercions.stringToPrimitive(value.toString(), targetType);
            }
            throw new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType);
        }
        if (sourceWrapType == Boolean.class) {
            throw new ClassCoercionException("Cannot cast " + sourceWrapType + " (" + value + ") to " + targetType);
        }
        long v = 0L;
        boolean islong = true;
        if (sourceWrapType == Character.class) {
            v = ((Character)value).charValue();
        } else if (sourceWrapType == Byte.class) {
            v = ((Byte)value).byteValue();
        } else if (sourceWrapType == Short.class) {
            v = ((Short)value).shortValue();
        } else if (sourceWrapType == Integer.class) {
            v = ((Integer)value).intValue();
        } else if (sourceWrapType == Long.class) {
            v = (Long)value;
        } else {
            islong = false;
        }
        if (islong) {
            if (targetWrapType == Character.class) {
                return (T)Character.valueOf((char)v);
            }
            if (targetWrapType == Byte.class) {
                return (T)Byte.valueOf((byte)v);
            }
            if (targetWrapType == Short.class) {
                return (T)Short.valueOf((short)v);
            }
            if (targetWrapType == Integer.class) {
                return (T)Integer.valueOf((int)v);
            }
            if (targetWrapType == Long.class) {
                return (T)Long.valueOf(v);
            }
            if (targetWrapType == Float.class) {
                return (T)Float.valueOf(v);
            }
            if (targetWrapType == Double.class) {
                return (T)Double.valueOf(v);
            }
            throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
        }
        double d = 0.0;
        boolean isdouble = true;
        if (sourceWrapType == Float.class) {
            d = ((Float)value).floatValue();
        } else if (sourceWrapType == Double.class) {
            d = (Double)value;
        } else {
            isdouble = false;
        }
        if (isdouble) {
            if (targetWrapType == Character.class) {
                return (T)Character.valueOf((char)d);
            }
            if (targetWrapType == Byte.class) {
                return (T)Byte.valueOf((byte)d);
            }
            if (targetWrapType == Short.class) {
                return (T)Short.valueOf((short)d);
            }
            if (targetWrapType == Integer.class) {
                return (T)Integer.valueOf((int)d);
            }
            if (targetWrapType == Long.class) {
                return (T)Long.valueOf((long)d);
            }
            if (targetWrapType == Float.class) {
                return (T)Float.valueOf((float)d);
            }
            if (targetWrapType == Double.class) {
                return (T)Double.valueOf(d);
            }
            throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
        }
        throw new IllegalStateException("Unexpected: sourceType=" + sourceWrapType + "; targetType=" + targetWrapType);
    }

    public static boolean isPrimitiveOrBoxer(Class<?> type) {
        return Primitives.allPrimitiveTypes().contains(type) || Primitives.allWrapperTypes().contains(type);
    }

    public static <T> T stringToPrimitive(String value, Class<T> targetType) {
        assert (Primitives.allPrimitiveTypes().contains(targetType) || Primitives.allWrapperTypes().contains(targetType)) : "targetType=" + targetType;
        if (targetType == Character.class || targetType == Character.TYPE) {
            if (value.length() == 1) {
                return (T)Character.valueOf(value.charAt(0));
            }
            if (value.length() != 1) {
                throw new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            }
        }
        value = value.trim();
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            if ("true".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("no".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("t".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("f".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            if ("y".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("n".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            throw new ClassCoercionException("Cannot coerce type String to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
        }
        Class wrappedType = Primitives.allPrimitiveTypes().contains(targetType) ? Primitives.wrap(targetType) : targetType;
        try {
            return (T)wrappedType.getMethod("valueOf", String.class).invoke(null, value);
        }
        catch (Exception e) {
            ClassCoercionException tothrow = new ClassCoercionException("Cannot coerce " + StringEscapes.JavaStringEscapes.wrapJavaString(value) + " to " + targetType.getCanonicalName() + " (" + value + "): adapting failed");
            tothrow.initCause(e);
            throw tothrow;
        }
    }
}

