/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.javalang.coerce.CoerceFunctionals;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTryCoercions;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCoercerExtensible
implements TypeCoercer {
    private static final Logger log = LoggerFactory.getLogger(TypeCoercerExtensible.class);
    private final Table<Class<?>, Class<?>, Function<?, ?>> registry = HashBasedTable.create();
    private final List<TryCoercer> genericCoercers = Lists.newCopyOnWriteArrayList();

    protected TypeCoercerExtensible() {
    }

    public static TypeCoercerExtensible newDefault() {
        TypeCoercerExtensible result = TypeCoercerExtensible.newEmpty();
        new CommonAdaptorTypeCoercions(result).registerAllAdapters();
        new CommonAdaptorTryCoercions(result).registerAllAdapters();
        return result;
    }

    public static TypeCoercerExtensible newEmpty() {
        return new TypeCoercerExtensible();
    }

    @Override
    public <T> T coerce(Object value, Class<T> targetType) {
        return this.coerce(value, TypeToken.of(targetType));
    }

    public <T> T coerce(Object value, TypeToken<T> targetTypeToken) {
        return this.tryCoerce(value, targetTypeToken).get();
    }

    @Override
    public <T> Maybe<T> tryCoerce(Object input, Class<T> type) {
        return this.changeExceptionSupplier(this.tryCoerceInternal(input, null, type));
    }

    @Override
    public <T> Maybe<T> tryCoerce(Object value, TypeToken<T> targetTypeToken) {
        return this.changeExceptionSupplier(this.tryCoerceInternal(value, targetTypeToken, null));
    }

    protected <T> Maybe<T> changeExceptionSupplier(Maybe<T> result) {
        return Maybe.Absent.changeExceptionSupplier(result, ClassCoercionException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Maybe<T> tryCoerceInternal(Object value, TypeToken<T> targetTypeToken, Class<T> targetType) {
        if (value == null) {
            return Maybe.of(null);
        }
        Maybe<T> result = null;
        Maybe<T> firstError = null;
        targetType = TypeTokens.getRawType(targetTypeToken, targetType);
        if (targetTypeToken != null && targetTypeToken.getType() instanceof ParameterizedType) {
            if (value instanceof Iterable && Iterable.class.isAssignableFrom(targetType)) {
                result = this.tryCoerceIterable(value, targetTypeToken, targetType);
                if (result != null && result.isAbsent() && targetType.isInstance(value)) {
                    log.warn("Failed to coerce iterable from " + value.getClass().getName() + " to " + targetTypeToken + "; returning uncoerced result to preserve (deprecated) backwards compatibility", (Throwable)Maybe.getException(result));
                }
            } else if (value.getClass().isArray() && Iterable.class.isAssignableFrom(targetType)) {
                result = this.tryCoerceArray(value, targetTypeToken, targetType);
                if (result != null && result.isAbsent() && targetType.isInstance(value)) {
                    log.warn("Failed to coerce array from " + value.getClass().getName() + " to " + targetTypeToken + "; returning uncoerced result to preserve (deprecated) backwards compatibility", (Throwable)Maybe.getException(result));
                }
            } else if (value instanceof Map && Map.class.isAssignableFrom(targetType) && (result = this.tryCoerceMap(value, targetTypeToken)) != null && result.isAbsent() && targetType.isInstance(value)) {
                log.warn("Failed to coerce map from " + value.getClass().getName() + " to " + targetTypeToken + "; returning uncoerced result to preserve (deprecated) backwards compatibility", (Throwable)Maybe.getException(result));
            }
        }
        if (result != null && result.isPresent()) {
            return result;
        }
        if (result != null && firstError == null) {
            firstError = result;
        }
        if (targetType.isInstance(value)) {
            return Maybe.of(value);
        }
        targetTypeToken = TypeTokens.getTypeToken(targetTypeToken, targetType);
        for (TryCoercer coercer : this.genericCoercers) {
            result = coercer.tryCoerce(value, targetTypeToken);
            if (result != null && result.isPresent()) {
                return result;
            }
            if (result == null || firstError != null) continue;
            firstError = result;
        }
        Class<T> boxedT = (Class<T>)Boxing.PRIMITIVE_TO_BOXED.get(targetType);
        Class boxedVT = (Class)Boxing.PRIMITIVE_TO_BOXED.get(value.getClass());
        if (boxedT != null || boxedVT != null) {
            try {
                if (boxedT == null) {
                    boxedT = targetType;
                }
                Object boxedV = boxedVT == null ? value : boxedVT.getConstructor(value.getClass()).newInstance(value);
                return this.tryCoerce(boxedV, boxedT);
            }
            catch (Exception e) {
                return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass() + " to " + targetType.getCanonicalName() + " (" + value + "): unboxing failed", e));
            }
        }
        Table<Class<?>, Class<?>, Function<?, ?>> table = this.registry;
        synchronized (table) {
            Map adapters = this.registry.row(targetType);
            for (Map.Entry entry : adapters.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(value)) continue;
                try {
                    Object resultT = ((Function)entry.getValue()).apply(value);
                    if (!Objects.equal((Object)value, (Object)resultT) && targetTypeToken.getType() instanceof ParameterizedType) {
                        return this.tryCoerce(resultT, targetTypeToken);
                    }
                    return Maybe.of(resultT);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    if (log.isDebugEnabled()) {
                        log.debug("When coercing, registry adapter " + entry + " gave error on " + value + " -> " + targetType + " " + (firstError == null ? "(rethrowing)" : "(suppressing as there is already an error)") + ": " + e, (Throwable)e);
                    }
                    if (firstError != null) continue;
                    if (e instanceof ClassCoercionException) {
                        firstError = Maybe.absent(e);
                        continue;
                    }
                    firstError = Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass().getCanonicalName() + " to " + targetType.getCanonicalName() + " (" + value + ")", e));
                }
            }
        }
        if (firstError != null) {
            return firstError;
        }
        return Maybe.absent(new ClassCoercionException("Cannot coerce type " + value.getClass().getCanonicalName() + " to " + targetType.getCanonicalName() + " (" + value + "): no adapter known"));
    }

    protected <T> Maybe<T> tryCoerceMap(Object value, TypeToken<T> targetTypeToken) {
        if (!(value instanceof Map) || !Map.class.isAssignableFrom(targetTypeToken.getRawType())) {
            return null;
        }
        Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
        if (arguments.length != 2) {
            throw new IllegalStateException("Unexpected number of parameters in map type: " + arguments);
        }
        LinkedHashMap coerced = Maps.newLinkedHashMap();
        TypeToken mapKeyType = TypeToken.of((Type)arguments[0]);
        TypeToken mapValueType = TypeToken.of((Type)arguments[1]);
        int i = 0;
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Maybe<T> k = this.tryCoerce(entry.getKey(), mapKeyType);
            if (k.isAbsent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce key of entry " + i + " in " + value + " to " + targetTypeToken, ((Maybe.Absent)k).getException()));
            }
            Maybe<T> v = this.tryCoerce(entry.getValue(), mapValueType);
            if (v.isAbsent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce value of entry " + i + " in " + value + " to " + targetTypeToken, ((Maybe.Absent)v).getException()));
            }
            coerced.put(k.get(), v.get());
            ++i;
        }
        return Maybe.of(Maps.newLinkedHashMap((Map)coerced));
    }

    protected <T> Maybe<T> tryCoerceArray(Object value, TypeToken<T> targetTypeToken, Class<? super T> targetType) {
        List<?> listValue = Reflections.arrayToList(value);
        return this.tryCoerceIterable(listValue, targetTypeToken, targetType);
    }

    protected <T> Maybe<T> tryCoerceIterable(Object value, TypeToken<T> targetTypeToken, Class<? super T> targetType) {
        if (!(value instanceof Iterable) || !Iterable.class.isAssignableFrom(targetTypeToken.getRawType())) {
            return null;
        }
        Type[] arguments = ((ParameterizedType)targetTypeToken.getType()).getActualTypeArguments();
        if (arguments.length != 1) {
            return Maybe.absent(new IllegalStateException("Unexpected number of parameters in iterable type: " + arguments));
        }
        LinkedList coerced = Lists.newLinkedList();
        TypeToken listEntryType = TypeToken.of((Type)arguments[0]);
        int i = 0;
        for (Object entry : (Iterable)value) {
            Maybe<T> entryCoerced = this.tryCoerce(entry, listEntryType);
            if (!entryCoerced.isPresent()) {
                return Maybe.absent(new ClassCoercionException("Could not coerce entry " + i + " in " + value + " to " + targetTypeToken, ((Maybe.Absent)entryCoerced).getException()));
            }
            coerced.add(entryCoerced.get());
            ++i;
        }
        if (Set.class.isAssignableFrom(targetType)) {
            return Maybe.of(Sets.newLinkedHashSet((Iterable)coerced));
        }
        return Maybe.of(Lists.newArrayList((Iterable)coerced));
    }

    public <T> Function<Object, T> function(Class<T> type) {
        return new CoerceFunctionals.CoerceFunction<T>(this, type);
    }

    public synchronized <A, B> Function<? super A, B> registerAdapter(Class<A> sourceType, Class<B> targetType, Function<? super A, B> fn) {
        return (Function)this.registry.put(targetType, sourceType, fn);
    }

    @Beta
    public synchronized void registerAdapter(TryCoercer fn) {
        this.genericCoercers.add(fn);
    }
}

