/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.math;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.text.Strings;

public class MathFunctions {
    @Deprecated
    private static Function<Number, Integer> plusOld(final int addend) {
        return new Function<Number, Integer>(){

            public Integer apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.intValue() + addend;
            }
        };
    }

    @Deprecated
    private static Function<Number, Long> plusOld(final long addend) {
        return new Function<Number, Long>(){

            public Long apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.longValue() + addend;
            }
        };
    }

    @Deprecated
    private static Function<Number, Double> plusOld(final double addend) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() + addend;
            }
        };
    }

    @Deprecated
    private static Function<Number, Integer> timesOld(final int multiplicand) {
        return new Function<Number, Integer>(){

            public Integer apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.intValue() * multiplicand;
            }
        };
    }

    @Deprecated
    private static Function<Number, Long> timesOld(final long multiplicand) {
        return new Function<Number, Long>(){

            public Long apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.longValue() * multiplicand;
            }
        };
    }

    @Deprecated
    private static Function<Number, Double> timesOld(final double multiplicand) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() * multiplicand;
            }
        };
    }

    @Deprecated
    private static Function<Number, Double> divideOld(final double divisor) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() / divisor;
            }
        };
    }

    @Deprecated
    private static <T> Function<T, Double> divideOld(final Function<T, ? extends Number> input, final double divisor) {
        return new Function<T, Double>(){

            public Double apply(@Nullable T input2) {
                if (input == null) {
                    return null;
                }
                Number n = (Number)input.apply(input2);
                if (n == null) {
                    return null;
                }
                return n.doubleValue() / divisor;
            }
        };
    }

    @Deprecated
    private static Function<Number, String> readableStringOld(final int significantDigits, final int maxLen) {
        return new Function<Number, String>(){

            public String apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return Strings.makeRealString(input.doubleValue(), maxLen, significantDigits, 0);
            }
        };
    }

    @Deprecated
    private static Function<Number, String> percentOld(final int significantDigits) {
        return new Function<Number, String>(){

            public String apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return (String)MathFunctions.readableString(significantDigits, significantDigits + 3).apply((Object)(input.doubleValue() * 100.0)) + "%";
            }
        };
    }

    public static Function<Number, Integer> plus(int addend) {
        return new PlusInt(addend);
    }

    public static Function<Number, Long> plus(long addend) {
        return new PlusLong(addend);
    }

    public static Function<Number, Double> plus(double addend) {
        return new PlusDouble(addend);
    }

    public static Function<Number, Integer> times(int multiplicand) {
        return new TimesInt(multiplicand);
    }

    public static Function<Number, Long> times(long multiplicand) {
        return new TimesLong(multiplicand);
    }

    public static Function<Number, Double> times(double multiplicand) {
        return new TimesDouble(multiplicand);
    }

    public static Function<Number, Double> divide(double divisor) {
        return new DivideDouble(divisor);
    }

    @Deprecated
    public static <T> Function<T, Double> divide(Function<T, ? extends Number> preprocessor, double divisor) {
        return Functionals.chain(preprocessor, MathFunctions.divide(divisor));
    }

    public static Function<Number, String> readableString(int significantDigits, int maxLen) {
        return new ReadableString(significantDigits, maxLen);
    }

    public static Function<Number, String> percent(int significantDigits) {
        return new Percent(significantDigits);
    }

    private static class Percent
    implements Function<Number, String> {
        final int significantDigits;

        public Percent(int significantDigits) {
            this.significantDigits = significantDigits;
        }

        public String apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return (String)MathFunctions.readableString(this.significantDigits, this.significantDigits + 3).apply((Object)(input.doubleValue() * 100.0)) + "%";
        }
    }

    protected static class ReadableString
    implements Function<Number, String> {
        private final int significantDigits;
        private final int maxLen;

        public ReadableString(int significantDigits, int maxLen) {
            this.significantDigits = significantDigits;
            this.maxLen = maxLen;
        }

        public String apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return Strings.makeRealString(input.doubleValue(), this.maxLen, this.significantDigits, 0);
        }
    }

    protected static class DivideDouble
    implements Function<Number, Double> {
        private final double divisor;

        public DivideDouble(double divisor) {
            this.divisor = divisor;
        }

        public Double apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.doubleValue() / this.divisor;
        }
    }

    protected static class TimesDouble
    implements Function<Number, Double> {
        private final double multiplicand;

        public TimesDouble(double multiplicand) {
            this.multiplicand = multiplicand;
        }

        public Double apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.doubleValue() * this.multiplicand;
        }
    }

    protected static class TimesLong
    implements Function<Number, Long> {
        private final long multiplicand;

        public TimesLong(long multiplicand) {
            this.multiplicand = multiplicand;
        }

        public Long apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.longValue() * this.multiplicand;
        }
    }

    protected static class TimesInt
    implements Function<Number, Integer> {
        private final int multiplicand;

        public TimesInt(int multiplicand) {
            this.multiplicand = multiplicand;
        }

        public Integer apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.intValue() * this.multiplicand;
        }
    }

    protected static class PlusDouble
    implements Function<Number, Double> {
        private final double addend;

        public PlusDouble(double addend) {
            this.addend = addend;
        }

        public Double apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.doubleValue() + this.addend;
        }
    }

    protected static class PlusLong
    implements Function<Number, Long> {
        private final long addend;

        public PlusLong(long addend) {
            this.addend = addend;
        }

        public Long apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.longValue() + this.addend;
        }
    }

    protected static class PlusInt
    implements Function<Number, Integer> {
        private final int addend;

        public PlusInt(int addend) {
            this.addend = addend;
        }

        public Integer apply(@Nullable Number input) {
            if (input == null) {
                return null;
            }
            return input.intValue() + this.addend;
        }
    }
}

