/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.os;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.osgi.OsgiUtil;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Os {
    private static final Logger log = LoggerFactory.getLogger(Os.class);
    private static final int TEMP_DIR_ATTEMPTS = 1000;
    private static final char SEPARATOR_UNIX = '/';
    private static final char SEPARATOR_WIN = '\\';
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final boolean isMSWin = Os.testForMicrosoftWindows();
    private static TmpDirFinder tmpdir = new TmpDirFinder();
    private static final Map<String, FileDeletionHook> deletions = new LinkedHashMap<String, FileDeletionHook>();

    public static String tmp() {
        Maybe<String> tmp = tmpdir.get();
        if (tmp.isPresent()) {
            return tmp.get();
        }
        tmpdir.useWithWarning(System.getProperty("java.io.tmpdir"));
        return tmp.get();
    }

    public static String user() {
        return System.getProperty("user.name");
    }

    public static String home() {
        return System.getProperty("user.home");
    }

    public static String mergePathsUnix(String ... items) {
        return Urls.mergePaths(items);
    }

    public static String mergePaths(String ... items) {
        char separatorChar = '/';
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            if (Strings.isEmpty(item)) continue;
            if (result.length() > 0 && !Os.isSeparator(result.codePointAt(result.length() - 1))) {
                result.append(separatorChar);
            }
            result.append(item);
        }
        return result.toString();
    }

    @Beta
    public static DeletionResult deleteRecursively(File dir) {
        return Os.deleteRecursively(dir, false);
    }

    @Beta
    public static DeletionResult deleteRecursively(File dir, boolean skipSafetyChecks) {
        if (dir == null) {
            return new DeletionResult(null, true, null);
        }
        try {
            if (!skipSafetyChecks) {
                Os.checkSafe(dir);
            }
            FileUtils.deleteDirectory((File)dir);
            return new DeletionResult(dir, true, null);
        }
        catch (IllegalArgumentException e) {
            return new DeletionResult(dir, false, e);
        }
        catch (IOException e) {
            return new DeletionResult(dir, false, e);
        }
    }

    protected static void checkSafe(File dir) throws IOException {
        String dp = dir.getAbsolutePath();
        if ((dp = Strings.removeFromEnd(dp, "/")).length() <= 2) {
            throw new IOException("Refusing instruction to delete " + dir + ": name too short");
        }
        if (Os.home().equals(dp)) {
            throw new IOException("Refusing instruction to delete " + dir + ": it's the home directory");
        }
    }

    @Beta
    public static DeletionResult deleteRecursively(String dir) {
        if (dir == null) {
            return new DeletionResult(null, true, null);
        }
        return Os.deleteRecursively(new File(dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addShutdownFileDeletionHook(String path, FileDeletionHook hook) {
        Ordering.natural();
        Map<String, FileDeletionHook> map = deletions;
        synchronized (map) {
            FileDeletionHook oldHook;
            if (deletions.isEmpty()) {
                Thread shutdownHook = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        log.debug("Shutting down, deleting: " + deletions);
                        try {
                            Map map = deletions;
                            synchronized (map) {
                                ArrayList pathsToDelete = new ArrayList(deletions.keySet());
                                Collections.sort(pathsToDelete, Strings.lengthComparator().reverse());
                                for (String path : pathsToDelete) {
                                    try {
                                        ((FileDeletionHook)deletions.remove(path)).run();
                                    }
                                    catch (Exception e) {
                                        log.warn("Unable to delete '" + path + "' on shutdown: " + e);
                                        log.debug("Trace for shutdown deletion problem: " + e, (Throwable)e);
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            log.warn("Unable to delete one or more paths (" + deletions + ") on shutdown: " + e);
                            log.debug("Trace for shutdown deletion problem: " + e, (Throwable)e);
                        }
                    }
                };
                if (OsgiUtil.isBrooklynInsideFramework()) {
                    OsgiUtil.addShutdownHook(shutdownHook);
                } else {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
            }
            if ((oldHook = deletions.put(path, hook)) != null && oldHook.recursively) {
                deletions.put(path, oldHook);
            }
        }
    }

    public static void deleteOnExit(File directoryToDeleteIfEmptyOrFile) {
        Os.addShutdownFileDeletionHook(directoryToDeleteIfEmptyOrFile.getAbsolutePath(), new FileDeletionHook(directoryToDeleteIfEmptyOrFile, false));
    }

    public static void deleteOnExitRecursively(File directoryToCleanOrFile) {
        Os.addShutdownFileDeletionHook(directoryToCleanOrFile.getAbsolutePath(), new FileDeletionHook(directoryToCleanOrFile, true));
    }

    public static int deleteOnExitEmptyParentsUpTo(File subsubDirOrFile, File dir) {
        if (subsubDirOrFile == null || dir == null) {
            return 0;
        }
        ArrayList<File> dirsToDelete = new ArrayList<File>();
        File d = subsubDirOrFile;
        do {
            dirsToDelete.add(d);
        } while (!d.equals(dir) && (d = d.getParentFile()) != null);
        if (d == null) {
            log.warn("File " + subsubDirOrFile + " has no ancestor " + dir + ": will not attempt to clean up with ancestors on exit");
            return 0;
        }
        for (File f : dirsToDelete) {
            Os.deleteOnExit(f);
        }
        return dirsToDelete.size();
    }

    public static void deleteOnExitRecursivelyAndEmptyParentsUpTo(File directoryToCleanOrFile, File highestAncestorToDelete) {
        Os.deleteOnExitRecursively(directoryToCleanOrFile);
        Os.deleteOnExitEmptyParentsUpTo(directoryToCleanOrFile, highestAncestorToDelete);
    }

    public static File mkdirs(File dir) {
        dir.mkdirs();
        if (dir.isDirectory()) {
            return dir;
        }
        throw Exceptions.propagate(new IOException("Failed to create directory " + dir + (dir.isFile() ? "(is file)" : "")));
    }

    public static File writeToTempFile(InputStream is, String prefix, String suffix) {
        return Os.writeToTempFile(is, new File(Os.tmp()), prefix, suffix);
    }

    public static File writeToTempFile(InputStream is, File tempDir, String prefix, String suffix) {
        Preconditions.checkNotNull((Object)is, (String)"Input stream required to create temp file for %s*%s", (Object[])new Object[]{prefix, suffix});
        Os.mkdirs(tempDir);
        File tempFile = Os.newTempFile(prefix, suffix);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            ByteStreams.copy((InputStream)is, (OutputStream)out);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Streams.closeQuietly(is);
            Streams.closeQuietly(out);
        }
        return tempFile;
    }

    public static File writePropertiesToTempFile(Properties props, String prefix, String suffix) {
        return Os.writePropertiesToTempFile(props, new File(Os.tmp()), prefix, suffix);
    }

    public static File writePropertiesToTempFile(Properties props, File tempDir, String prefix, String suffix) {
        File tempFile;
        Preconditions.checkNotNull((Object)props, (String)"Properties required to create temp file for %s*%s", (Object[])new Object[]{prefix, suffix});
        try {
            tempFile = File.createTempFile(prefix, suffix, tempDir);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        tempFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            props.store(out, "Auto-generated by Brooklyn");
        }
        catch (IOException e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(out);
                throw throwable;
            }
        }
        Streams.closeQuietly(out);
        return tempFile;
    }

    public static String tidyPath(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Iterable segments = Splitter.on((String)"/").split((CharSequence)Files.simplifyPath((String)path));
        if (((String)Iterables.get((Iterable)segments, (int)0)).equals("~")) {
            segments = Iterables.concat((Iterable)ImmutableSet.of((Object)Os.home()), (Iterable)Iterables.skip((Iterable)segments, (int)1));
        }
        String result = Joiner.on((String)"/").join(segments);
        if (log.isTraceEnabled() && !result.equals(path)) {
            log.trace("Quietly changing '{}' to '{}'", (Object)path, (Object)result);
        }
        return result;
    }

    public static boolean isAbsolutish(String path) {
        return Strings.isNonBlank(path) && (path.codePointAt(0) == 47 || path.equals("~") || path.startsWith("~/") || path.length() >= 3 && path.codePointAt(1) == 58 && Os.isSeparator(path.codePointAt(2)));
    }

    @Deprecated
    public static boolean isAbsolute(String path) {
        return Os.isAbsolutish(path);
    }

    private static boolean isSeparator(int sep) {
        return sep == 47 || sep == 92;
    }

    public static String fromHome(String path) {
        return new File(Os.home(), path).getAbsolutePath();
    }

    public static String nativePath(String path) {
        return new File(path).getPath();
    }

    public static boolean isMicrosoftWindows() {
        return isMSWin;
    }

    private static boolean testForMicrosoftWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows");
    }

    public static File newTempFile(String prefix, String ext) {
        String extWithPrecedingSeparator;
        String sanitizedPrefix;
        String string = sanitizedPrefix = Strings.isNonEmpty(prefix) ? Strings.makeValidFilename(prefix) + "-" : "";
        if (sanitizedPrefix.length() > 101) {
            sanitizedPrefix = sanitizedPrefix.substring(0, 100) + "--";
        }
        String string2 = Strings.isNonEmpty(ext) ? (ext.startsWith(".") || ext.length() > 4 ? ext : "." + ext) : (extWithPrecedingSeparator = "");
        if (extWithPrecedingSeparator.length() > 13) {
            sanitizedPrefix = sanitizedPrefix.substring(0, 12) + "--";
        }
        try {
            File tempFile = File.createTempFile(sanitizedPrefix, extWithPrecedingSeparator, new File(Os.tmp()));
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static File newTempFile(Class<?> clazz, String ext) {
        return Os.newTempFile(JavaClassNames.cleanSimpleClassName(clazz), ext);
    }

    public static File newTempDir(String prefix) {
        String sanitizedPrefix = prefix == null ? "" : Strings.makeValidFilename(prefix) + "-";
        String tmpParent = Os.tmp();
        for (int i = 0; i < 1000; ++i) {
            String baseName = sanitizedPrefix + Identifiers.makeRandomId(4);
            File tempDir = new File(tmpParent, baseName);
            if (!tempDir.exists()) {
                if (tempDir.mkdir()) {
                    Os.deleteOnExitRecursively(tempDir);
                    return tempDir;
                }
                log.warn("Attempt to create temp dir failed " + tempDir + ". Either an IO error (disk full, no rights) or someone else created the folder after the !exists() check.");
                continue;
            }
            log.debug("Attempt to create temp dir failed, already exists " + tempDir + ". With ID of length 4 it is not unusual (15% chance) to have duplicate names at the 2000 samples mark.");
        }
        throw new IllegalStateException("cannot create temporary folders in parent " + tmpParent + " after " + 1000 + " attempts.");
    }

    public static File newTempDir(Class<?> clazz) {
        return Os.newTempDir(JavaClassNames.cleanSimpleClassName(clazz));
    }

    private static class FileDeletionHook {
        final File path;
        final boolean recursively;

        public FileDeletionHook(File f, boolean recursively) {
            this.path = f;
            this.recursively = recursively;
        }

        public void run() throws IOException {
            if (this.path.exists()) {
                if (this.recursively && this.path.isDirectory()) {
                    Os.deleteRecursively(this.path);
                } else {
                    this.path.delete();
                }
            }
        }
    }

    public static class DeletionResult {
        private final File file;
        private final boolean successful;
        private final Throwable throwable;

        public DeletionResult(File file, boolean successful, Throwable throwable) {
            this.file = file;
            this.successful = successful;
            this.throwable = throwable;
        }

        public boolean wasSuccessful() {
            return this.successful;
        }

        public DeletionResult throwIfFailed() {
            if (!this.successful) {
                throw Exceptions.propagate(new IOException("Unable to delete '" + this.file + "': delete returned false", this.throwable));
            }
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public <T> T asNullIgnoringError() {
            return null;
        }

        public <T> T asNullOrThrowing() {
            this.throwIfFailed();
            return null;
        }
    }

    public static class TmpDirFinder {
        public static String BROOKLYN_OS_TMPDIR_PROPERTY = "brooklyn.os.tmpdir";
        private String tmpdir = null;
        private boolean isFallback = false;

        public Maybe<String> get() {
            if (this.isFallback()) {
                log.debug("TmpDirFinder: using fallback tmp directory " + this.tmpdir, new Throwable("Caller using fallback tmp dir"));
            }
            if (this.isFound()) {
                return Maybe.of(this.tmpdir);
            }
            if (this.find()) {
                return Maybe.of(this.tmpdir);
            }
            return Maybe.absent(this.newFailure("TmpDirFinder: No valid tmp dir can be found"));
        }

        public boolean isFallback() {
            return this.isFallback;
        }

        public boolean useWithWarning(String dir) {
            if (this.tmpdir == null) {
                this.tmpdir = dir;
                this.isFallback = true;
                log.warn("Unable to find a valid tmp dir; will use " + dir + " but with caution! See (debug) messages marked TmpDirFinder for more information.");
                return true;
            }
            return false;
        }

        public boolean isFound() {
            return this.tmpdir != null;
        }

        protected synchronized boolean find() {
            String systmp;
            boolean systmpWeird;
            if (this.isFound()) {
                return true;
            }
            String customtmp = System.getProperty(BROOKLYN_OS_TMPDIR_PROPERTY);
            if (customtmp != null) {
                if (this.checkAndSet(customtmp)) {
                    return true;
                }
                log.warn("TmpDirFinder: Custom tmp directory '" + customtmp + "' in " + BROOKLYN_OS_TMPDIR_PROPERTY + " is not a valid tmp dir; ignoring");
            }
            boolean bl = systmpWeird = (systmp = System.getProperty("java.io.tmpdir")).contains("/var/") || systmp.startsWith("/private");
            if (!systmpWeird && this.checkAndSet(systmp)) {
                return true;
            }
            if (this.checkAndSet(File.separator + "tmp")) {
                return true;
            }
            if (systmpWeird && this.checkAndSet(systmp)) {
                return true;
            }
            try {
                String hometmp = Os.mergePaths(Os.home(), ".tmp");
                File hometmpF = new File(hometmp);
                hometmpF.mkdirs();
                if (this.checkAndSet(hometmp)) {
                    return true;
                }
            }
            catch (Exception e) {
                log.debug("TmpDirFinder: Cannot create tmp dir in user's home dir: " + e);
            }
            return false;
        }

        protected boolean checkAndSet(String candidate) {
            if (!this.check(candidate)) {
                return false;
            }
            this.tmpdir = candidate;
            log.debug("TmpDirFinder: Selected tmp dir '" + candidate + "' as the best tmp working space");
            return true;
        }

        protected boolean check(String candidate) {
            try {
                File f = new File(candidate);
                if (!f.exists()) {
                    log.debug("TmpDirFinder: Candidate tmp dir '" + candidate + "' does not exist");
                    return false;
                }
                if (!f.isDirectory()) {
                    log.debug("TmpDirFinder: Candidate tmp dir '" + candidate + "' is not a directory");
                    return false;
                }
                File f2 = new File(f, "brooklyn-tmp-check-" + Strings.makeRandomId(4));
                if (!f2.createNewFile()) {
                    log.debug("TmpDirFinder: Candidate tmp dir '" + candidate + "' cannot have files created inside it (" + f2 + ")");
                    return false;
                }
                if (!f2.delete()) {
                    log.debug("TmpDirFinder: Candidate tmp dir '" + candidate + "' cannot have files deleted inside it (" + f2 + ")");
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                log.debug("TmpDirFinder: Candidate tmp dir '" + candidate + "' is not valid: " + e);
                return false;
            }
        }

        protected IllegalStateException newFailure(String message) {
            return new IllegalStateException(message);
        }
    }
}

