/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.cactus.ServletTestCase;

public abstract class AbstractTestSuite
implements Test {
    private Vector tests = new Vector(10);
    private String name;
    static /* synthetic */ Class class$junit$framework$Test;

    public AbstractTestSuite() {
    }

    public AbstractTestSuite(Class theClass) {
        Constructor constructor;
        this.setName(theClass.getName());
        try {
            constructor = AbstractTestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        while ((class$junit$framework$Test == null ? AbstractTestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.addTestMethod(methods[i], names, constructor);
            }
            superClass = superClass.getSuperclass();
        }
        if (this.tests.size() == 0) {
            this.addTest(AbstractTestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public AbstractTestSuite(String theName) {
        this.setName(theName);
    }

    protected void addTest(Test theTest) {
        this.tests.addElement(theTest);
    }

    protected void addTestSuite(Class theTestClass) {
        this.addTest(this.createTestSuite(theTestClass));
    }

    private void addTestMethod(Method theMethod, Vector theNames, Constructor theConstructor) {
        String name = theMethod.getName();
        if (theNames.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(theMethod)) {
            theNames.addElement(name);
            try {
                Object constructorInstance;
                if (theConstructor.getParameterTypes().length == 0) {
                    constructorInstance = theConstructor.newInstance(new Object[0]);
                    if (constructorInstance instanceof TestCase) {
                        ((TestCase)constructorInstance).setName(name);
                    }
                } else {
                    constructorInstance = theConstructor.newInstance(name);
                }
                this.addTest((Test)new ServletTestCase(name, (Test)constructorInstance));
            }
            catch (InstantiationException e) {
                this.addTest(AbstractTestSuite.warning("Cannot instantiate test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
            catch (InvocationTargetException e) {
                this.addTest(AbstractTestSuite.warning("Exception in constructor: " + name + " (" + this.exceptionToString(e.getTargetException()) + ")"));
            }
            catch (IllegalAccessException e) {
                this.addTest(AbstractTestSuite.warning("Cannot access test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
        } else if (this.isTestMethod(theMethod)) {
            this.addTest(AbstractTestSuite.warning("Test method isn't public: " + theMethod.getName()));
        }
    }

    private String exceptionToString(Throwable theThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        theThrowable.printStackTrace(writer);
        return stringWriter.toString();
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private boolean isPublicTestMethod(Method theMethod) {
        return this.isTestMethod(theMethod) && Modifier.isPublic(theMethod.getModifiers());
    }

    private boolean isTestMethod(Method theMethod) {
        String name = theMethod.getName();
        Class<?>[] parameters = theMethod.getParameterTypes();
        Class<?> returnType = theMethod.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult theResult) {
        Enumeration e = this.tests();
        while (e.hasMoreElements() && !theResult.shouldStop()) {
            Test test = (Test)e.nextElement();
            this.runTest(test, theResult);
        }
    }

    protected void runTest(Test theTest, TestResult theResult) {
        theTest.run(theResult);
    }

    protected Test testAt(int theIndex) {
        return (Test)this.tests.elementAt(theIndex);
    }

    protected static Constructor getTestConstructor(Class theClass) throws NoSuchMethodException {
        Constructor result;
        try {
            result = theClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            result = theClass.getConstructor(new Class[0]);
        }
        return result;
    }

    protected int testCount() {
        return this.tests.size();
    }

    protected Enumeration tests() {
        return this.tests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    protected void setName(String theName) {
        this.name = theName;
    }

    protected String getName() {
        return this.name;
    }

    private static Test warning(final String theMessage) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)theMessage);
            }
        };
    }

    protected abstract Test createTestSuite(Class var1);

    protected abstract Test createCactusTestCase(String var1, Test var2);
}

