/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.cactus.Cookie;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.Authentication;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.util.ChainedRuntimeException;

public abstract class BaseWebRequest
implements WebRequest {
    private Configuration configuration;
    private Hashtable parametersPost = new Hashtable();
    private Hashtable parametersGet = new Hashtable();
    private Vector cookies = new Vector();
    private Hashtable headers = new Hashtable();
    private InputStream dataStream;
    private String contentType = "application/x-www-form-urlencoded";
    private Authentication authentication;

    public BaseWebRequest() {
    }

    public BaseWebRequest(Configuration theConfiguration) {
        this.configuration = theConfiguration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration theConfiguration) {
        this.configuration = theConfiguration;
    }

    public void setContentType(String theContentType) {
        this.contentType = theContentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setUserData(InputStream theDataStream) {
        this.dataStream = theDataStream;
    }

    public InputStream getUserData() {
        return this.dataStream;
    }

    /*
     * WARNING - void declaration
     */
    public void addParameter(String theName, String theValue, String theMethod) {
        void var4_4;
        Hashtable parameters;
        if (theMethod.equalsIgnoreCase("POST")) {
            parameters = this.parametersPost;
        } else if (theMethod.equalsIgnoreCase("GET")) {
            parameters = this.parametersGet;
        } else {
            throw new ChainedRuntimeException("The method need to be either \"POST\" or \"GET\"");
        }
        if (var4_4.containsKey(theName)) {
            Vector v = (Vector)var4_4.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            var4_4.put(theName, v);
        }
    }

    public void addParameter(String theName, String theValue) {
        this.addParameter(theName, theValue, "GET");
    }

    public Enumeration getParameterNamesPost() {
        return this.getParameterNames(this.parametersPost);
    }

    public Enumeration getParameterNamesGet() {
        return this.getParameterNames(this.parametersGet);
    }

    private Enumeration getParameterNames(Hashtable theParameters) {
        return theParameters.keys();
    }

    public String getParameterGet(String theName) {
        String[] values = this.getParameterValuesGet(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String getParameterPost(String theName) {
        String[] values = this.getParameterValuesPost(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValuesGet(String theName) {
        return this.getParameterValues(theName, this.parametersGet);
    }

    public String[] getParameterValuesPost(String theName) {
        return this.getParameterValues(theName, this.parametersPost);
    }

    private String[] getParameterValues(String theName, Hashtable theParameters) {
        if (theParameters.containsKey(theName)) {
            Vector v = (Vector)theParameters.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                result[i] = (String)objs[i];
            }
            return result;
        }
        return null;
    }

    public void addCookie(String theName, String theValue) {
        this.addCookie("localhost", theName, theValue);
    }

    public void addCookie(String theDomain, String theName, String theValue) {
        this.addCookie(new Cookie(theDomain, theName, theValue));
    }

    public void addCookie(Cookie theCookie) {
        if (theCookie == null) {
            throw new IllegalStateException("The cookie cannot be null");
        }
        this.cookies.addElement(theCookie);
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public void addHeader(String theName, String theValue) {
        if (theName.equalsIgnoreCase("Content-type")) {
            this.setContentType(theValue);
            return;
        }
        if (this.headers.containsKey(theName)) {
            Vector v = (Vector)this.headers.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            this.headers.put(theName, v);
        }
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public String getHeader(String theName) {
        String[] values = this.getHeaderValues(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getHeaderValues(String theName) {
        if (this.headers.containsKey(theName)) {
            Vector v = (Vector)this.headers.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                result[i] = (String)objs[i];
            }
            return result;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("cookies = [");
        buffer.append(this.toStringAppendCookies());
        buffer.append("], ");
        buffer.append("headers = [");
        buffer.append(this.toStringAppendHeaders());
        buffer.append("], ");
        buffer.append("GET parameters = [");
        buffer.append(this.toStringAppendParametersGet());
        buffer.append("], ");
        buffer.append("POST parameters = [");
        buffer.append(this.toStringAppendParametersPost());
        buffer.append("]");
        return buffer.toString();
    }

    private String toStringAppendHeaders() {
        StringBuffer buffer = new StringBuffer();
        Enumeration headers = this.getHeaderNames();
        while (headers.hasMoreElements()) {
            buffer.append("[");
            String headerName = (String)headers.nextElement();
            String[] headerValues = this.getHeaderValues(headerName);
            buffer.append("[" + headerName + "] = [");
            for (int i = 0; i < headerValues.length - 1; ++i) {
                buffer.append("[" + headerValues[i] + "], ");
            }
            buffer.append("[" + headerValues[headerValues.length - 1] + "]]");
            buffer.append("]");
        }
        return buffer.toString();
    }

    private String toStringAppendCookies() {
        StringBuffer buffer = new StringBuffer();
        Enumeration cookies = this.getCookies().elements();
        while (cookies.hasMoreElements()) {
            Cookie cookie = (Cookie)cookies.nextElement();
            buffer.append("[" + cookie + "]");
        }
        return buffer.toString();
    }

    private String toStringAppendParametersPost() {
        return this.toStringAppendParameters(this.parametersPost);
    }

    private String toStringAppendParametersGet() {
        return this.toStringAppendParameters(this.parametersGet);
    }

    private String toStringAppendParameters(Hashtable theParameters) {
        StringBuffer buffer = new StringBuffer();
        Enumeration parameters = this.getParameterNames(theParameters);
        while (parameters.hasMoreElements()) {
            buffer.append("[");
            String parameterName = (String)parameters.nextElement();
            String[] parameterValues = this.getParameterValues(parameterName, theParameters);
            buffer.append("[" + parameterName + "] = [");
            for (int i = 0; i < parameterValues.length - 1; ++i) {
                buffer.append("[" + parameterValues[i] + "], ");
            }
            buffer.append("[" + parameterValues[parameterValues.length - 1] + "]]");
            buffer.append("]");
        }
        return buffer.toString();
    }

    public void setAuthentication(Authentication theAuthentication) {
        this.authentication = theAuthentication;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }
}

