/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.ServiceEnumeration;

public class RequestDirectives {
    private WebRequest underlyingRequest;

    public RequestDirectives(WebRequest theRequest) {
        this.underlyingRequest = theRequest;
    }

    public void setClassName(String theName) {
        this.addDirective("Cactus_TestClass", theName);
    }

    public void setWrappedTestName(String theName) {
        this.addDirective("Cactus_WrappedTestClass", theName);
    }

    public void setMethodName(String theName) {
        this.addDirective("Cactus_TestMethod", theName);
    }

    public void setService(ServiceEnumeration theService) {
        this.addDirective("Cactus_Service", theService.toString());
    }

    public void setAutoSession(String isAutoSession) {
        this.addDirective("Cactus_AutomaticSession", isAutoSession);
    }

    private void addDirective(String theName, String theValue) throws IllegalArgumentException {
        if (!theName.startsWith("Cactus_")) {
            throw new IllegalArgumentException("Cactus directives must begin with [Cactus_]. The offending directive was [" + theName + "]");
        }
        this.underlyingRequest.addParameter(theName, theValue, "GET");
    }
}

